# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class CreateStaffingGroupAllocation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CreateStaffingGroupAllocation - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'staffing_group_id': 'str',
            'initial_shrinkage_percentage': 'float',
            'initial_attrition_percentage': 'float',
            'starting_weekly_full_time_equivalent_count': 'float'
        }

        self.attribute_map = {
            'staffing_group_id': 'staffingGroupId',
            'initial_shrinkage_percentage': 'initialShrinkagePercentage',
            'initial_attrition_percentage': 'initialAttritionPercentage',
            'starting_weekly_full_time_equivalent_count': 'startingWeeklyFullTimeEquivalentCount'
        }

        self._staffing_group_id = None
        self._initial_shrinkage_percentage = None
        self._initial_attrition_percentage = None
        self._starting_weekly_full_time_equivalent_count = None

    @property
    def staffing_group_id(self) -> str:
        """
        Gets the staffing_group_id of this CreateStaffingGroupAllocation.
        The ID of the staffing group used in this capacity plan

        :return: The staffing_group_id of this CreateStaffingGroupAllocation.
        :rtype: str
        """
        return self._staffing_group_id

    @staffing_group_id.setter
    def staffing_group_id(self, staffing_group_id: str) -> None:
        """
        Sets the staffing_group_id of this CreateStaffingGroupAllocation.
        The ID of the staffing group used in this capacity plan

        :param staffing_group_id: The staffing_group_id of this CreateStaffingGroupAllocation.
        :type: str
        """
        

        self._staffing_group_id = staffing_group_id

    @property
    def initial_shrinkage_percentage(self) -> float:
        """
        Gets the initial_shrinkage_percentage of this CreateStaffingGroupAllocation.
        The shrinkage percentage of the staffing group that can be used for all weeks in the planning period, in the scale of 0 - 100

        :return: The initial_shrinkage_percentage of this CreateStaffingGroupAllocation.
        :rtype: float
        """
        return self._initial_shrinkage_percentage

    @initial_shrinkage_percentage.setter
    def initial_shrinkage_percentage(self, initial_shrinkage_percentage: float) -> None:
        """
        Sets the initial_shrinkage_percentage of this CreateStaffingGroupAllocation.
        The shrinkage percentage of the staffing group that can be used for all weeks in the planning period, in the scale of 0 - 100

        :param initial_shrinkage_percentage: The initial_shrinkage_percentage of this CreateStaffingGroupAllocation.
        :type: float
        """
        

        self._initial_shrinkage_percentage = initial_shrinkage_percentage

    @property
    def initial_attrition_percentage(self) -> float:
        """
        Gets the initial_attrition_percentage of this CreateStaffingGroupAllocation.
        The attrition percentage of the staffing group that can be used for all weeks in the planning period, in the scale of 0 - 100

        :return: The initial_attrition_percentage of this CreateStaffingGroupAllocation.
        :rtype: float
        """
        return self._initial_attrition_percentage

    @initial_attrition_percentage.setter
    def initial_attrition_percentage(self, initial_attrition_percentage: float) -> None:
        """
        Sets the initial_attrition_percentage of this CreateStaffingGroupAllocation.
        The attrition percentage of the staffing group that can be used for all weeks in the planning period, in the scale of 0 - 100

        :param initial_attrition_percentage: The initial_attrition_percentage of this CreateStaffingGroupAllocation.
        :type: float
        """
        

        self._initial_attrition_percentage = initial_attrition_percentage

    @property
    def starting_weekly_full_time_equivalent_count(self) -> float:
        """
        Gets the starting_weekly_full_time_equivalent_count of this CreateStaffingGroupAllocation.
        The weekly count of full time equivalent agents in the staffing group that can be used for the first week of the planning period

        :return: The starting_weekly_full_time_equivalent_count of this CreateStaffingGroupAllocation.
        :rtype: float
        """
        return self._starting_weekly_full_time_equivalent_count

    @starting_weekly_full_time_equivalent_count.setter
    def starting_weekly_full_time_equivalent_count(self, starting_weekly_full_time_equivalent_count: float) -> None:
        """
        Sets the starting_weekly_full_time_equivalent_count of this CreateStaffingGroupAllocation.
        The weekly count of full time equivalent agents in the staffing group that can be used for the first week of the planning period

        :param starting_weekly_full_time_equivalent_count: The starting_weekly_full_time_equivalent_count of this CreateStaffingGroupAllocation.
        :type: float
        """
        

        self._starting_weekly_full_time_equivalent_count = starting_weekly_full_time_equivalent_count

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

