# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class CreateStaffingGroupRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CreateStaffingGroupRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'user_ids': 'list[str]',
            'management_unit_id': 'str',
            'planning_group_ids': 'list[str]'
        }

        self.attribute_map = {
            'name': 'name',
            'user_ids': 'userIds',
            'management_unit_id': 'managementUnitId',
            'planning_group_ids': 'planningGroupIds'
        }

        self._name = None
        self._user_ids = None
        self._management_unit_id = None
        self._planning_group_ids = None

    @property
    def name(self) -> str:
        """
        Gets the name of this CreateStaffingGroupRequest.
        The name of the staffing group

        :return: The name of this CreateStaffingGroupRequest.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this CreateStaffingGroupRequest.
        The name of the staffing group

        :param name: The name of this CreateStaffingGroupRequest.
        :type: str
        """
        

        self._name = name

    @property
    def user_ids(self) -> List[str]:
        """
        Gets the user_ids of this CreateStaffingGroupRequest.
        The set of user IDs to associate with the staffing group

        :return: The user_ids of this CreateStaffingGroupRequest.
        :rtype: list[str]
        """
        return self._user_ids

    @user_ids.setter
    def user_ids(self, user_ids: List[str]) -> None:
        """
        Sets the user_ids of this CreateStaffingGroupRequest.
        The set of user IDs to associate with the staffing group

        :param user_ids: The user_ids of this CreateStaffingGroupRequest.
        :type: list[str]
        """
        

        self._user_ids = user_ids

    @property
    def management_unit_id(self) -> str:
        """
        Gets the management_unit_id of this CreateStaffingGroupRequest.
        The ID of the management unit to which the staffing group users belong. If undefined the staffing group can include users from the entire business unit

        :return: The management_unit_id of this CreateStaffingGroupRequest.
        :rtype: str
        """
        return self._management_unit_id

    @management_unit_id.setter
    def management_unit_id(self, management_unit_id: str) -> None:
        """
        Sets the management_unit_id of this CreateStaffingGroupRequest.
        The ID of the management unit to which the staffing group users belong. If undefined the staffing group can include users from the entire business unit

        :param management_unit_id: The management_unit_id of this CreateStaffingGroupRequest.
        :type: str
        """
        

        self._management_unit_id = management_unit_id

    @property
    def planning_group_ids(self) -> List[str]:
        """
        Gets the planning_group_ids of this CreateStaffingGroupRequest.
        The set of planning group IDs to associate with the staffing group

        :return: The planning_group_ids of this CreateStaffingGroupRequest.
        :rtype: list[str]
        """
        return self._planning_group_ids

    @planning_group_ids.setter
    def planning_group_ids(self, planning_group_ids: List[str]) -> None:
        """
        Sets the planning_group_ids of this CreateStaffingGroupRequest.
        The set of planning group IDs to associate with the staffing group

        :param planning_group_ids: The planning_group_ids of this CreateStaffingGroupRequest.
        :type: list[str]
        """
        

        self._planning_group_ids = planning_group_ids

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

