# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import HrisTimeOffType

class CreateTimeOffPlanRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CreateTimeOffPlanRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'activity_code_ids': 'list[str]',
            'time_off_limit_ids': 'list[str]',
            'auto_approval_rule': 'str',
            'days_before_start_to_expire_from_waitlist': 'int',
            'hris_time_off_type': 'HrisTimeOffType',
            'active': 'bool'
        }

        self.attribute_map = {
            'name': 'name',
            'activity_code_ids': 'activityCodeIds',
            'time_off_limit_ids': 'timeOffLimitIds',
            'auto_approval_rule': 'autoApprovalRule',
            'days_before_start_to_expire_from_waitlist': 'daysBeforeStartToExpireFromWaitlist',
            'hris_time_off_type': 'hrisTimeOffType',
            'active': 'active'
        }

        self._name = None
        self._activity_code_ids = None
        self._time_off_limit_ids = None
        self._auto_approval_rule = None
        self._days_before_start_to_expire_from_waitlist = None
        self._hris_time_off_type = None
        self._active = None

    @property
    def name(self) -> str:
        """
        Gets the name of this CreateTimeOffPlanRequest.
        The name of this time off plan.

        :return: The name of this CreateTimeOffPlanRequest.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this CreateTimeOffPlanRequest.
        The name of this time off plan.

        :param name: The name of this CreateTimeOffPlanRequest.
        :type: str
        """
        

        self._name = name

    @property
    def activity_code_ids(self) -> List[str]:
        """
        Gets the activity_code_ids of this CreateTimeOffPlanRequest.
        The set of activity code IDs to associate with this time off plan.

        :return: The activity_code_ids of this CreateTimeOffPlanRequest.
        :rtype: list[str]
        """
        return self._activity_code_ids

    @activity_code_ids.setter
    def activity_code_ids(self, activity_code_ids: List[str]) -> None:
        """
        Sets the activity_code_ids of this CreateTimeOffPlanRequest.
        The set of activity code IDs to associate with this time off plan.

        :param activity_code_ids: The activity_code_ids of this CreateTimeOffPlanRequest.
        :type: list[str]
        """
        

        self._activity_code_ids = activity_code_ids

    @property
    def time_off_limit_ids(self) -> List[str]:
        """
        Gets the time_off_limit_ids of this CreateTimeOffPlanRequest.
        The set of time off limit IDs to associate with this time off plan.

        :return: The time_off_limit_ids of this CreateTimeOffPlanRequest.
        :rtype: list[str]
        """
        return self._time_off_limit_ids

    @time_off_limit_ids.setter
    def time_off_limit_ids(self, time_off_limit_ids: List[str]) -> None:
        """
        Sets the time_off_limit_ids of this CreateTimeOffPlanRequest.
        The set of time off limit IDs to associate with this time off plan.

        :param time_off_limit_ids: The time_off_limit_ids of this CreateTimeOffPlanRequest.
        :type: list[str]
        """
        

        self._time_off_limit_ids = time_off_limit_ids

    @property
    def auto_approval_rule(self) -> str:
        """
        Gets the auto_approval_rule of this CreateTimeOffPlanRequest.
        Auto approval rule for the time off plan.

        :return: The auto_approval_rule of this CreateTimeOffPlanRequest.
        :rtype: str
        """
        return self._auto_approval_rule

    @auto_approval_rule.setter
    def auto_approval_rule(self, auto_approval_rule: str) -> None:
        """
        Sets the auto_approval_rule of this CreateTimeOffPlanRequest.
        Auto approval rule for the time off plan.

        :param auto_approval_rule: The auto_approval_rule of this CreateTimeOffPlanRequest.
        :type: str
        """
        if isinstance(auto_approval_rule, int):
            auto_approval_rule = str(auto_approval_rule)
        allowed_values = ["Never", "Always", "CheckLimits", "CheckActivityCodes", "CheckLimitsAndActivityCodes"]
        if auto_approval_rule.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for auto_approval_rule -> " + auto_approval_rule)
            self._auto_approval_rule = "outdated_sdk_version"
        else:
            self._auto_approval_rule = auto_approval_rule

    @property
    def days_before_start_to_expire_from_waitlist(self) -> int:
        """
        Gets the days_before_start_to_expire_from_waitlist of this CreateTimeOffPlanRequest.
        The number of days before the time off request start date for when the request will be expired from the waitlist.

        :return: The days_before_start_to_expire_from_waitlist of this CreateTimeOffPlanRequest.
        :rtype: int
        """
        return self._days_before_start_to_expire_from_waitlist

    @days_before_start_to_expire_from_waitlist.setter
    def days_before_start_to_expire_from_waitlist(self, days_before_start_to_expire_from_waitlist: int) -> None:
        """
        Sets the days_before_start_to_expire_from_waitlist of this CreateTimeOffPlanRequest.
        The number of days before the time off request start date for when the request will be expired from the waitlist.

        :param days_before_start_to_expire_from_waitlist: The days_before_start_to_expire_from_waitlist of this CreateTimeOffPlanRequest.
        :type: int
        """
        

        self._days_before_start_to_expire_from_waitlist = days_before_start_to_expire_from_waitlist

    @property
    def hris_time_off_type(self) -> 'HrisTimeOffType':
        """
        Gets the hris_time_off_type of this CreateTimeOffPlanRequest.
        Time off type, if this time off plan is associated with the integration.

        :return: The hris_time_off_type of this CreateTimeOffPlanRequest.
        :rtype: HrisTimeOffType
        """
        return self._hris_time_off_type

    @hris_time_off_type.setter
    def hris_time_off_type(self, hris_time_off_type: 'HrisTimeOffType') -> None:
        """
        Sets the hris_time_off_type of this CreateTimeOffPlanRequest.
        Time off type, if this time off plan is associated with the integration.

        :param hris_time_off_type: The hris_time_off_type of this CreateTimeOffPlanRequest.
        :type: HrisTimeOffType
        """
        

        self._hris_time_off_type = hris_time_off_type

    @property
    def active(self) -> bool:
        """
        Gets the active of this CreateTimeOffPlanRequest.
        Whether this time off plan should be used by agents.

        :return: The active of this CreateTimeOffPlanRequest.
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active: bool) -> None:
        """
        Sets the active of this CreateTimeOffPlanRequest.
        Whether this time off plan should be used by agents.

        :param active: The active of this CreateTimeOffPlanRequest.
        :type: bool
        """
        

        self._active = active

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

