# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import GuestMemberInfo
    from . import JourneyContext
    from . import WebChatRoutingTarget

class CreateWebChatConversationRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CreateWebChatConversationRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'organization_id': 'str',
            'deployment_id': 'str',
            'routing_target': 'WebChatRoutingTarget',
            'member_info': 'GuestMemberInfo',
            'member_auth_token': 'str',
            'journey_context': 'JourneyContext'
        }

        self.attribute_map = {
            'organization_id': 'organizationId',
            'deployment_id': 'deploymentId',
            'routing_target': 'routingTarget',
            'member_info': 'memberInfo',
            'member_auth_token': 'memberAuthToken',
            'journey_context': 'journeyContext'
        }

        self._organization_id = None
        self._deployment_id = None
        self._routing_target = None
        self._member_info = None
        self._member_auth_token = None
        self._journey_context = None

    @property
    def organization_id(self) -> str:
        """
        Gets the organization_id of this CreateWebChatConversationRequest.
        The organization identifier.

        :return: The organization_id of this CreateWebChatConversationRequest.
        :rtype: str
        """
        return self._organization_id

    @organization_id.setter
    def organization_id(self, organization_id: str) -> None:
        """
        Sets the organization_id of this CreateWebChatConversationRequest.
        The organization identifier.

        :param organization_id: The organization_id of this CreateWebChatConversationRequest.
        :type: str
        """
        

        self._organization_id = organization_id

    @property
    def deployment_id(self) -> str:
        """
        Gets the deployment_id of this CreateWebChatConversationRequest.
        The web chat Deployment ID which contains the appropriate settings for this chat conversation.

        :return: The deployment_id of this CreateWebChatConversationRequest.
        :rtype: str
        """
        return self._deployment_id

    @deployment_id.setter
    def deployment_id(self, deployment_id: str) -> None:
        """
        Sets the deployment_id of this CreateWebChatConversationRequest.
        The web chat Deployment ID which contains the appropriate settings for this chat conversation.

        :param deployment_id: The deployment_id of this CreateWebChatConversationRequest.
        :type: str
        """
        

        self._deployment_id = deployment_id

    @property
    def routing_target(self) -> 'WebChatRoutingTarget':
        """
        Gets the routing_target of this CreateWebChatConversationRequest.
        The routing information to use for the new chat conversation.

        :return: The routing_target of this CreateWebChatConversationRequest.
        :rtype: WebChatRoutingTarget
        """
        return self._routing_target

    @routing_target.setter
    def routing_target(self, routing_target: 'WebChatRoutingTarget') -> None:
        """
        Sets the routing_target of this CreateWebChatConversationRequest.
        The routing information to use for the new chat conversation.

        :param routing_target: The routing_target of this CreateWebChatConversationRequest.
        :type: WebChatRoutingTarget
        """
        

        self._routing_target = routing_target

    @property
    def member_info(self) -> 'GuestMemberInfo':
        """
        Gets the member_info of this CreateWebChatConversationRequest.
        The guest member info to use for the new chat conversation.

        :return: The member_info of this CreateWebChatConversationRequest.
        :rtype: GuestMemberInfo
        """
        return self._member_info

    @member_info.setter
    def member_info(self, member_info: 'GuestMemberInfo') -> None:
        """
        Sets the member_info of this CreateWebChatConversationRequest.
        The guest member info to use for the new chat conversation.

        :param member_info: The member_info of this CreateWebChatConversationRequest.
        :type: GuestMemberInfo
        """
        

        self._member_info = member_info

    @property
    def member_auth_token(self) -> str:
        """
        Gets the member_auth_token of this CreateWebChatConversationRequest.
        If the guest member is an authenticated member (ie, not anonymous) his JWT is provided here. The token will have been previously generated with the \"POST /api/v2/signeddata\" resource.

        :return: The member_auth_token of this CreateWebChatConversationRequest.
        :rtype: str
        """
        return self._member_auth_token

    @member_auth_token.setter
    def member_auth_token(self, member_auth_token: str) -> None:
        """
        Sets the member_auth_token of this CreateWebChatConversationRequest.
        If the guest member is an authenticated member (ie, not anonymous) his JWT is provided here. The token will have been previously generated with the \"POST /api/v2/signeddata\" resource.

        :param member_auth_token: The member_auth_token of this CreateWebChatConversationRequest.
        :type: str
        """
        

        self._member_auth_token = member_auth_token

    @property
    def journey_context(self) -> 'JourneyContext':
        """
        Gets the journey_context of this CreateWebChatConversationRequest.
        A subset of the Journey System's data relevant to this conversation/session request (for external linkage and internal usage/context).

        :return: The journey_context of this CreateWebChatConversationRequest.
        :rtype: JourneyContext
        """
        return self._journey_context

    @journey_context.setter
    def journey_context(self, journey_context: 'JourneyContext') -> None:
        """
        Sets the journey_context of this CreateWebChatConversationRequest.
        A subset of the Journey System's data relevant to this conversation/session request (for external linkage and internal usage/context).

        :param journey_context: The journey_context of this CreateWebChatConversationRequest.
        :type: JourneyContext
        """
        

        self._journey_context = journey_context

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

