# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ValidationResult

class CsvUploadDetailsResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CsvUploadDetailsResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'upload_id': 'str',
            'file_name': 'str',
            'validation_result': 'ValidationResult'
        }

        self.attribute_map = {
            'upload_id': 'uploadId',
            'file_name': 'fileName',
            'validation_result': 'validationResult'
        }

        self._upload_id = None
        self._file_name = None
        self._validation_result = None

    @property
    def upload_id(self) -> str:
        """
        Gets the upload_id of this CsvUploadDetailsResponse.
        Id for the upload

        :return: The upload_id of this CsvUploadDetailsResponse.
        :rtype: str
        """
        return self._upload_id

    @upload_id.setter
    def upload_id(self, upload_id: str) -> None:
        """
        Sets the upload_id of this CsvUploadDetailsResponse.
        Id for the upload

        :param upload_id: The upload_id of this CsvUploadDetailsResponse.
        :type: str
        """
        

        self._upload_id = upload_id

    @property
    def file_name(self) -> str:
        """
        Gets the file_name of this CsvUploadDetailsResponse.
        File name for the upload

        :return: The file_name of this CsvUploadDetailsResponse.
        :rtype: str
        """
        return self._file_name

    @file_name.setter
    def file_name(self, file_name: str) -> None:
        """
        Sets the file_name of this CsvUploadDetailsResponse.
        File name for the upload

        :param file_name: The file_name of this CsvUploadDetailsResponse.
        :type: str
        """
        

        self._file_name = file_name

    @property
    def validation_result(self) -> 'ValidationResult':
        """
        Gets the validation_result of this CsvUploadDetailsResponse.
        Validation for the upload

        :return: The validation_result of this CsvUploadDetailsResponse.
        :rtype: ValidationResult
        """
        return self._validation_result

    @validation_result.setter
    def validation_result(self, validation_result: 'ValidationResult') -> None:
        """
        Sets the validation_result of this CsvUploadDetailsResponse.
        Validation for the upload

        :param validation_result: The validation_result of this CsvUploadDetailsResponse.
        :type: ValidationResult
        """
        

        self._validation_result = validation_result

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

