# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class CsvUploadPreviewResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CsvUploadPreviewResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'upload_id': 'str',
            'headers': 'list[str]',
            'entries': 'list[list[str]]'
        }

        self.attribute_map = {
            'upload_id': 'uploadId',
            'headers': 'headers',
            'entries': 'entries'
        }

        self._upload_id = None
        self._headers = None
        self._entries = None

    @property
    def upload_id(self) -> str:
        """
        Gets the upload_id of this CsvUploadPreviewResponse.
        Id for the upload

        :return: The upload_id of this CsvUploadPreviewResponse.
        :rtype: str
        """
        return self._upload_id

    @upload_id.setter
    def upload_id(self, upload_id: str) -> None:
        """
        Sets the upload_id of this CsvUploadPreviewResponse.
        Id for the upload

        :param upload_id: The upload_id of this CsvUploadPreviewResponse.
        :type: str
        """
        

        self._upload_id = upload_id

    @property
    def headers(self) -> List[str]:
        """
        Gets the headers of this CsvUploadPreviewResponse.
        List of headers in the CSV

        :return: The headers of this CsvUploadPreviewResponse.
        :rtype: list[str]
        """
        return self._headers

    @headers.setter
    def headers(self, headers: List[str]) -> None:
        """
        Sets the headers of this CsvUploadPreviewResponse.
        List of headers in the CSV

        :param headers: The headers of this CsvUploadPreviewResponse.
        :type: list[str]
        """
        

        self._headers = headers

    @property
    def entries(self) -> List[List[str]]:
        """
        Gets the entries of this CsvUploadPreviewResponse.
        List of entries in the CSV

        :return: The entries of this CsvUploadPreviewResponse.
        :rtype: list[list[str]]
        """
        return self._entries

    @entries.setter
    def entries(self, entries: List[List[str]]) -> None:
        """
        Sets the entries of this CsvUploadPreviewResponse.
        List of entries in the CSV

        :param entries: The entries of this CsvUploadPreviewResponse.
        :type: list[list[str]]
        """
        

        self._entries = entries

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

