# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class CsvUploadRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CsvUploadRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'file_name': 'str',
            'file_size': 'int'
        }

        self.attribute_map = {
            'file_name': 'fileName',
            'file_size': 'fileSize'
        }

        self._file_name = None
        self._file_size = None

    @property
    def file_name(self) -> str:
        """
        Gets the file_name of this CsvUploadRequest.
        Name of the file to upload

        :return: The file_name of this CsvUploadRequest.
        :rtype: str
        """
        return self._file_name

    @file_name.setter
    def file_name(self, file_name: str) -> None:
        """
        Sets the file_name of this CsvUploadRequest.
        Name of the file to upload

        :param file_name: The file_name of this CsvUploadRequest.
        :type: str
        """
        
        if len(file_name) > 256:
            raise ValueError("Invalid value for `file_name`, length must be less than `256`")

        if len(file_name) < 0:
            raise ValueError("Invalid value for `file_name`, length must be greater than or equal to `0`")


        self._file_name = file_name

    @property
    def file_size(self) -> int:
        """
        Gets the file_size of this CsvUploadRequest.
        The size of the upload file

        :return: The file_size of this CsvUploadRequest.
        :rtype: int
        """
        return self._file_size

    @file_size.setter
    def file_size(self, file_size: int) -> None:
        """
        Sets the file_size of this CsvUploadRequest.
        The size of the upload file

        :param file_size: The file_size of this CsvUploadRequest.
        :type: int
        """
        
        if file_size > 52428800:
            raise ValueError("Invalid value for `file_size`, must be a value less than or equal to `52428800`")


        self._file_size = file_size

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

