# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import Header

class CsvUploadResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CsvUploadResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'upload_id': 'str',
            'upload_url': 'str',
            'upload_headers': 'list[Header]'
        }

        self.attribute_map = {
            'upload_id': 'uploadId',
            'upload_url': 'uploadUrl',
            'upload_headers': 'uploadHeaders'
        }

        self._upload_id = None
        self._upload_url = None
        self._upload_headers = None

    @property
    def upload_id(self) -> str:
        """
        Gets the upload_id of this CsvUploadResponse.
        Id of the upload

        :return: The upload_id of this CsvUploadResponse.
        :rtype: str
        """
        return self._upload_id

    @upload_id.setter
    def upload_id(self, upload_id: str) -> None:
        """
        Sets the upload_id of this CsvUploadResponse.
        Id of the upload

        :param upload_id: The upload_id of this CsvUploadResponse.
        :type: str
        """
        

        self._upload_id = upload_id

    @property
    def upload_url(self) -> str:
        """
        Gets the upload_url of this CsvUploadResponse.
        Url for the upload

        :return: The upload_url of this CsvUploadResponse.
        :rtype: str
        """
        return self._upload_url

    @upload_url.setter
    def upload_url(self, upload_url: str) -> None:
        """
        Sets the upload_url of this CsvUploadResponse.
        Url for the upload

        :param upload_url: The upload_url of this CsvUploadResponse.
        :type: str
        """
        

        self._upload_url = upload_url

    @property
    def upload_headers(self) -> List['Header']:
        """
        Gets the upload_headers of this CsvUploadResponse.
        Required headers for the upload

        :return: The upload_headers of this CsvUploadResponse.
        :rtype: list[Header]
        """
        return self._upload_headers

    @upload_headers.setter
    def upload_headers(self, upload_headers: List['Header']) -> None:
        """
        Sets the upload_headers of this CsvUploadResponse.
        Required headers for the upload

        :param upload_headers: The upload_headers of this CsvUploadResponse.
        :type: list[Header]
        """
        

        self._upload_headers = upload_headers

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

