# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import DashboardsSharedWith
    from . import Widget

class DashboardConfiguration(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DashboardConfiguration - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'rows': 'int',
            'columns': 'int',
            'widgets': 'list[Widget]',
            'favorite': 'bool',
            'public_dashboard': 'bool',
            'restricted': 'bool',
            'layout_type': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'date_deleted': 'datetime',
            'created_by': 'AddressableEntityRef',
            'shared': 'bool',
            'dashboards_shared_with': 'DashboardsSharedWith',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'rows': 'rows',
            'columns': 'columns',
            'widgets': 'widgets',
            'favorite': 'favorite',
            'public_dashboard': 'publicDashboard',
            'restricted': 'restricted',
            'layout_type': 'layoutType',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'date_deleted': 'dateDeleted',
            'created_by': 'createdBy',
            'shared': 'shared',
            'dashboards_shared_with': 'dashboardsSharedWith',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._rows = None
        self._columns = None
        self._widgets = None
        self._favorite = None
        self._public_dashboard = None
        self._restricted = None
        self._layout_type = None
        self._date_created = None
        self._date_modified = None
        self._date_deleted = None
        self._created_by = None
        self._shared = None
        self._dashboards_shared_with = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this DashboardConfiguration.
        The globally unique identifier for the object.

        :return: The id of this DashboardConfiguration.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this DashboardConfiguration.
        The globally unique identifier for the object.

        :param id: The id of this DashboardConfiguration.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this DashboardConfiguration.
        The name of dashboard configuration.

        :return: The name of this DashboardConfiguration.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this DashboardConfiguration.
        The name of dashboard configuration.

        :param name: The name of this DashboardConfiguration.
        :type: str
        """
        

        self._name = name

    @property
    def rows(self) -> int:
        """
        Gets the rows of this DashboardConfiguration.
        The count of rows for the specific dashboard configuration.

        :return: The rows of this DashboardConfiguration.
        :rtype: int
        """
        return self._rows

    @rows.setter
    def rows(self, rows: int) -> None:
        """
        Sets the rows of this DashboardConfiguration.
        The count of rows for the specific dashboard configuration.

        :param rows: The rows of this DashboardConfiguration.
        :type: int
        """
        

        self._rows = rows

    @property
    def columns(self) -> int:
        """
        Gets the columns of this DashboardConfiguration.
        The count of columns for the specific dashboard.

        :return: The columns of this DashboardConfiguration.
        :rtype: int
        """
        return self._columns

    @columns.setter
    def columns(self, columns: int) -> None:
        """
        Sets the columns of this DashboardConfiguration.
        The count of columns for the specific dashboard.

        :param columns: The columns of this DashboardConfiguration.
        :type: int
        """
        

        self._columns = columns

    @property
    def widgets(self) -> List['Widget']:
        """
        Gets the widgets of this DashboardConfiguration.
        List of widgets for dashboard configuration.

        :return: The widgets of this DashboardConfiguration.
        :rtype: list[Widget]
        """
        return self._widgets

    @widgets.setter
    def widgets(self, widgets: List['Widget']) -> None:
        """
        Sets the widgets of this DashboardConfiguration.
        List of widgets for dashboard configuration.

        :param widgets: The widgets of this DashboardConfiguration.
        :type: list[Widget]
        """
        

        self._widgets = widgets

    @property
    def favorite(self) -> bool:
        """
        Gets the favorite of this DashboardConfiguration.
        The flag indicates if the dashboard is favorited by the user

        :return: The favorite of this DashboardConfiguration.
        :rtype: bool
        """
        return self._favorite

    @favorite.setter
    def favorite(self, favorite: bool) -> None:
        """
        Sets the favorite of this DashboardConfiguration.
        The flag indicates if the dashboard is favorited by the user

        :param favorite: The favorite of this DashboardConfiguration.
        :type: bool
        """
        

        self._favorite = favorite

    @property
    def public_dashboard(self) -> bool:
        """
        Gets the public_dashboard of this DashboardConfiguration.
        The flag to indicate if the dashboard is published by an user

        :return: The public_dashboard of this DashboardConfiguration.
        :rtype: bool
        """
        return self._public_dashboard

    @public_dashboard.setter
    def public_dashboard(self, public_dashboard: bool) -> None:
        """
        Sets the public_dashboard of this DashboardConfiguration.
        The flag to indicate if the dashboard is published by an user

        :param public_dashboard: The public_dashboard of this DashboardConfiguration.
        :type: bool
        """
        

        self._public_dashboard = public_dashboard

    @property
    def restricted(self) -> bool:
        """
        Gets the restricted of this DashboardConfiguration.
        The flag to indicate if the dashboard has any restricted data for that user

        :return: The restricted of this DashboardConfiguration.
        :rtype: bool
        """
        return self._restricted

    @restricted.setter
    def restricted(self, restricted: bool) -> None:
        """
        Sets the restricted of this DashboardConfiguration.
        The flag to indicate if the dashboard has any restricted data for that user

        :param restricted: The restricted of this DashboardConfiguration.
        :type: bool
        """
        

        self._restricted = restricted

    @property
    def layout_type(self) -> str:
        """
        Gets the layout_type of this DashboardConfiguration.
        The layout type of the dashboard

        :return: The layout_type of this DashboardConfiguration.
        :rtype: str
        """
        return self._layout_type

    @layout_type.setter
    def layout_type(self, layout_type: str) -> None:
        """
        Sets the layout_type of this DashboardConfiguration.
        The layout type of the dashboard

        :param layout_type: The layout_type of this DashboardConfiguration.
        :type: str
        """
        if isinstance(layout_type, int):
            layout_type = str(layout_type)
        allowed_values = ["Grid", "Flow"]
        if layout_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for layout_type -> " + layout_type)
            self._layout_type = "outdated_sdk_version"
        else:
            self._layout_type = layout_type

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this DashboardConfiguration.
        The created date of the dashboard. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this DashboardConfiguration.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this DashboardConfiguration.
        The created date of the dashboard. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this DashboardConfiguration.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this DashboardConfiguration.
        The last modified date of the dashboard. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this DashboardConfiguration.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this DashboardConfiguration.
        The last modified date of the dashboard. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this DashboardConfiguration.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def date_deleted(self) -> datetime:
        """
        Gets the date_deleted of this DashboardConfiguration.
        The deleted date of the dashboard. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_deleted of this DashboardConfiguration.
        :rtype: datetime
        """
        return self._date_deleted

    @date_deleted.setter
    def date_deleted(self, date_deleted: datetime) -> None:
        """
        Sets the date_deleted of this DashboardConfiguration.
        The deleted date of the dashboard. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_deleted: The date_deleted of this DashboardConfiguration.
        :type: datetime
        """
        

        self._date_deleted = date_deleted

    @property
    def created_by(self) -> 'AddressableEntityRef':
        """
        Gets the created_by of this DashboardConfiguration.
        The id of user who created the dashboard

        :return: The created_by of this DashboardConfiguration.
        :rtype: AddressableEntityRef
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by: 'AddressableEntityRef') -> None:
        """
        Sets the created_by of this DashboardConfiguration.
        The id of user who created the dashboard

        :param created_by: The created_by of this DashboardConfiguration.
        :type: AddressableEntityRef
        """
        

        self._created_by = created_by

    @property
    def shared(self) -> bool:
        """
        Gets the shared of this DashboardConfiguration.
        The flag to indicate if the dashboard is shared

        :return: The shared of this DashboardConfiguration.
        :rtype: bool
        """
        return self._shared

    @shared.setter
    def shared(self, shared: bool) -> None:
        """
        Sets the shared of this DashboardConfiguration.
        The flag to indicate if the dashboard is shared

        :param shared: The shared of this DashboardConfiguration.
        :type: bool
        """
        

        self._shared = shared

    @property
    def dashboards_shared_with(self) -> 'DashboardsSharedWith':
        """
        Gets the dashboards_shared_with of this DashboardConfiguration.
        The list of users and teams the dashboard is shared with

        :return: The dashboards_shared_with of this DashboardConfiguration.
        :rtype: DashboardsSharedWith
        """
        return self._dashboards_shared_with

    @dashboards_shared_with.setter
    def dashboards_shared_with(self, dashboards_shared_with: 'DashboardsSharedWith') -> None:
        """
        Sets the dashboards_shared_with of this DashboardConfiguration.
        The list of users and teams the dashboard is shared with

        :param dashboards_shared_with: The dashboards_shared_with of this DashboardConfiguration.
        :type: DashboardsSharedWith
        """
        

        self._dashboards_shared_with = dashboards_shared_with

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this DashboardConfiguration.
        The URI for this object

        :return: The self_uri of this DashboardConfiguration.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this DashboardConfiguration.
        The URI for this object

        :param self_uri: The self_uri of this DashboardConfiguration.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

