# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class DashboardConfigurationQueryRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DashboardConfigurationQueryRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'dashboard_configuration_ids': 'list[str]',
            'page_number': 'int',
            'page_size': 'int',
            'sort_by': 'str'
        }

        self.attribute_map = {
            'dashboard_configuration_ids': 'dashboardConfigurationIds',
            'page_number': 'pageNumber',
            'page_size': 'pageSize',
            'sort_by': 'sortBy'
        }

        self._dashboard_configuration_ids = None
        self._page_number = None
        self._page_size = None
        self._sort_by = None

    @property
    def dashboard_configuration_ids(self) -> List[str]:
        """
        Gets the dashboard_configuration_ids of this DashboardConfigurationQueryRequest.
        The user supplied dashboard configuration ids

        :return: The dashboard_configuration_ids of this DashboardConfigurationQueryRequest.
        :rtype: list[str]
        """
        return self._dashboard_configuration_ids

    @dashboard_configuration_ids.setter
    def dashboard_configuration_ids(self, dashboard_configuration_ids: List[str]) -> None:
        """
        Sets the dashboard_configuration_ids of this DashboardConfigurationQueryRequest.
        The user supplied dashboard configuration ids

        :param dashboard_configuration_ids: The dashboard_configuration_ids of this DashboardConfigurationQueryRequest.
        :type: list[str]
        """
        

        self._dashboard_configuration_ids = dashboard_configuration_ids

    @property
    def page_number(self) -> int:
        """
        Gets the page_number of this DashboardConfigurationQueryRequest.
        The page number of the queried response

        :return: The page_number of this DashboardConfigurationQueryRequest.
        :rtype: int
        """
        return self._page_number

    @page_number.setter
    def page_number(self, page_number: int) -> None:
        """
        Sets the page_number of this DashboardConfigurationQueryRequest.
        The page number of the queried response

        :param page_number: The page_number of this DashboardConfigurationQueryRequest.
        :type: int
        """
        

        self._page_number = page_number

    @property
    def page_size(self) -> int:
        """
        Gets the page_size of this DashboardConfigurationQueryRequest.
        The number of entities to return of the queried response. The max is 25

        :return: The page_size of this DashboardConfigurationQueryRequest.
        :rtype: int
        """
        return self._page_size

    @page_size.setter
    def page_size(self, page_size: int) -> None:
        """
        Sets the page_size of this DashboardConfigurationQueryRequest.
        The number of entities to return of the queried response. The max is 25

        :param page_size: The page_size of this DashboardConfigurationQueryRequest.
        :type: int
        """
        

        self._page_size = page_size

    @property
    def sort_by(self) -> str:
        """
        Gets the sort_by of this DashboardConfigurationQueryRequest.
        The order in which response will be sorted

        :return: The sort_by of this DashboardConfigurationQueryRequest.
        :rtype: str
        """
        return self._sort_by

    @sort_by.setter
    def sort_by(self, sort_by: str) -> None:
        """
        Sets the sort_by of this DashboardConfigurationQueryRequest.
        The order in which response will be sorted

        :param sort_by: The sort_by of this DashboardConfigurationQueryRequest.
        :type: str
        """
        if isinstance(sort_by, int):
            sort_by = str(sort_by)
        allowed_values = ["Asc", "Desc"]
        if sort_by.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for sort_by -> " + sort_by)
            self._sort_by = "outdated_sdk_version"
        else:
            self._sort_by = sort_by

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

