# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DatePickerAvailableDateTime

class DatePicker(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DatePicker - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'title': 'str',
            'subtitle': 'str',
            'date_picker_available_date_times': 'list[DatePickerAvailableDateTime]',
            'date_selected': 'datetime'
        }

        self.attribute_map = {
            'id': 'id',
            'title': 'title',
            'subtitle': 'subtitle',
            'date_picker_available_date_times': 'datePickerAvailableDateTimes',
            'date_selected': 'dateSelected'
        }

        self._id = None
        self._title = None
        self._subtitle = None
        self._date_picker_available_date_times = None
        self._date_selected = None

    @property
    def id(self) -> str:
        """
        Gets the id of this DatePicker.
        Optional unique identifier to help map component replies to form messages where multiple DatePickers can be present.

        :return: The id of this DatePicker.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this DatePicker.
        Optional unique identifier to help map component replies to form messages where multiple DatePickers can be present.

        :param id: The id of this DatePicker.
        :type: str
        """
        

        self._id = id

    @property
    def title(self) -> str:
        """
        Gets the title of this DatePicker.
        Text to show in the title.

        :return: The title of this DatePicker.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title: str) -> None:
        """
        Sets the title of this DatePicker.
        Text to show in the title.

        :param title: The title of this DatePicker.
        :type: str
        """
        

        self._title = title

    @property
    def subtitle(self) -> str:
        """
        Gets the subtitle of this DatePicker.
        Text to show in the description.

        :return: The subtitle of this DatePicker.
        :rtype: str
        """
        return self._subtitle

    @subtitle.setter
    def subtitle(self, subtitle: str) -> None:
        """
        Sets the subtitle of this DatePicker.
        Text to show in the description.

        :param subtitle: The subtitle of this DatePicker.
        :type: str
        """
        

        self._subtitle = subtitle

    @property
    def date_picker_available_date_times(self) -> List['DatePickerAvailableDateTime']:
        """
        Gets the date_picker_available_date_times of this DatePicker.
        An array of available times objects.

        :return: The date_picker_available_date_times of this DatePicker.
        :rtype: list[DatePickerAvailableDateTime]
        """
        return self._date_picker_available_date_times

    @date_picker_available_date_times.setter
    def date_picker_available_date_times(self, date_picker_available_date_times: List['DatePickerAvailableDateTime']) -> None:
        """
        Sets the date_picker_available_date_times of this DatePicker.
        An array of available times objects.

        :param date_picker_available_date_times: The date_picker_available_date_times of this DatePicker.
        :type: list[DatePickerAvailableDateTime]
        """
        

        self._date_picker_available_date_times = date_picker_available_date_times

    @property
    def date_selected(self) -> datetime:
        """
        Gets the date_selected of this DatePicker.
        Selected date response from end customer. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_selected of this DatePicker.
        :rtype: datetime
        """
        return self._date_selected

    @date_selected.setter
    def date_selected(self, date_selected: datetime) -> None:
        """
        Sets the date_selected of this DatePicker.
        Selected date response from end customer. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_selected: The date_selected of this DatePicker.
        :type: datetime
        """
        

        self._date_selected = date_selected

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

