# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DecisionTableColumns
    from . import DecisionTableContract
    from . import DecisionTableVersionEntity
    from . import Division

class DecisionTable(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DecisionTable - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'division': 'Division',
            'description': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'date_published': 'datetime',
            'published': 'DecisionTableVersionEntity',
            'latest': 'DecisionTableVersionEntity',
            'columns': 'DecisionTableColumns',
            'published_contract': 'DecisionTableContract',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'division': 'division',
            'description': 'description',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'date_published': 'datePublished',
            'published': 'published',
            'latest': 'latest',
            'columns': 'columns',
            'published_contract': 'publishedContract',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._division = None
        self._description = None
        self._date_created = None
        self._date_modified = None
        self._date_published = None
        self._published = None
        self._latest = None
        self._columns = None
        self._published_contract = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this DecisionTable.
        The globally unique identifier for the object.

        :return: The id of this DecisionTable.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this DecisionTable.
        The globally unique identifier for the object.

        :param id: The id of this DecisionTable.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this DecisionTable.


        :return: The name of this DecisionTable.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this DecisionTable.


        :param name: The name of this DecisionTable.
        :type: str
        """
        

        self._name = name

    @property
    def division(self) -> 'Division':
        """
        Gets the division of this DecisionTable.
        The division to which this entity belongs.

        :return: The division of this DecisionTable.
        :rtype: Division
        """
        return self._division

    @division.setter
    def division(self, division: 'Division') -> None:
        """
        Sets the division of this DecisionTable.
        The division to which this entity belongs.

        :param division: The division of this DecisionTable.
        :type: Division
        """
        

        self._division = division

    @property
    def description(self) -> str:
        """
        Gets the description of this DecisionTable.
        The decision table description.

        :return: The description of this DecisionTable.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this DecisionTable.
        The decision table description.

        :param description: The description of this DecisionTable.
        :type: str
        """
        

        self._description = description

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this DecisionTable.
        UTC date time indicating when this decision table was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this DecisionTable.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this DecisionTable.
        UTC date time indicating when this decision table was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this DecisionTable.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this DecisionTable.
        UTC date time indicating when this decision table was last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this DecisionTable.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this DecisionTable.
        UTC date time indicating when this decision table was last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this DecisionTable.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def date_published(self) -> datetime:
        """
        Gets the date_published of this DecisionTable.
        UTC date time indicating when this decision table was published. Null if never published. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_published of this DecisionTable.
        :rtype: datetime
        """
        return self._date_published

    @date_published.setter
    def date_published(self, date_published: datetime) -> None:
        """
        Sets the date_published of this DecisionTable.
        UTC date time indicating when this decision table was published. Null if never published. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_published: The date_published of this DecisionTable.
        :type: datetime
        """
        

        self._date_published = date_published

    @property
    def published(self) -> 'DecisionTableVersionEntity':
        """
        Gets the published of this DecisionTable.
        The entity reference to the most recently published decision table version. Null if never published.

        :return: The published of this DecisionTable.
        :rtype: DecisionTableVersionEntity
        """
        return self._published

    @published.setter
    def published(self, published: 'DecisionTableVersionEntity') -> None:
        """
        Sets the published of this DecisionTable.
        The entity reference to the most recently published decision table version. Null if never published.

        :param published: The published of this DecisionTable.
        :type: DecisionTableVersionEntity
        """
        

        self._published = published

    @property
    def latest(self) -> 'DecisionTableVersionEntity':
        """
        Gets the latest of this DecisionTable.
        The entity reference to the most recently created decision table version.

        :return: The latest of this DecisionTable.
        :rtype: DecisionTableVersionEntity
        """
        return self._latest

    @latest.setter
    def latest(self, latest: 'DecisionTableVersionEntity') -> None:
        """
        Sets the latest of this DecisionTable.
        The entity reference to the most recently created decision table version.

        :param latest: The latest of this DecisionTable.
        :type: DecisionTableVersionEntity
        """
        

        self._latest = latest

    @property
    def columns(self) -> 'DecisionTableColumns':
        """
        Gets the columns of this DecisionTable.
        The column definitions of this decision table.

        :return: The columns of this DecisionTable.
        :rtype: DecisionTableColumns
        """
        return self._columns

    @columns.setter
    def columns(self, columns: 'DecisionTableColumns') -> None:
        """
        Sets the columns of this DecisionTable.
        The column definitions of this decision table.

        :param columns: The columns of this DecisionTable.
        :type: DecisionTableColumns
        """
        

        self._columns = columns

    @property
    def published_contract(self) -> 'DecisionTableContract':
        """
        Gets the published_contract of this DecisionTable.
        The published contract information for this decision table.

        :return: The published_contract of this DecisionTable.
        :rtype: DecisionTableContract
        """
        return self._published_contract

    @published_contract.setter
    def published_contract(self, published_contract: 'DecisionTableContract') -> None:
        """
        Sets the published_contract of this DecisionTable.
        The published contract information for this decision table.

        :param published_contract: The published_contract of this DecisionTable.
        :type: DecisionTableContract
        """
        

        self._published_contract = published_contract

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this DecisionTable.
        The URI for this object

        :return: The self_uri of this DecisionTable.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this DecisionTable.
        The URI for this object

        :param self_uri: The self_uri of this DecisionTable.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

