# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DomainEntityRef
    from . import JsonSchemaWithDefinitions

class DecisionTableContract(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DecisionTableContract - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'parent_schema': 'DomainEntityRef',
            'row_authoring_schema': 'JsonSchemaWithDefinitions',
            'execution_input_schema': 'JsonSchemaWithDefinitions',
            'execution_output_schema': 'JsonSchemaWithDefinitions'
        }

        self.attribute_map = {
            'parent_schema': 'parentSchema',
            'row_authoring_schema': 'rowAuthoringSchema',
            'execution_input_schema': 'executionInputSchema',
            'execution_output_schema': 'executionOutputSchema'
        }

        self._parent_schema = None
        self._row_authoring_schema = None
        self._execution_input_schema = None
        self._execution_output_schema = None

    @property
    def parent_schema(self) -> 'DomainEntityRef':
        """
        Gets the parent_schema of this DecisionTableContract.
        DSS V1 schema entity defining source properties for the decision table contract schemas

        :return: The parent_schema of this DecisionTableContract.
        :rtype: DomainEntityRef
        """
        return self._parent_schema

    @parent_schema.setter
    def parent_schema(self, parent_schema: 'DomainEntityRef') -> None:
        """
        Sets the parent_schema of this DecisionTableContract.
        DSS V1 schema entity defining source properties for the decision table contract schemas

        :param parent_schema: The parent_schema of this DecisionTableContract.
        :type: DomainEntityRef
        """
        

        self._parent_schema = parent_schema

    @property
    def row_authoring_schema(self) -> 'JsonSchemaWithDefinitions':
        """
        Gets the row_authoring_schema of this DecisionTableContract.
        JSON schema describing required value types for each column in every row in a decision table

        :return: The row_authoring_schema of this DecisionTableContract.
        :rtype: JsonSchemaWithDefinitions
        """
        return self._row_authoring_schema

    @row_authoring_schema.setter
    def row_authoring_schema(self, row_authoring_schema: 'JsonSchemaWithDefinitions') -> None:
        """
        Sets the row_authoring_schema of this DecisionTableContract.
        JSON schema describing required value types for each column in every row in a decision table

        :param row_authoring_schema: The row_authoring_schema of this DecisionTableContract.
        :type: JsonSchemaWithDefinitions
        """
        

        self._row_authoring_schema = row_authoring_schema

    @property
    def execution_input_schema(self) -> 'JsonSchemaWithDefinitions':
        """
        Gets the execution_input_schema of this DecisionTableContract.
        JSON schema for execution input data for a decision table

        :return: The execution_input_schema of this DecisionTableContract.
        :rtype: JsonSchemaWithDefinitions
        """
        return self._execution_input_schema

    @execution_input_schema.setter
    def execution_input_schema(self, execution_input_schema: 'JsonSchemaWithDefinitions') -> None:
        """
        Sets the execution_input_schema of this DecisionTableContract.
        JSON schema for execution input data for a decision table

        :param execution_input_schema: The execution_input_schema of this DecisionTableContract.
        :type: JsonSchemaWithDefinitions
        """
        

        self._execution_input_schema = execution_input_schema

    @property
    def execution_output_schema(self) -> 'JsonSchemaWithDefinitions':
        """
        Gets the execution_output_schema of this DecisionTableContract.
        JSON schema for execution output data for a decision table

        :return: The execution_output_schema of this DecisionTableContract.
        :rtype: JsonSchemaWithDefinitions
        """
        return self._execution_output_schema

    @execution_output_schema.setter
    def execution_output_schema(self, execution_output_schema: 'JsonSchemaWithDefinitions') -> None:
        """
        Sets the execution_output_schema of this DecisionTableContract.
        JSON schema for execution output data for a decision table

        :param execution_output_schema: The execution_output_schema of this DecisionTableContract.
        :type: JsonSchemaWithDefinitions
        """
        

        self._execution_output_schema = execution_output_schema

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

