# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DecisionTableRowEntityRef
    from . import DecisionTableRowExecutionOutput
    from . import DecisionTableVersionEntity

class DecisionTableExecutionResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DecisionTableExecutionResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'table': 'DecisionTableVersionEntity',
            'total_match_row_count': 'int',
            'top_match_rows': 'list[DecisionTableRowEntityRef]',
            'row_execution_outputs': 'list[DecisionTableRowExecutionOutput]'
        }

        self.attribute_map = {
            'table': 'table',
            'total_match_row_count': 'totalMatchRowCount',
            'top_match_rows': 'topMatchRows',
            'row_execution_outputs': 'rowExecutionOutputs'
        }

        self._table = None
        self._total_match_row_count = None
        self._top_match_rows = None
        self._row_execution_outputs = None

    @property
    def table(self) -> 'DecisionTableVersionEntity':
        """
        Gets the table of this DecisionTableExecutionResponse.
        The decision table version entity that was executed.

        :return: The table of this DecisionTableExecutionResponse.
        :rtype: DecisionTableVersionEntity
        """
        return self._table

    @table.setter
    def table(self, table: 'DecisionTableVersionEntity') -> None:
        """
        Sets the table of this DecisionTableExecutionResponse.
        The decision table version entity that was executed.

        :param table: The table of this DecisionTableExecutionResponse.
        :type: DecisionTableVersionEntity
        """
        

        self._table = table

    @property
    def total_match_row_count(self) -> int:
        """
        Gets the total_match_row_count of this DecisionTableExecutionResponse.
        Total number of rows that matched execution input and would return results

        :return: The total_match_row_count of this DecisionTableExecutionResponse.
        :rtype: int
        """
        return self._total_match_row_count

    @total_match_row_count.setter
    def total_match_row_count(self, total_match_row_count: int) -> None:
        """
        Sets the total_match_row_count of this DecisionTableExecutionResponse.
        Total number of rows that matched execution input and would return results

        :param total_match_row_count: The total_match_row_count of this DecisionTableExecutionResponse.
        :type: int
        """
        

        self._total_match_row_count = total_match_row_count

    @property
    def top_match_rows(self) -> List['DecisionTableRowEntityRef']:
        """
        Gets the top_match_rows of this DecisionTableExecutionResponse.
        Top 5 rows matching execution input, excluding the one produced the result.

        :return: The top_match_rows of this DecisionTableExecutionResponse.
        :rtype: list[DecisionTableRowEntityRef]
        """
        return self._top_match_rows

    @top_match_rows.setter
    def top_match_rows(self, top_match_rows: List['DecisionTableRowEntityRef']) -> None:
        """
        Sets the top_match_rows of this DecisionTableExecutionResponse.
        Top 5 rows matching execution input, excluding the one produced the result.

        :param top_match_rows: The top_match_rows of this DecisionTableExecutionResponse.
        :type: list[DecisionTableRowEntityRef]
        """
        

        self._top_match_rows = top_match_rows

    @property
    def row_execution_outputs(self) -> List['DecisionTableRowExecutionOutput']:
        """
        Gets the row_execution_outputs of this DecisionTableExecutionResponse.
        The output data for each executed row for which output is collected.

        :return: The row_execution_outputs of this DecisionTableExecutionResponse.
        :rtype: list[DecisionTableRowExecutionOutput]
        """
        return self._row_execution_outputs

    @row_execution_outputs.setter
    def row_execution_outputs(self, row_execution_outputs: List['DecisionTableRowExecutionOutput']) -> None:
        """
        Sets the row_execution_outputs of this DecisionTableExecutionResponse.
        The output data for each executed row for which output is collected.

        :param row_execution_outputs: The row_execution_outputs of this DecisionTableExecutionResponse.
        :type: list[DecisionTableRowExecutionOutput]
        """
        

        self._row_execution_outputs = row_execution_outputs

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

