# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DecisionTableColumnDefaultRowValue
    from . import OutputValue

class DecisionTableOutputColumn(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DecisionTableOutputColumn - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'defaults_to': 'DecisionTableColumnDefaultRowValue',
            'value': 'OutputValue'
        }

        self.attribute_map = {
            'id': 'id',
            'defaults_to': 'defaultsTo',
            'value': 'value'
        }

        self._id = None
        self._defaults_to = None
        self._value = None

    @property
    def id(self) -> str:
        """
        Gets the id of this DecisionTableOutputColumn.
        The id of the column.

        :return: The id of this DecisionTableOutputColumn.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this DecisionTableOutputColumn.
        The id of the column.

        :param id: The id of this DecisionTableOutputColumn.
        :type: str
        """
        

        self._id = id

    @property
    def defaults_to(self) -> 'DecisionTableColumnDefaultRowValue':
        """
        Gets the defaults_to of this DecisionTableOutputColumn.
        The default row value for this column that will be used for an output value where no value  is provided by a row.

        :return: The defaults_to of this DecisionTableOutputColumn.
        :rtype: DecisionTableColumnDefaultRowValue
        """
        return self._defaults_to

    @defaults_to.setter
    def defaults_to(self, defaults_to: 'DecisionTableColumnDefaultRowValue') -> None:
        """
        Sets the defaults_to of this DecisionTableOutputColumn.
        The default row value for this column that will be used for an output value where no value  is provided by a row.

        :param defaults_to: The defaults_to of this DecisionTableOutputColumn.
        :type: DecisionTableColumnDefaultRowValue
        """
        

        self._defaults_to = defaults_to

    @property
    def value(self) -> 'OutputValue':
        """
        Gets the value of this DecisionTableOutputColumn.
        The output data of this column that will be provided by each row.

        :return: The value of this DecisionTableOutputColumn.
        :rtype: OutputValue
        """
        return self._value

    @value.setter
    def value(self, value: 'OutputValue') -> None:
        """
        Sets the value of this DecisionTableOutputColumn.
        The output data of this column that will be provided by each row.

        :param value: The value of this DecisionTableOutputColumn.
        :type: OutputValue
        """
        

        self._value = value

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

