# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DecisionTableColumns
    from . import DecisionTableContract
    from . import Division

class DecisionTableVersion(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DecisionTableVersion - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'division': 'Division',
            'version': 'int',
            'status': 'str',
            'description': 'str',
            'row_count': 'int',
            'rows_uri': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'date_published': 'datetime',
            'columns': 'DecisionTableColumns',
            'contract': 'DecisionTableContract',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'division': 'division',
            'version': 'version',
            'status': 'status',
            'description': 'description',
            'row_count': 'rowCount',
            'rows_uri': 'rowsUri',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'date_published': 'datePublished',
            'columns': 'columns',
            'contract': 'contract',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._division = None
        self._version = None
        self._status = None
        self._description = None
        self._row_count = None
        self._rows_uri = None
        self._date_created = None
        self._date_modified = None
        self._date_published = None
        self._columns = None
        self._contract = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this DecisionTableVersion.
        The globally unique identifier for the object.

        :return: The id of this DecisionTableVersion.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this DecisionTableVersion.
        The globally unique identifier for the object.

        :param id: The id of this DecisionTableVersion.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this DecisionTableVersion.


        :return: The name of this DecisionTableVersion.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this DecisionTableVersion.


        :param name: The name of this DecisionTableVersion.
        :type: str
        """
        

        self._name = name

    @property
    def division(self) -> 'Division':
        """
        Gets the division of this DecisionTableVersion.
        The division to which this entity belongs.

        :return: The division of this DecisionTableVersion.
        :rtype: Division
        """
        return self._division

    @division.setter
    def division(self, division: 'Division') -> None:
        """
        Sets the division of this DecisionTableVersion.
        The division to which this entity belongs.

        :param division: The division of this DecisionTableVersion.
        :type: Division
        """
        

        self._division = division

    @property
    def version(self) -> int:
        """
        Gets the version of this DecisionTableVersion.
        The decision table version.

        :return: The version of this DecisionTableVersion.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version: int) -> None:
        """
        Sets the version of this DecisionTableVersion.
        The decision table version.

        :param version: The version of this DecisionTableVersion.
        :type: int
        """
        

        self._version = version

    @property
    def status(self) -> str:
        """
        Gets the status of this DecisionTableVersion.
        Current status of this decision table version

        :return: The status of this DecisionTableVersion.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this DecisionTableVersion.
        Current status of this decision table version

        :param status: The status of this DecisionTableVersion.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Draft", "Published", "Error", "Preparing", "Superseded"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def description(self) -> str:
        """
        Gets the description of this DecisionTableVersion.
        The decision table description.

        :return: The description of this DecisionTableVersion.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this DecisionTableVersion.
        The decision table description.

        :param description: The description of this DecisionTableVersion.
        :type: str
        """
        

        self._description = description

    @property
    def row_count(self) -> int:
        """
        Gets the row_count of this DecisionTableVersion.
        The number of rows in this decision table version.

        :return: The row_count of this DecisionTableVersion.
        :rtype: int
        """
        return self._row_count

    @row_count.setter
    def row_count(self, row_count: int) -> None:
        """
        Sets the row_count of this DecisionTableVersion.
        The number of rows in this decision table version.

        :param row_count: The row_count of this DecisionTableVersion.
        :type: int
        """
        

        self._row_count = row_count

    @property
    def rows_uri(self) -> str:
        """
        Gets the rows_uri of this DecisionTableVersion.
        The rows URI for this decision table version.

        :return: The rows_uri of this DecisionTableVersion.
        :rtype: str
        """
        return self._rows_uri

    @rows_uri.setter
    def rows_uri(self, rows_uri: str) -> None:
        """
        Sets the rows_uri of this DecisionTableVersion.
        The rows URI for this decision table version.

        :param rows_uri: The rows_uri of this DecisionTableVersion.
        :type: str
        """
        

        self._rows_uri = rows_uri

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this DecisionTableVersion.
        UTC date time indicating when this decision table version was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this DecisionTableVersion.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this DecisionTableVersion.
        UTC date time indicating when this decision table version was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this DecisionTableVersion.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this DecisionTableVersion.
        UTC date time indicating when this decision table version was last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this DecisionTableVersion.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this DecisionTableVersion.
        UTC date time indicating when this decision table version was last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this DecisionTableVersion.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def date_published(self) -> datetime:
        """
        Gets the date_published of this DecisionTableVersion.
        UTC date time indicating when this decision table version was published. Null if never published. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_published of this DecisionTableVersion.
        :rtype: datetime
        """
        return self._date_published

    @date_published.setter
    def date_published(self, date_published: datetime) -> None:
        """
        Sets the date_published of this DecisionTableVersion.
        UTC date time indicating when this decision table version was published. Null if never published. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_published: The date_published of this DecisionTableVersion.
        :type: datetime
        """
        

        self._date_published = date_published

    @property
    def columns(self) -> 'DecisionTableColumns':
        """
        Gets the columns of this DecisionTableVersion.
        The column definitions of this decision table version.

        :return: The columns of this DecisionTableVersion.
        :rtype: DecisionTableColumns
        """
        return self._columns

    @columns.setter
    def columns(self, columns: 'DecisionTableColumns') -> None:
        """
        Sets the columns of this DecisionTableVersion.
        The column definitions of this decision table version.

        :param columns: The columns of this DecisionTableVersion.
        :type: DecisionTableColumns
        """
        

        self._columns = columns

    @property
    def contract(self) -> 'DecisionTableContract':
        """
        Gets the contract of this DecisionTableVersion.
        The contract information for this decision table version.

        :return: The contract of this DecisionTableVersion.
        :rtype: DecisionTableContract
        """
        return self._contract

    @contract.setter
    def contract(self, contract: 'DecisionTableContract') -> None:
        """
        Sets the contract of this DecisionTableVersion.
        The contract information for this decision table version.

        :param contract: The contract of this DecisionTableVersion.
        :type: DecisionTableContract
        """
        

        self._contract = contract

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this DecisionTableVersion.
        The URI for this object

        :return: The self_uri of this DecisionTableVersion.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this DecisionTableVersion.
        The URI for this object

        :param self_uri: The self_uri of this DecisionTableVersion.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

