# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class DefaultAnswersTo(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DefaultAnswersTo - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'highest_score': 'bool',
            'not_applicable': 'bool',
            'lowest_score': 'bool',
            'user_defined': 'bool'
        }

        self.attribute_map = {
            'highest_score': 'highestScore',
            'not_applicable': 'notApplicable',
            'lowest_score': 'lowestScore',
            'user_defined': 'userDefined'
        }

        self._highest_score = None
        self._not_applicable = None
        self._lowest_score = None
        self._user_defined = None

    @property
    def highest_score(self) -> bool:
        """
        Gets the highest_score of this DefaultAnswersTo.
        True, when answer should default to highest score

        :return: The highest_score of this DefaultAnswersTo.
        :rtype: bool
        """
        return self._highest_score

    @highest_score.setter
    def highest_score(self, highest_score: bool) -> None:
        """
        Sets the highest_score of this DefaultAnswersTo.
        True, when answer should default to highest score

        :param highest_score: The highest_score of this DefaultAnswersTo.
        :type: bool
        """
        

        self._highest_score = highest_score

    @property
    def not_applicable(self) -> bool:
        """
        Gets the not_applicable of this DefaultAnswersTo.
        True, when answer should default to N/A

        :return: The not_applicable of this DefaultAnswersTo.
        :rtype: bool
        """
        return self._not_applicable

    @not_applicable.setter
    def not_applicable(self, not_applicable: bool) -> None:
        """
        Sets the not_applicable of this DefaultAnswersTo.
        True, when answer should default to N/A

        :param not_applicable: The not_applicable of this DefaultAnswersTo.
        :type: bool
        """
        

        self._not_applicable = not_applicable

    @property
    def lowest_score(self) -> bool:
        """
        Gets the lowest_score of this DefaultAnswersTo.
        True, when answer should default to lowest score

        :return: The lowest_score of this DefaultAnswersTo.
        :rtype: bool
        """
        return self._lowest_score

    @lowest_score.setter
    def lowest_score(self, lowest_score: bool) -> None:
        """
        Sets the lowest_score of this DefaultAnswersTo.
        True, when answer should default to lowest score

        :param lowest_score: The lowest_score of this DefaultAnswersTo.
        :type: bool
        """
        

        self._lowest_score = lowest_score

    @property
    def user_defined(self) -> bool:
        """
        Gets the user_defined of this DefaultAnswersTo.
        True, when answer should default to user defined answer

        :return: The user_defined of this DefaultAnswersTo.
        :rtype: bool
        """
        return self._user_defined

    @user_defined.setter
    def user_defined(self, user_defined: bool) -> None:
        """
        Sets the user_defined of this DefaultAnswersTo.
        True, when answer should default to user defined answer

        :param user_defined: The user_defined of this DefaultAnswersTo.
        :type: bool
        """
        

        self._user_defined = user_defined

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

