# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DeploymentWebAction

class DeploymentPing(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DeploymentPing - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'actions': 'list[DeploymentWebAction]',
            'poll_interval_milliseconds': 'int'
        }

        self.attribute_map = {
            'actions': 'actions',
            'poll_interval_milliseconds': 'pollIntervalMilliseconds'
        }

        self._actions = None
        self._poll_interval_milliseconds = None

    @property
    def actions(self) -> List['DeploymentWebAction']:
        """
        Gets the actions of this DeploymentPing.
        Collection of actions to be offered or displayed to the visitor.

        :return: The actions of this DeploymentPing.
        :rtype: list[DeploymentWebAction]
        """
        return self._actions

    @actions.setter
    def actions(self, actions: List['DeploymentWebAction']) -> None:
        """
        Sets the actions of this DeploymentPing.
        Collection of actions to be offered or displayed to the visitor.

        :param actions: The actions of this DeploymentPing.
        :type: list[DeploymentWebAction]
        """
        

        self._actions = actions

    @property
    def poll_interval_milliseconds(self) -> int:
        """
        Gets the poll_interval_milliseconds of this DeploymentPing.
        Custom poll interval in milliseconds; when the return value is -1, disable pings.

        :return: The poll_interval_milliseconds of this DeploymentPing.
        :rtype: int
        """
        return self._poll_interval_milliseconds

    @poll_interval_milliseconds.setter
    def poll_interval_milliseconds(self, poll_interval_milliseconds: int) -> None:
        """
        Sets the poll_interval_milliseconds of this DeploymentPing.
        Custom poll interval in milliseconds; when the return value is -1, disable pings.

        :param poll_interval_milliseconds: The poll_interval_milliseconds of this DeploymentPing.
        :type: int
        """
        

        self._poll_interval_milliseconds = poll_interval_milliseconds

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

