# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DispositionParameters

class Disposition(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        Disposition - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'analyzer': 'str',
            'disposition_parameters': 'DispositionParameters',
            'detected_speech_start': 'datetime',
            'detected_speech_end': 'datetime'
        }

        self.attribute_map = {
            'name': 'name',
            'analyzer': 'analyzer',
            'disposition_parameters': 'dispositionParameters',
            'detected_speech_start': 'detectedSpeechStart',
            'detected_speech_end': 'detectedSpeechEnd'
        }

        self._name = None
        self._analyzer = None
        self._disposition_parameters = None
        self._detected_speech_start = None
        self._detected_speech_end = None

    @property
    def name(self) -> str:
        """
        Gets the name of this Disposition.
        Name of the disposition. Either a platform predefined value, or the name of the disposition in the disposition table..

        :return: The name of this Disposition.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this Disposition.
        Name of the disposition. Either a platform predefined value, or the name of the disposition in the disposition table..

        :param name: The name of this Disposition.
        :type: str
        """
        

        self._name = name

    @property
    def analyzer(self) -> str:
        """
        Gets the analyzer of this Disposition.
        The final media analyzer result that triggered the disposition result, if any.

        :return: The analyzer of this Disposition.
        :rtype: str
        """
        return self._analyzer

    @analyzer.setter
    def analyzer(self, analyzer: str) -> None:
        """
        Sets the analyzer of this Disposition.
        The final media analyzer result that triggered the disposition result, if any.

        :param analyzer: The analyzer of this Disposition.
        :type: str
        """
        

        self._analyzer = analyzer

    @property
    def disposition_parameters(self) -> 'DispositionParameters':
        """
        Gets the disposition_parameters of this Disposition.
        Contains various parameters related to call analysis.

        :return: The disposition_parameters of this Disposition.
        :rtype: DispositionParameters
        """
        return self._disposition_parameters

    @disposition_parameters.setter
    def disposition_parameters(self, disposition_parameters: 'DispositionParameters') -> None:
        """
        Sets the disposition_parameters of this Disposition.
        Contains various parameters related to call analysis.

        :param disposition_parameters: The disposition_parameters of this Disposition.
        :type: DispositionParameters
        """
        

        self._disposition_parameters = disposition_parameters

    @property
    def detected_speech_start(self) -> datetime:
        """
        Gets the detected_speech_start of this Disposition.
        Absolute time when the speech started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The detected_speech_start of this Disposition.
        :rtype: datetime
        """
        return self._detected_speech_start

    @detected_speech_start.setter
    def detected_speech_start(self, detected_speech_start: datetime) -> None:
        """
        Sets the detected_speech_start of this Disposition.
        Absolute time when the speech started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param detected_speech_start: The detected_speech_start of this Disposition.
        :type: datetime
        """
        

        self._detected_speech_start = detected_speech_start

    @property
    def detected_speech_end(self) -> datetime:
        """
        Gets the detected_speech_end of this Disposition.
        Absolute time when the speech ended. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The detected_speech_end of this Disposition.
        :rtype: datetime
        """
        return self._detected_speech_end

    @detected_speech_end.setter
    def detected_speech_end(self, detected_speech_end: datetime) -> None:
        """
        Sets the detected_speech_end of this Disposition.
        Absolute time when the speech ended. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param detected_speech_end: The detected_speech_end of this Disposition.
        :type: datetime
        """
        

        self._detected_speech_end = detected_speech_end

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

