# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class DnclistDownloadReadyExportUri(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DnclistDownloadReadyExportUri - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'uri': 'str',
            'export_timestamp': 'str',
            'additional_properties': 'dict(str, object)',
            'get_additional_properties': 'dict(str, object)'
        }

        self.attribute_map = {
            'uri': 'uri',
            'export_timestamp': 'exportTimestamp',
            'additional_properties': 'additionalProperties',
            'get_additional_properties': 'getAdditionalProperties'
        }

        self._uri = None
        self._export_timestamp = None
        self._additional_properties = None
        self._get_additional_properties = None

    @property
    def uri(self) -> str:
        """
        Gets the uri of this DnclistDownloadReadyExportUri.


        :return: The uri of this DnclistDownloadReadyExportUri.
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri: str) -> None:
        """
        Sets the uri of this DnclistDownloadReadyExportUri.


        :param uri: The uri of this DnclistDownloadReadyExportUri.
        :type: str
        """
        

        self._uri = uri

    @property
    def export_timestamp(self) -> str:
        """
        Gets the export_timestamp of this DnclistDownloadReadyExportUri.


        :return: The export_timestamp of this DnclistDownloadReadyExportUri.
        :rtype: str
        """
        return self._export_timestamp

    @export_timestamp.setter
    def export_timestamp(self, export_timestamp: str) -> None:
        """
        Sets the export_timestamp of this DnclistDownloadReadyExportUri.


        :param export_timestamp: The export_timestamp of this DnclistDownloadReadyExportUri.
        :type: str
        """
        

        self._export_timestamp = export_timestamp

    @property
    def additional_properties(self) -> Dict[str, object]:
        """
        Gets the additional_properties of this DnclistDownloadReadyExportUri.


        :return: The additional_properties of this DnclistDownloadReadyExportUri.
        :rtype: dict(str, object)
        """
        return self._additional_properties

    @additional_properties.setter
    def additional_properties(self, additional_properties: Dict[str, object]) -> None:
        """
        Sets the additional_properties of this DnclistDownloadReadyExportUri.


        :param additional_properties: The additional_properties of this DnclistDownloadReadyExportUri.
        :type: dict(str, object)
        """
        

        self._additional_properties = additional_properties

    @property
    def get_additional_properties(self) -> Dict[str, object]:
        """
        Gets the get_additional_properties of this DnclistDownloadReadyExportUri.


        :return: The get_additional_properties of this DnclistDownloadReadyExportUri.
        :rtype: dict(str, object)
        """
        return self._get_additional_properties

    @get_additional_properties.setter
    def get_additional_properties(self, get_additional_properties: Dict[str, object]) -> None:
        """
        Sets the get_additional_properties of this DnclistDownloadReadyExportUri.


        :param get_additional_properties: The get_additional_properties of this DnclistDownloadReadyExportUri.
        :type: dict(str, object)
        """
        

        self._get_additional_properties = get_additional_properties

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

