# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DocumentElementLength

class DocumentBodyImageProperties(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DocumentBodyImageProperties - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'background_color': 'str',
            'align': 'str',
            'indentation': 'float',
            'width': 'float',
            'width_with_unit': 'DocumentElementLength',
            'alt_text': 'str'
        }

        self.attribute_map = {
            'background_color': 'backgroundColor',
            'align': 'align',
            'indentation': 'indentation',
            'width': 'width',
            'width_with_unit': 'widthWithUnit',
            'alt_text': 'altText'
        }

        self._background_color = None
        self._align = None
        self._indentation = None
        self._width = None
        self._width_with_unit = None
        self._alt_text = None

    @property
    def background_color(self) -> str:
        """
        Gets the background_color of this DocumentBodyImageProperties.
        The background color property for the image. The valid values in hex color code representation. For example black color - #000000

        :return: The background_color of this DocumentBodyImageProperties.
        :rtype: str
        """
        return self._background_color

    @background_color.setter
    def background_color(self, background_color: str) -> None:
        """
        Sets the background_color of this DocumentBodyImageProperties.
        The background color property for the image. The valid values in hex color code representation. For example black color - #000000

        :param background_color: The background_color of this DocumentBodyImageProperties.
        :type: str
        """
        

        self._background_color = background_color

    @property
    def align(self) -> str:
        """
        Gets the align of this DocumentBodyImageProperties.
        The align property for the image.

        :return: The align of this DocumentBodyImageProperties.
        :rtype: str
        """
        return self._align

    @align.setter
    def align(self, align: str) -> None:
        """
        Sets the align of this DocumentBodyImageProperties.
        The align property for the image.

        :param align: The align of this DocumentBodyImageProperties.
        :type: str
        """
        if isinstance(align, int):
            align = str(align)
        allowed_values = ["Center", "Left", "Right", "Justify"]
        if align.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for align -> " + align)
            self._align = "outdated_sdk_version"
        else:
            self._align = align

    @property
    def indentation(self) -> float:
        """
        Gets the indentation of this DocumentBodyImageProperties.
        The indentation property for the image. The valid values in 'em'.

        :return: The indentation of this DocumentBodyImageProperties.
        :rtype: float
        """
        return self._indentation

    @indentation.setter
    def indentation(self, indentation: float) -> None:
        """
        Sets the indentation of this DocumentBodyImageProperties.
        The indentation property for the image. The valid values in 'em'.

        :param indentation: The indentation of this DocumentBodyImageProperties.
        :type: float
        """
        

        self._indentation = indentation

    @property
    def width(self) -> float:
        """
        Gets the width of this DocumentBodyImageProperties.
        The width of the image converted to em unit.

        :return: The width of this DocumentBodyImageProperties.
        :rtype: float
        """
        return self._width

    @width.setter
    def width(self, width: float) -> None:
        """
        Sets the width of this DocumentBodyImageProperties.
        The width of the image converted to em unit.

        :param width: The width of this DocumentBodyImageProperties.
        :type: float
        """
        

        self._width = width

    @property
    def width_with_unit(self) -> 'DocumentElementLength':
        """
        Gets the width_with_unit of this DocumentBodyImageProperties.
        The width of the image in the specified unit.

        :return: The width_with_unit of this DocumentBodyImageProperties.
        :rtype: DocumentElementLength
        """
        return self._width_with_unit

    @width_with_unit.setter
    def width_with_unit(self, width_with_unit: 'DocumentElementLength') -> None:
        """
        Sets the width_with_unit of this DocumentBodyImageProperties.
        The width of the image in the specified unit.

        :param width_with_unit: The width_with_unit of this DocumentBodyImageProperties.
        :type: DocumentElementLength
        """
        

        self._width_with_unit = width_with_unit

    @property
    def alt_text(self) -> str:
        """
        Gets the alt_text of this DocumentBodyImageProperties.
        Alternate text for the image for accessibility and when the image can't be loaded.

        :return: The alt_text of this DocumentBodyImageProperties.
        :rtype: str
        """
        return self._alt_text

    @alt_text.setter
    def alt_text(self, alt_text: str) -> None:
        """
        Sets the alt_text of this DocumentBodyImageProperties.
        Alternate text for the image for accessibility and when the image can't be loaded.

        :param alt_text: The alt_text of this DocumentBodyImageProperties.
        :type: str
        """
        

        self._alt_text = alt_text

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

