# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class DocumentBodyListBlockProperties(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DocumentBodyListBlockProperties - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'unordered_type': 'str',
            'ordered_type': 'str'
        }

        self.attribute_map = {
            'unordered_type': 'unorderedType',
            'ordered_type': 'orderedType'
        }

        self._unordered_type = None
        self._ordered_type = None

    @property
    def unordered_type(self) -> str:
        """
        Gets the unordered_type of this DocumentBodyListBlockProperties.
        The type of icon for the unordered list.

        :return: The unordered_type of this DocumentBodyListBlockProperties.
        :rtype: str
        """
        return self._unordered_type

    @unordered_type.setter
    def unordered_type(self, unordered_type: str) -> None:
        """
        Sets the unordered_type of this DocumentBodyListBlockProperties.
        The type of icon for the unordered list.

        :param unordered_type: The unordered_type of this DocumentBodyListBlockProperties.
        :type: str
        """
        if isinstance(unordered_type, int):
            unordered_type = str(unordered_type)
        allowed_values = ["Normal", "Square", "Circle", "None"]
        if unordered_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for unordered_type -> " + unordered_type)
            self._unordered_type = "outdated_sdk_version"
        else:
            self._unordered_type = unordered_type

    @property
    def ordered_type(self) -> str:
        """
        Gets the ordered_type of this DocumentBodyListBlockProperties.
        The type of icon for the ordered list.

        :return: The ordered_type of this DocumentBodyListBlockProperties.
        :rtype: str
        """
        return self._ordered_type

    @ordered_type.setter
    def ordered_type(self, ordered_type: str) -> None:
        """
        Sets the ordered_type of this DocumentBodyListBlockProperties.
        The type of icon for the ordered list.

        :param ordered_type: The ordered_type of this DocumentBodyListBlockProperties.
        :type: str
        """
        if isinstance(ordered_type, int):
            ordered_type = str(ordered_type)
        allowed_values = ["Number", "LowerAlpha", "LowerGreek", "LowerRoman", "UpperAlpha", "UpperRoman", "None"]
        if ordered_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for ordered_type -> " + ordered_type)
            self._ordered_type = "outdated_sdk_version"
        else:
            self._ordered_type = ordered_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

