# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DocumentElementLength

class DocumentBodyTableCellBlockProperties(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DocumentBodyTableCellBlockProperties - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'cell_type': 'str',
            'width': 'float',
            'width_with_unit': 'DocumentElementLength',
            'height': 'float',
            'horizontal_align': 'str',
            'vertical_align': 'str',
            'border_width': 'float',
            'border_style': 'str',
            'border_color': 'str',
            'background_color': 'str',
            'scope': 'str',
            'col_span': 'int',
            'row_span': 'int'
        }

        self.attribute_map = {
            'cell_type': 'cellType',
            'width': 'width',
            'width_with_unit': 'widthWithUnit',
            'height': 'height',
            'horizontal_align': 'horizontalAlign',
            'vertical_align': 'verticalAlign',
            'border_width': 'borderWidth',
            'border_style': 'borderStyle',
            'border_color': 'borderColor',
            'background_color': 'backgroundColor',
            'scope': 'scope',
            'col_span': 'colSpan',
            'row_span': 'rowSpan'
        }

        self._cell_type = None
        self._width = None
        self._width_with_unit = None
        self._height = None
        self._horizontal_align = None
        self._vertical_align = None
        self._border_width = None
        self._border_style = None
        self._border_color = None
        self._background_color = None
        self._scope = None
        self._col_span = None
        self._row_span = None

    @property
    def cell_type(self) -> str:
        """
        Gets the cell_type of this DocumentBodyTableCellBlockProperties.
        The type of the table cell.

        :return: The cell_type of this DocumentBodyTableCellBlockProperties.
        :rtype: str
        """
        return self._cell_type

    @cell_type.setter
    def cell_type(self, cell_type: str) -> None:
        """
        Sets the cell_type of this DocumentBodyTableCellBlockProperties.
        The type of the table cell.

        :param cell_type: The cell_type of this DocumentBodyTableCellBlockProperties.
        :type: str
        """
        if isinstance(cell_type, int):
            cell_type = str(cell_type)
        allowed_values = ["Cell", "HeaderCell"]
        if cell_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for cell_type -> " + cell_type)
            self._cell_type = "outdated_sdk_version"
        else:
            self._cell_type = cell_type

    @property
    def width(self) -> float:
        """
        Gets the width of this DocumentBodyTableCellBlockProperties.
        The width of the table cell converted to em unit.

        :return: The width of this DocumentBodyTableCellBlockProperties.
        :rtype: float
        """
        return self._width

    @width.setter
    def width(self, width: float) -> None:
        """
        Sets the width of this DocumentBodyTableCellBlockProperties.
        The width of the table cell converted to em unit.

        :param width: The width of this DocumentBodyTableCellBlockProperties.
        :type: float
        """
        

        self._width = width

    @property
    def width_with_unit(self) -> 'DocumentElementLength':
        """
        Gets the width_with_unit of this DocumentBodyTableCellBlockProperties.
        The width of the table cell in the specified unit.

        :return: The width_with_unit of this DocumentBodyTableCellBlockProperties.
        :rtype: DocumentElementLength
        """
        return self._width_with_unit

    @width_with_unit.setter
    def width_with_unit(self, width_with_unit: 'DocumentElementLength') -> None:
        """
        Sets the width_with_unit of this DocumentBodyTableCellBlockProperties.
        The width of the table cell in the specified unit.

        :param width_with_unit: The width_with_unit of this DocumentBodyTableCellBlockProperties.
        :type: DocumentElementLength
        """
        

        self._width_with_unit = width_with_unit

    @property
    def height(self) -> float:
        """
        Gets the height of this DocumentBodyTableCellBlockProperties.
        The height for the table cell.

        :return: The height of this DocumentBodyTableCellBlockProperties.
        :rtype: float
        """
        return self._height

    @height.setter
    def height(self, height: float) -> None:
        """
        Sets the height of this DocumentBodyTableCellBlockProperties.
        The height for the table cell.

        :param height: The height of this DocumentBodyTableCellBlockProperties.
        :type: float
        """
        

        self._height = height

    @property
    def horizontal_align(self) -> str:
        """
        Gets the horizontal_align of this DocumentBodyTableCellBlockProperties.
        The horizontal alignment for the table cell.

        :return: The horizontal_align of this DocumentBodyTableCellBlockProperties.
        :rtype: str
        """
        return self._horizontal_align

    @horizontal_align.setter
    def horizontal_align(self, horizontal_align: str) -> None:
        """
        Sets the horizontal_align of this DocumentBodyTableCellBlockProperties.
        The horizontal alignment for the table cell.

        :param horizontal_align: The horizontal_align of this DocumentBodyTableCellBlockProperties.
        :type: str
        """
        if isinstance(horizontal_align, int):
            horizontal_align = str(horizontal_align)
        allowed_values = ["Center", "Left", "Right"]
        if horizontal_align.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for horizontal_align -> " + horizontal_align)
            self._horizontal_align = "outdated_sdk_version"
        else:
            self._horizontal_align = horizontal_align

    @property
    def vertical_align(self) -> str:
        """
        Gets the vertical_align of this DocumentBodyTableCellBlockProperties.
        The vertical alignment for the table cell.

        :return: The vertical_align of this DocumentBodyTableCellBlockProperties.
        :rtype: str
        """
        return self._vertical_align

    @vertical_align.setter
    def vertical_align(self, vertical_align: str) -> None:
        """
        Sets the vertical_align of this DocumentBodyTableCellBlockProperties.
        The vertical alignment for the table cell.

        :param vertical_align: The vertical_align of this DocumentBodyTableCellBlockProperties.
        :type: str
        """
        if isinstance(vertical_align, int):
            vertical_align = str(vertical_align)
        allowed_values = ["Top", "Middle", "Bottom"]
        if vertical_align.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for vertical_align -> " + vertical_align)
            self._vertical_align = "outdated_sdk_version"
        else:
            self._vertical_align = vertical_align

    @property
    def border_width(self) -> float:
        """
        Gets the border_width of this DocumentBodyTableCellBlockProperties.
        The border width for the table cell. The valid values in 'em'

        :return: The border_width of this DocumentBodyTableCellBlockProperties.
        :rtype: float
        """
        return self._border_width

    @border_width.setter
    def border_width(self, border_width: float) -> None:
        """
        Sets the border_width of this DocumentBodyTableCellBlockProperties.
        The border width for the table cell. The valid values in 'em'

        :param border_width: The border_width of this DocumentBodyTableCellBlockProperties.
        :type: float
        """
        

        self._border_width = border_width

    @property
    def border_style(self) -> str:
        """
        Gets the border_style of this DocumentBodyTableCellBlockProperties.
        The border style for the table cell.

        :return: The border_style of this DocumentBodyTableCellBlockProperties.
        :rtype: str
        """
        return self._border_style

    @border_style.setter
    def border_style(self, border_style: str) -> None:
        """
        Sets the border_style of this DocumentBodyTableCellBlockProperties.
        The border style for the table cell.

        :param border_style: The border_style of this DocumentBodyTableCellBlockProperties.
        :type: str
        """
        if isinstance(border_style, int):
            border_style = str(border_style)
        allowed_values = ["Solid", "Dotted", "Dashed", "Double", "Groove", "Ridge", "Inset", "Outset", "Hidden", "None"]
        if border_style.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for border_style -> " + border_style)
            self._border_style = "outdated_sdk_version"
        else:
            self._border_style = border_style

    @property
    def border_color(self) -> str:
        """
        Gets the border_color of this DocumentBodyTableCellBlockProperties.
        The border color for the table cell. For example black color - #000000

        :return: The border_color of this DocumentBodyTableCellBlockProperties.
        :rtype: str
        """
        return self._border_color

    @border_color.setter
    def border_color(self, border_color: str) -> None:
        """
        Sets the border_color of this DocumentBodyTableCellBlockProperties.
        The border color for the table cell. For example black color - #000000

        :param border_color: The border_color of this DocumentBodyTableCellBlockProperties.
        :type: str
        """
        

        self._border_color = border_color

    @property
    def background_color(self) -> str:
        """
        Gets the background_color of this DocumentBodyTableCellBlockProperties.
        The background color for the table cell. For example black color - #000000

        :return: The background_color of this DocumentBodyTableCellBlockProperties.
        :rtype: str
        """
        return self._background_color

    @background_color.setter
    def background_color(self, background_color: str) -> None:
        """
        Sets the background_color of this DocumentBodyTableCellBlockProperties.
        The background color for the table cell. For example black color - #000000

        :param background_color: The background_color of this DocumentBodyTableCellBlockProperties.
        :type: str
        """
        

        self._background_color = background_color

    @property
    def scope(self) -> str:
        """
        Gets the scope of this DocumentBodyTableCellBlockProperties.
        The scope for the table cell.

        :return: The scope of this DocumentBodyTableCellBlockProperties.
        :rtype: str
        """
        return self._scope

    @scope.setter
    def scope(self, scope: str) -> None:
        """
        Sets the scope of this DocumentBodyTableCellBlockProperties.
        The scope for the table cell.

        :param scope: The scope of this DocumentBodyTableCellBlockProperties.
        :type: str
        """
        if isinstance(scope, int):
            scope = str(scope)
        allowed_values = ["Row", "Column", "RowGroup", "ColumnGroup", "None"]
        if scope.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for scope -> " + scope)
            self._scope = "outdated_sdk_version"
        else:
            self._scope = scope

    @property
    def col_span(self) -> int:
        """
        Gets the col_span of this DocumentBodyTableCellBlockProperties.
        The colSpan for the table cell.

        :return: The col_span of this DocumentBodyTableCellBlockProperties.
        :rtype: int
        """
        return self._col_span

    @col_span.setter
    def col_span(self, col_span: int) -> None:
        """
        Sets the col_span of this DocumentBodyTableCellBlockProperties.
        The colSpan for the table cell.

        :param col_span: The col_span of this DocumentBodyTableCellBlockProperties.
        :type: int
        """
        

        self._col_span = col_span

    @property
    def row_span(self) -> int:
        """
        Gets the row_span of this DocumentBodyTableCellBlockProperties.
        The rowSpan for the table cell.

        :return: The row_span of this DocumentBodyTableCellBlockProperties.
        :rtype: int
        """
        return self._row_span

    @row_span.setter
    def row_span(self, row_span: int) -> None:
        """
        Sets the row_span of this DocumentBodyTableCellBlockProperties.
        The rowSpan for the table cell.

        :param row_span: The row_span of this DocumentBodyTableCellBlockProperties.
        :type: int
        """
        

        self._row_span = row_span

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

