# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DocumentBodyTableCaptionBlock
    from . import DocumentElementLength

class DocumentBodyTableProperties(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DocumentBodyTableProperties - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'width': 'float',
            'width_with_unit': 'DocumentElementLength',
            'height': 'float',
            'cell_spacing': 'float',
            'cell_padding': 'float',
            'border_width': 'float',
            'alignment': 'str',
            'border_style': 'str',
            'border_color': 'str',
            'background_color': 'str',
            'caption': 'DocumentBodyTableCaptionBlock'
        }

        self.attribute_map = {
            'width': 'width',
            'width_with_unit': 'widthWithUnit',
            'height': 'height',
            'cell_spacing': 'cellSpacing',
            'cell_padding': 'cellPadding',
            'border_width': 'borderWidth',
            'alignment': 'alignment',
            'border_style': 'borderStyle',
            'border_color': 'borderColor',
            'background_color': 'backgroundColor',
            'caption': 'caption'
        }

        self._width = None
        self._width_with_unit = None
        self._height = None
        self._cell_spacing = None
        self._cell_padding = None
        self._border_width = None
        self._alignment = None
        self._border_style = None
        self._border_color = None
        self._background_color = None
        self._caption = None

    @property
    def width(self) -> float:
        """
        Gets the width of this DocumentBodyTableProperties.
        The width of the table converted to em unit.

        :return: The width of this DocumentBodyTableProperties.
        :rtype: float
        """
        return self._width

    @width.setter
    def width(self, width: float) -> None:
        """
        Sets the width of this DocumentBodyTableProperties.
        The width of the table converted to em unit.

        :param width: The width of this DocumentBodyTableProperties.
        :type: float
        """
        

        self._width = width

    @property
    def width_with_unit(self) -> 'DocumentElementLength':
        """
        Gets the width_with_unit of this DocumentBodyTableProperties.
        The width of the table in the specified unit.

        :return: The width_with_unit of this DocumentBodyTableProperties.
        :rtype: DocumentElementLength
        """
        return self._width_with_unit

    @width_with_unit.setter
    def width_with_unit(self, width_with_unit: 'DocumentElementLength') -> None:
        """
        Sets the width_with_unit of this DocumentBodyTableProperties.
        The width of the table in the specified unit.

        :param width_with_unit: The width_with_unit of this DocumentBodyTableProperties.
        :type: DocumentElementLength
        """
        

        self._width_with_unit = width_with_unit

    @property
    def height(self) -> float:
        """
        Gets the height of this DocumentBodyTableProperties.
        The height for the table.

        :return: The height of this DocumentBodyTableProperties.
        :rtype: float
        """
        return self._height

    @height.setter
    def height(self, height: float) -> None:
        """
        Sets the height of this DocumentBodyTableProperties.
        The height for the table.

        :param height: The height of this DocumentBodyTableProperties.
        :type: float
        """
        

        self._height = height

    @property
    def cell_spacing(self) -> float:
        """
        Gets the cell_spacing of this DocumentBodyTableProperties.
        The cell spacing for the table. The valid values in 'em'.

        :return: The cell_spacing of this DocumentBodyTableProperties.
        :rtype: float
        """
        return self._cell_spacing

    @cell_spacing.setter
    def cell_spacing(self, cell_spacing: float) -> None:
        """
        Sets the cell_spacing of this DocumentBodyTableProperties.
        The cell spacing for the table. The valid values in 'em'.

        :param cell_spacing: The cell_spacing of this DocumentBodyTableProperties.
        :type: float
        """
        

        self._cell_spacing = cell_spacing

    @property
    def cell_padding(self) -> float:
        """
        Gets the cell_padding of this DocumentBodyTableProperties.
        The cell padding for the table. The valid values in 'em'.

        :return: The cell_padding of this DocumentBodyTableProperties.
        :rtype: float
        """
        return self._cell_padding

    @cell_padding.setter
    def cell_padding(self, cell_padding: float) -> None:
        """
        Sets the cell_padding of this DocumentBodyTableProperties.
        The cell padding for the table. The valid values in 'em'.

        :param cell_padding: The cell_padding of this DocumentBodyTableProperties.
        :type: float
        """
        

        self._cell_padding = cell_padding

    @property
    def border_width(self) -> float:
        """
        Gets the border_width of this DocumentBodyTableProperties.
        The border width for the table. The valid values in 'em'

        :return: The border_width of this DocumentBodyTableProperties.
        :rtype: float
        """
        return self._border_width

    @border_width.setter
    def border_width(self, border_width: float) -> None:
        """
        Sets the border_width of this DocumentBodyTableProperties.
        The border width for the table. The valid values in 'em'

        :param border_width: The border_width of this DocumentBodyTableProperties.
        :type: float
        """
        

        self._border_width = border_width

    @property
    def alignment(self) -> str:
        """
        Gets the alignment of this DocumentBodyTableProperties.
        The alignment for the table.

        :return: The alignment of this DocumentBodyTableProperties.
        :rtype: str
        """
        return self._alignment

    @alignment.setter
    def alignment(self, alignment: str) -> None:
        """
        Sets the alignment of this DocumentBodyTableProperties.
        The alignment for the table.

        :param alignment: The alignment of this DocumentBodyTableProperties.
        :type: str
        """
        if isinstance(alignment, int):
            alignment = str(alignment)
        allowed_values = ["Center", "Left", "Right"]
        if alignment.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for alignment -> " + alignment)
            self._alignment = "outdated_sdk_version"
        else:
            self._alignment = alignment

    @property
    def border_style(self) -> str:
        """
        Gets the border_style of this DocumentBodyTableProperties.
        The border style for the table.

        :return: The border_style of this DocumentBodyTableProperties.
        :rtype: str
        """
        return self._border_style

    @border_style.setter
    def border_style(self, border_style: str) -> None:
        """
        Sets the border_style of this DocumentBodyTableProperties.
        The border style for the table.

        :param border_style: The border_style of this DocumentBodyTableProperties.
        :type: str
        """
        if isinstance(border_style, int):
            border_style = str(border_style)
        allowed_values = ["Solid", "Dotted", "Dashed", "Double", "Groove", "Ridge", "Inset", "Outset", "Hidden", "None"]
        if border_style.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for border_style -> " + border_style)
            self._border_style = "outdated_sdk_version"
        else:
            self._border_style = border_style

    @property
    def border_color(self) -> str:
        """
        Gets the border_color of this DocumentBodyTableProperties.
        The border color for the table. The valid values in hex color code representation. For example black color - #000000

        :return: The border_color of this DocumentBodyTableProperties.
        :rtype: str
        """
        return self._border_color

    @border_color.setter
    def border_color(self, border_color: str) -> None:
        """
        Sets the border_color of this DocumentBodyTableProperties.
        The border color for the table. The valid values in hex color code representation. For example black color - #000000

        :param border_color: The border_color of this DocumentBodyTableProperties.
        :type: str
        """
        

        self._border_color = border_color

    @property
    def background_color(self) -> str:
        """
        Gets the background_color of this DocumentBodyTableProperties.
        The background color for the table. The valid values in hex color code representation. For example black color - #000000

        :return: The background_color of this DocumentBodyTableProperties.
        :rtype: str
        """
        return self._background_color

    @background_color.setter
    def background_color(self, background_color: str) -> None:
        """
        Sets the background_color of this DocumentBodyTableProperties.
        The background color for the table. The valid values in hex color code representation. For example black color - #000000

        :param background_color: The background_color of this DocumentBodyTableProperties.
        :type: str
        """
        

        self._background_color = background_color

    @property
    def caption(self) -> 'DocumentBodyTableCaptionBlock':
        """
        Gets the caption of this DocumentBodyTableProperties.
        The caption for the table. The valid values in hex color code representation. For example black color - #000000

        :return: The caption of this DocumentBodyTableProperties.
        :rtype: DocumentBodyTableCaptionBlock
        """
        return self._caption

    @caption.setter
    def caption(self, caption: 'DocumentBodyTableCaptionBlock') -> None:
        """
        Sets the caption of this DocumentBodyTableProperties.
        The caption for the table. The valid values in hex color code representation. For example black color - #000000

        :param caption: The caption of this DocumentBodyTableProperties.
        :type: DocumentBodyTableCaptionBlock
        """
        

        self._caption = caption

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

