# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DocumentChunkReference

class DocumentChunkBlock(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DocumentChunkBlock - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'text': 'str',
            'confidence': 'float',
            'document': 'DocumentChunkReference'
        }

        self.attribute_map = {
            'id': 'id',
            'text': 'text',
            'confidence': 'confidence',
            'document': 'document'
        }

        self._id = None
        self._text = None
        self._confidence = None
        self._document = None

    @property
    def id(self) -> str:
        """
        Gets the id of this DocumentChunkBlock.
        The globally unique identifier for the chunk.

        :return: The id of this DocumentChunkBlock.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this DocumentChunkBlock.
        The globally unique identifier for the chunk.

        :param id: The id of this DocumentChunkBlock.
        :type: str
        """
        

        self._id = id

    @property
    def text(self) -> str:
        """
        Gets the text of this DocumentChunkBlock.
        The chunk text associated with the variation.

        :return: The text of this DocumentChunkBlock.
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text: str) -> None:
        """
        Sets the text of this DocumentChunkBlock.
        The chunk text associated with the variation.

        :param text: The text of this DocumentChunkBlock.
        :type: str
        """
        

        self._text = text

    @property
    def confidence(self) -> float:
        """
        Gets the confidence of this DocumentChunkBlock.
        The confidence associated with a chunk with respect to a search query.

        :return: The confidence of this DocumentChunkBlock.
        :rtype: float
        """
        return self._confidence

    @confidence.setter
    def confidence(self, confidence: float) -> None:
        """
        Sets the confidence of this DocumentChunkBlock.
        The confidence associated with a chunk with respect to a search query.

        :param confidence: The confidence of this DocumentChunkBlock.
        :type: float
        """
        

        self._confidence = confidence

    @property
    def document(self) -> 'DocumentChunkReference':
        """
        Gets the document of this DocumentChunkBlock.
        Reference to document associated with a chunk

        :return: The document of this DocumentChunkBlock.
        :rtype: DocumentChunkReference
        """
        return self._document

    @document.setter
    def document(self, document: 'DocumentChunkReference') -> None:
        """
        Sets the document of this DocumentChunkBlock.
        Reference to document associated with a chunk

        :param document: The document of this DocumentChunkBlock.
        :type: DocumentChunkReference
        """
        

        self._document = document

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

