# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DocumentBodyImage
    from . import DocumentBodyVideo
    from . import DocumentContentHighlightIndex
    from . import DocumentText

class DocumentContentBlockWithHighlight(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DocumentContentBlockWithHighlight - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'type': 'str',
            'text': 'DocumentText',
            'image': 'DocumentBodyImage',
            'video': 'DocumentBodyVideo',
            'answer_highlight': 'DocumentContentHighlightIndex'
        }

        self.attribute_map = {
            'type': 'type',
            'text': 'text',
            'image': 'image',
            'video': 'video',
            'answer_highlight': 'answerHighlight'
        }

        self._type = None
        self._text = None
        self._image = None
        self._video = None
        self._answer_highlight = None

    @property
    def type(self) -> str:
        """
        Gets the type of this DocumentContentBlockWithHighlight.
        The type of the paragraph block.

        :return: The type of this DocumentContentBlockWithHighlight.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this DocumentContentBlockWithHighlight.
        The type of the paragraph block.

        :param type: The type of this DocumentContentBlockWithHighlight.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Text", "Image", "Video"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def text(self) -> 'DocumentText':
        """
        Gets the text of this DocumentContentBlockWithHighlight.
        Text. It must contain a value if the type of the block is Text.

        :return: The text of this DocumentContentBlockWithHighlight.
        :rtype: DocumentText
        """
        return self._text

    @text.setter
    def text(self, text: 'DocumentText') -> None:
        """
        Sets the text of this DocumentContentBlockWithHighlight.
        Text. It must contain a value if the type of the block is Text.

        :param text: The text of this DocumentContentBlockWithHighlight.
        :type: DocumentText
        """
        

        self._text = text

    @property
    def image(self) -> 'DocumentBodyImage':
        """
        Gets the image of this DocumentContentBlockWithHighlight.
        Image. It must contain a value if the type of the block is Image.

        :return: The image of this DocumentContentBlockWithHighlight.
        :rtype: DocumentBodyImage
        """
        return self._image

    @image.setter
    def image(self, image: 'DocumentBodyImage') -> None:
        """
        Sets the image of this DocumentContentBlockWithHighlight.
        Image. It must contain a value if the type of the block is Image.

        :param image: The image of this DocumentContentBlockWithHighlight.
        :type: DocumentBodyImage
        """
        

        self._image = image

    @property
    def video(self) -> 'DocumentBodyVideo':
        """
        Gets the video of this DocumentContentBlockWithHighlight.
        Video. It must contain a value if the type of the block is Video.

        :return: The video of this DocumentContentBlockWithHighlight.
        :rtype: DocumentBodyVideo
        """
        return self._video

    @video.setter
    def video(self, video: 'DocumentBodyVideo') -> None:
        """
        Sets the video of this DocumentContentBlockWithHighlight.
        Video. It must contain a value if the type of the block is Video.

        :param video: The video of this DocumentContentBlockWithHighlight.
        :type: DocumentBodyVideo
        """
        

        self._video = video

    @property
    def answer_highlight(self) -> 'DocumentContentHighlightIndex':
        """
        Gets the answer_highlight of this DocumentContentBlockWithHighlight.
        The block highlight data.

        :return: The answer_highlight of this DocumentContentBlockWithHighlight.
        :rtype: DocumentContentHighlightIndex
        """
        return self._answer_highlight

    @answer_highlight.setter
    def answer_highlight(self, answer_highlight: 'DocumentContentHighlightIndex') -> None:
        """
        Sets the answer_highlight of this DocumentContentBlockWithHighlight.
        The block highlight data.

        :param answer_highlight: The answer_highlight of this DocumentContentBlockWithHighlight.
        :type: DocumentContentHighlightIndex
        """
        

        self._answer_highlight = answer_highlight

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

