# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DocumentBodyImage
    from . import DocumentBodyListWithHighlight
    from . import DocumentBodyParagraphWithHighlight
    from . import DocumentBodyTableWithHighlight
    from . import DocumentBodyVideo
    from . import DocumentContentHighlightIndex
    from . import DocumentText

class DocumentTableContentBlockWithHighlight(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DocumentTableContentBlockWithHighlight - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'type': 'str',
            'text': 'DocumentText',
            'image': 'DocumentBodyImage',
            'video': 'DocumentBodyVideo',
            'paragraph': 'DocumentBodyParagraphWithHighlight',
            'list': 'DocumentBodyListWithHighlight',
            'table': 'DocumentBodyTableWithHighlight',
            'answer_highlight': 'DocumentContentHighlightIndex'
        }

        self.attribute_map = {
            'type': 'type',
            'text': 'text',
            'image': 'image',
            'video': 'video',
            'paragraph': 'paragraph',
            'list': 'list',
            'table': 'table',
            'answer_highlight': 'answerHighlight'
        }

        self._type = None
        self._text = None
        self._image = None
        self._video = None
        self._paragraph = None
        self._list = None
        self._table = None
        self._answer_highlight = None

    @property
    def type(self) -> str:
        """
        Gets the type of this DocumentTableContentBlockWithHighlight.
        The type of the block for the table cell. This determines which body block object (paragraph, list, video, image or table) would have a value.

        :return: The type of this DocumentTableContentBlockWithHighlight.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this DocumentTableContentBlockWithHighlight.
        The type of the block for the table cell. This determines which body block object (paragraph, list, video, image or table) would have a value.

        :param type: The type of this DocumentTableContentBlockWithHighlight.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Paragraph", "Text", "Image", "Video", "OrderedList", "UnorderedList", "Table"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def text(self) -> 'DocumentText':
        """
        Gets the text of this DocumentTableContentBlockWithHighlight.
        Text. It must contain a value if the type of the block is Text.

        :return: The text of this DocumentTableContentBlockWithHighlight.
        :rtype: DocumentText
        """
        return self._text

    @text.setter
    def text(self, text: 'DocumentText') -> None:
        """
        Sets the text of this DocumentTableContentBlockWithHighlight.
        Text. It must contain a value if the type of the block is Text.

        :param text: The text of this DocumentTableContentBlockWithHighlight.
        :type: DocumentText
        """
        

        self._text = text

    @property
    def image(self) -> 'DocumentBodyImage':
        """
        Gets the image of this DocumentTableContentBlockWithHighlight.
        Image. It must contain a value if the type of the block is Image.

        :return: The image of this DocumentTableContentBlockWithHighlight.
        :rtype: DocumentBodyImage
        """
        return self._image

    @image.setter
    def image(self, image: 'DocumentBodyImage') -> None:
        """
        Sets the image of this DocumentTableContentBlockWithHighlight.
        Image. It must contain a value if the type of the block is Image.

        :param image: The image of this DocumentTableContentBlockWithHighlight.
        :type: DocumentBodyImage
        """
        

        self._image = image

    @property
    def video(self) -> 'DocumentBodyVideo':
        """
        Gets the video of this DocumentTableContentBlockWithHighlight.
        Video. It must contain a value if the type of the block is Video.

        :return: The video of this DocumentTableContentBlockWithHighlight.
        :rtype: DocumentBodyVideo
        """
        return self._video

    @video.setter
    def video(self, video: 'DocumentBodyVideo') -> None:
        """
        Sets the video of this DocumentTableContentBlockWithHighlight.
        Video. It must contain a value if the type of the block is Video.

        :param video: The video of this DocumentTableContentBlockWithHighlight.
        :type: DocumentBodyVideo
        """
        

        self._video = video

    @property
    def paragraph(self) -> 'DocumentBodyParagraphWithHighlight':
        """
        Gets the paragraph of this DocumentTableContentBlockWithHighlight.
        Paragraph. It must contain a value if the type of the block is Paragraph.

        :return: The paragraph of this DocumentTableContentBlockWithHighlight.
        :rtype: DocumentBodyParagraphWithHighlight
        """
        return self._paragraph

    @paragraph.setter
    def paragraph(self, paragraph: 'DocumentBodyParagraphWithHighlight') -> None:
        """
        Sets the paragraph of this DocumentTableContentBlockWithHighlight.
        Paragraph. It must contain a value if the type of the block is Paragraph.

        :param paragraph: The paragraph of this DocumentTableContentBlockWithHighlight.
        :type: DocumentBodyParagraphWithHighlight
        """
        

        self._paragraph = paragraph

    @property
    def list(self) -> 'DocumentBodyListWithHighlight':
        """
        Gets the list of this DocumentTableContentBlockWithHighlight.
        List. It must contain a value if the type of the block is UnorderedList or OrderedList.

        :return: The list of this DocumentTableContentBlockWithHighlight.
        :rtype: DocumentBodyListWithHighlight
        """
        return self._list

    @list.setter
    def list(self, list: 'DocumentBodyListWithHighlight') -> None:
        """
        Sets the list of this DocumentTableContentBlockWithHighlight.
        List. It must contain a value if the type of the block is UnorderedList or OrderedList.

        :param list: The list of this DocumentTableContentBlockWithHighlight.
        :type: DocumentBodyListWithHighlight
        """
        

        self._list = list

    @property
    def table(self) -> 'DocumentBodyTableWithHighlight':
        """
        Gets the table of this DocumentTableContentBlockWithHighlight.
        Table. It must contain a value if the type of the block is Table.

        :return: The table of this DocumentTableContentBlockWithHighlight.
        :rtype: DocumentBodyTableWithHighlight
        """
        return self._table

    @table.setter
    def table(self, table: 'DocumentBodyTableWithHighlight') -> None:
        """
        Sets the table of this DocumentTableContentBlockWithHighlight.
        Table. It must contain a value if the type of the block is Table.

        :param table: The table of this DocumentTableContentBlockWithHighlight.
        :type: DocumentBodyTableWithHighlight
        """
        

        self._table = table

    @property
    def answer_highlight(self) -> 'DocumentContentHighlightIndex':
        """
        Gets the answer_highlight of this DocumentTableContentBlockWithHighlight.
        The block highlight data.

        :return: The answer_highlight of this DocumentTableContentBlockWithHighlight.
        :rtype: DocumentContentHighlightIndex
        """
        return self._answer_highlight

    @answer_highlight.setter
    def answer_highlight(self, answer_highlight: 'DocumentContentHighlightIndex') -> None:
        """
        Sets the answer_highlight of this DocumentTableContentBlockWithHighlight.
        The block highlight data.

        :param answer_highlight: The answer_highlight of this DocumentTableContentBlockWithHighlight.
        :type: DocumentContentHighlightIndex
        """
        

        self._answer_highlight = answer_highlight

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

