# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import DocumentBodyWithHighlight
    from . import DocumentVariationContext
    from . import KnowledgeDocumentReference

class DocumentVariationAnswer(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DocumentVariationAnswer - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'document_version': 'AddressableEntityRef',
            'contexts': 'list[DocumentVariationContext]',
            'document': 'KnowledgeDocumentReference',
            'priority': 'int',
            'name': 'str',
            'body': 'DocumentBodyWithHighlight',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'document_version': 'documentVersion',
            'contexts': 'contexts',
            'document': 'document',
            'priority': 'priority',
            'name': 'name',
            'body': 'body',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._date_created = None
        self._date_modified = None
        self._document_version = None
        self._contexts = None
        self._document = None
        self._priority = None
        self._name = None
        self._body = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this DocumentVariationAnswer.
        The globally unique identifier for the variation.

        :return: The id of this DocumentVariationAnswer.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this DocumentVariationAnswer.
        The globally unique identifier for the variation.

        :param id: The id of this DocumentVariationAnswer.
        :type: str
        """
        

        self._id = id

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this DocumentVariationAnswer.
        The creation date-time for the document variation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this DocumentVariationAnswer.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this DocumentVariationAnswer.
        The creation date-time for the document variation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this DocumentVariationAnswer.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this DocumentVariationAnswer.
        The last modification date-time for the document variation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this DocumentVariationAnswer.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this DocumentVariationAnswer.
        The last modification date-time for the document variation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this DocumentVariationAnswer.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def document_version(self) -> 'AddressableEntityRef':
        """
        Gets the document_version of this DocumentVariationAnswer.
        The version of the document.

        :return: The document_version of this DocumentVariationAnswer.
        :rtype: AddressableEntityRef
        """
        return self._document_version

    @document_version.setter
    def document_version(self, document_version: 'AddressableEntityRef') -> None:
        """
        Sets the document_version of this DocumentVariationAnswer.
        The version of the document.

        :param document_version: The document_version of this DocumentVariationAnswer.
        :type: AddressableEntityRef
        """
        

        self._document_version = document_version

    @property
    def contexts(self) -> List['DocumentVariationContext']:
        """
        Gets the contexts of this DocumentVariationAnswer.
        The context values associated with the variation.

        :return: The contexts of this DocumentVariationAnswer.
        :rtype: list[DocumentVariationContext]
        """
        return self._contexts

    @contexts.setter
    def contexts(self, contexts: List['DocumentVariationContext']) -> None:
        """
        Sets the contexts of this DocumentVariationAnswer.
        The context values associated with the variation.

        :param contexts: The contexts of this DocumentVariationAnswer.
        :type: list[DocumentVariationContext]
        """
        

        self._contexts = contexts

    @property
    def document(self) -> 'KnowledgeDocumentReference':
        """
        Gets the document of this DocumentVariationAnswer.
        The reference to document to which the variation is associated.

        :return: The document of this DocumentVariationAnswer.
        :rtype: KnowledgeDocumentReference
        """
        return self._document

    @document.setter
    def document(self, document: 'KnowledgeDocumentReference') -> None:
        """
        Sets the document of this DocumentVariationAnswer.
        The reference to document to which the variation is associated.

        :param document: The document of this DocumentVariationAnswer.
        :type: KnowledgeDocumentReference
        """
        

        self._document = document

    @property
    def priority(self) -> int:
        """
        Gets the priority of this DocumentVariationAnswer.
        The priority of the variation.

        :return: The priority of this DocumentVariationAnswer.
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority: int) -> None:
        """
        Sets the priority of this DocumentVariationAnswer.
        The priority of the variation.

        :param priority: The priority of this DocumentVariationAnswer.
        :type: int
        """
        

        self._priority = priority

    @property
    def name(self) -> str:
        """
        Gets the name of this DocumentVariationAnswer.
        The name of the variation.

        :return: The name of this DocumentVariationAnswer.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this DocumentVariationAnswer.
        The name of the variation.

        :param name: The name of this DocumentVariationAnswer.
        :type: str
        """
        

        self._name = name

    @property
    def body(self) -> 'DocumentBodyWithHighlight':
        """
        Gets the body of this DocumentVariationAnswer.
        The content for the variation.

        :return: The body of this DocumentVariationAnswer.
        :rtype: DocumentBodyWithHighlight
        """
        return self._body

    @body.setter
    def body(self, body: 'DocumentBodyWithHighlight') -> None:
        """
        Sets the body of this DocumentVariationAnswer.
        The content for the variation.

        :param body: The body of this DocumentVariationAnswer.
        :type: DocumentBodyWithHighlight
        """
        

        self._body = body

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this DocumentVariationAnswer.
        The URI for this object

        :return: The self_uri of this DocumentVariationAnswer.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this DocumentVariationAnswer.
        The URI for this object

        :param self_uri: The self_uri of this DocumentVariationAnswer.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

