# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class DomainEdgeSoftwareVersionDto(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        DomainEdgeSoftwareVersionDto - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'edge_version': 'str',
            'publish_date': 'datetime',
            'edge_uri': 'str',
            'current': 'bool',
            'latest_release': 'bool',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'edge_version': 'edgeVersion',
            'publish_date': 'publishDate',
            'edge_uri': 'edgeUri',
            'current': 'current',
            'latest_release': 'latestRelease',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._edge_version = None
        self._publish_date = None
        self._edge_uri = None
        self._current = None
        self._latest_release = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this DomainEdgeSoftwareVersionDto.
        The globally unique identifier for the object.

        :return: The id of this DomainEdgeSoftwareVersionDto.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this DomainEdgeSoftwareVersionDto.
        The globally unique identifier for the object.

        :param id: The id of this DomainEdgeSoftwareVersionDto.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this DomainEdgeSoftwareVersionDto.


        :return: The name of this DomainEdgeSoftwareVersionDto.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this DomainEdgeSoftwareVersionDto.


        :param name: The name of this DomainEdgeSoftwareVersionDto.
        :type: str
        """
        

        self._name = name

    @property
    def edge_version(self) -> str:
        """
        Gets the edge_version of this DomainEdgeSoftwareVersionDto.


        :return: The edge_version of this DomainEdgeSoftwareVersionDto.
        :rtype: str
        """
        return self._edge_version

    @edge_version.setter
    def edge_version(self, edge_version: str) -> None:
        """
        Sets the edge_version of this DomainEdgeSoftwareVersionDto.


        :param edge_version: The edge_version of this DomainEdgeSoftwareVersionDto.
        :type: str
        """
        

        self._edge_version = edge_version

    @property
    def publish_date(self) -> datetime:
        """
        Gets the publish_date of this DomainEdgeSoftwareVersionDto.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The publish_date of this DomainEdgeSoftwareVersionDto.
        :rtype: datetime
        """
        return self._publish_date

    @publish_date.setter
    def publish_date(self, publish_date: datetime) -> None:
        """
        Sets the publish_date of this DomainEdgeSoftwareVersionDto.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param publish_date: The publish_date of this DomainEdgeSoftwareVersionDto.
        :type: datetime
        """
        

        self._publish_date = publish_date

    @property
    def edge_uri(self) -> str:
        """
        Gets the edge_uri of this DomainEdgeSoftwareVersionDto.


        :return: The edge_uri of this DomainEdgeSoftwareVersionDto.
        :rtype: str
        """
        return self._edge_uri

    @edge_uri.setter
    def edge_uri(self, edge_uri: str) -> None:
        """
        Sets the edge_uri of this DomainEdgeSoftwareVersionDto.


        :param edge_uri: The edge_uri of this DomainEdgeSoftwareVersionDto.
        :type: str
        """
        

        self._edge_uri = edge_uri

    @property
    def current(self) -> bool:
        """
        Gets the current of this DomainEdgeSoftwareVersionDto.


        :return: The current of this DomainEdgeSoftwareVersionDto.
        :rtype: bool
        """
        return self._current

    @current.setter
    def current(self, current: bool) -> None:
        """
        Sets the current of this DomainEdgeSoftwareVersionDto.


        :param current: The current of this DomainEdgeSoftwareVersionDto.
        :type: bool
        """
        

        self._current = current

    @property
    def latest_release(self) -> bool:
        """
        Gets the latest_release of this DomainEdgeSoftwareVersionDto.


        :return: The latest_release of this DomainEdgeSoftwareVersionDto.
        :rtype: bool
        """
        return self._latest_release

    @latest_release.setter
    def latest_release(self, latest_release: bool) -> None:
        """
        Sets the latest_release of this DomainEdgeSoftwareVersionDto.


        :param latest_release: The latest_release of this DomainEdgeSoftwareVersionDto.
        :type: bool
        """
        

        self._latest_release = latest_release

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this DomainEdgeSoftwareVersionDto.
        The URI for this object

        :return: The self_uri of this DomainEdgeSoftwareVersionDto.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this DomainEdgeSoftwareVersionDto.
        The URI for this object

        :param self_uri: The self_uri of this DomainEdgeSoftwareVersionDto.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

