# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import TemporalUnit

class Duration(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        Duration - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'seconds': 'int',
            'zero': 'bool',
            'nano': 'int',
            'negative': 'bool',
            'units': 'list[TemporalUnit]'
        }

        self.attribute_map = {
            'seconds': 'seconds',
            'zero': 'zero',
            'nano': 'nano',
            'negative': 'negative',
            'units': 'units'
        }

        self._seconds = None
        self._zero = None
        self._nano = None
        self._negative = None
        self._units = None

    @property
    def seconds(self) -> int:
        """
        Gets the seconds of this Duration.


        :return: The seconds of this Duration.
        :rtype: int
        """
        return self._seconds

    @seconds.setter
    def seconds(self, seconds: int) -> None:
        """
        Sets the seconds of this Duration.


        :param seconds: The seconds of this Duration.
        :type: int
        """
        

        self._seconds = seconds

    @property
    def zero(self) -> bool:
        """
        Gets the zero of this Duration.


        :return: The zero of this Duration.
        :rtype: bool
        """
        return self._zero

    @zero.setter
    def zero(self, zero: bool) -> None:
        """
        Sets the zero of this Duration.


        :param zero: The zero of this Duration.
        :type: bool
        """
        

        self._zero = zero

    @property
    def nano(self) -> int:
        """
        Gets the nano of this Duration.


        :return: The nano of this Duration.
        :rtype: int
        """
        return self._nano

    @nano.setter
    def nano(self, nano: int) -> None:
        """
        Sets the nano of this Duration.


        :param nano: The nano of this Duration.
        :type: int
        """
        

        self._nano = nano

    @property
    def negative(self) -> bool:
        """
        Gets the negative of this Duration.


        :return: The negative of this Duration.
        :rtype: bool
        """
        return self._negative

    @negative.setter
    def negative(self, negative: bool) -> None:
        """
        Sets the negative of this Duration.


        :param negative: The negative of this Duration.
        :type: bool
        """
        

        self._negative = negative

    @property
    def units(self) -> List['TemporalUnit']:
        """
        Gets the units of this Duration.


        :return: The units of this Duration.
        :rtype: list[TemporalUnit]
        """
        return self._units

    @units.setter
    def units(self, units: List['TemporalUnit']) -> None:
        """
        Sets the units of this Duration.


        :param units: The units of this Duration.
        :type: list[TemporalUnit]
        """
        

        self._units = units

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

