# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class EmailInitialConfiguration(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        EmailInitialConfiguration - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'to': 'str',
            'pcFrom': 'str',
            'cc': 'list[str]',
            'bcc': 'list[str]',
            'subject': 'str',
            'previous_email_id': 'str',
            'held': 'bool',
            'alerting': 'bool',
            'inbound': 'bool',
            'invited_by': 'str',
            'additional_info': 'dict(str, str)'
        }

        self.attribute_map = {
            'to': 'to',
            'pcFrom': 'from',
            'cc': 'cc',
            'bcc': 'bcc',
            'subject': 'subject',
            'previous_email_id': 'previousEmailId',
            'held': 'held',
            'alerting': 'alerting',
            'inbound': 'inbound',
            'invited_by': 'invitedBy',
            'additional_info': 'additionalInfo'
        }

        self._to = None
        self._pcFrom = None
        self._cc = None
        self._bcc = None
        self._subject = None
        self._previous_email_id = None
        self._held = None
        self._alerting = None
        self._inbound = None
        self._invited_by = None
        self._additional_info = None

    @property
    def to(self) -> str:
        """
        Gets the to of this EmailInitialConfiguration.
        An email address that this email is to.

        :return: The to of this EmailInitialConfiguration.
        :rtype: str
        """
        return self._to

    @to.setter
    def to(self, to: str) -> None:
        """
        Sets the to of this EmailInitialConfiguration.
        An email address that this email is to.

        :param to: The to of this EmailInitialConfiguration.
        :type: str
        """
        

        self._to = to

    @property
    def pcFrom(self) -> str:
        """
        Gets the pcFrom of this EmailInitialConfiguration.
        An email address that this email is from.

        :return: The pcFrom of this EmailInitialConfiguration.
        :rtype: str
        """
        return self._pcFrom

    @pcFrom.setter
    def pcFrom(self, pcFrom: str) -> None:
        """
        Sets the pcFrom of this EmailInitialConfiguration.
        An email address that this email is from.

        :param pcFrom: The pcFrom of this EmailInitialConfiguration.
        :type: str
        """
        

        self._pcFrom = pcFrom

    @property
    def cc(self) -> List[str]:
        """
        Gets the cc of this EmailInitialConfiguration.
        An email addresses that this email is carbon copied to.

        :return: The cc of this EmailInitialConfiguration.
        :rtype: list[str]
        """
        return self._cc

    @cc.setter
    def cc(self, cc: List[str]) -> None:
        """
        Sets the cc of this EmailInitialConfiguration.
        An email addresses that this email is carbon copied to.

        :param cc: The cc of this EmailInitialConfiguration.
        :type: list[str]
        """
        

        self._cc = cc

    @property
    def bcc(self) -> List[str]:
        """
        Gets the bcc of this EmailInitialConfiguration.
        An email addresses that this email is blind carbon copied to.

        :return: The bcc of this EmailInitialConfiguration.
        :rtype: list[str]
        """
        return self._bcc

    @bcc.setter
    def bcc(self, bcc: List[str]) -> None:
        """
        Sets the bcc of this EmailInitialConfiguration.
        An email addresses that this email is blind carbon copied to.

        :param bcc: The bcc of this EmailInitialConfiguration.
        :type: list[str]
        """
        

        self._bcc = bcc

    @property
    def subject(self) -> str:
        """
        Gets the subject of this EmailInitialConfiguration.
        The subject for this email.

        :return: The subject of this EmailInitialConfiguration.
        :rtype: str
        """
        return self._subject

    @subject.setter
    def subject(self, subject: str) -> None:
        """
        Sets the subject of this EmailInitialConfiguration.
        The subject for this email.

        :param subject: The subject of this EmailInitialConfiguration.
        :type: str
        """
        

        self._subject = subject

    @property
    def previous_email_id(self) -> str:
        """
        Gets the previous_email_id of this EmailInitialConfiguration.
        UUID identifying the most recent previous email communication ID from the same participant on this email conversation. Will be null if this is a new participant.

        :return: The previous_email_id of this EmailInitialConfiguration.
        :rtype: str
        """
        return self._previous_email_id

    @previous_email_id.setter
    def previous_email_id(self, previous_email_id: str) -> None:
        """
        Sets the previous_email_id of this EmailInitialConfiguration.
        UUID identifying the most recent previous email communication ID from the same participant on this email conversation. Will be null if this is a new participant.

        :param previous_email_id: The previous_email_id of this EmailInitialConfiguration.
        :type: str
        """
        

        self._previous_email_id = previous_email_id

    @property
    def held(self) -> bool:
        """
        Gets the held of this EmailInitialConfiguration.
        Indicates that this communication's initial state is held.

        :return: The held of this EmailInitialConfiguration.
        :rtype: bool
        """
        return self._held

    @held.setter
    def held(self, held: bool) -> None:
        """
        Sets the held of this EmailInitialConfiguration.
        Indicates that this communication's initial state is held.

        :param held: The held of this EmailInitialConfiguration.
        :type: bool
        """
        

        self._held = held

    @property
    def alerting(self) -> bool:
        """
        Gets the alerting of this EmailInitialConfiguration.
        Indicates that this communication's initial state is alerting. If false, the communication started in a connected state.

        :return: The alerting of this EmailInitialConfiguration.
        :rtype: bool
        """
        return self._alerting

    @alerting.setter
    def alerting(self, alerting: bool) -> None:
        """
        Sets the alerting of this EmailInitialConfiguration.
        Indicates that this communication's initial state is alerting. If false, the communication started in a connected state.

        :param alerting: The alerting of this EmailInitialConfiguration.
        :type: bool
        """
        

        self._alerting = alerting

    @property
    def inbound(self) -> bool:
        """
        Gets the inbound of this EmailInitialConfiguration.
        Indicates the direction of this communication with respect to the contact center. `true` means the communication is INBOUND. `false` means the communication is OUTBOUND.

        :return: The inbound of this EmailInitialConfiguration.
        :rtype: bool
        """
        return self._inbound

    @inbound.setter
    def inbound(self, inbound: bool) -> None:
        """
        Sets the inbound of this EmailInitialConfiguration.
        Indicates the direction of this communication with respect to the contact center. `true` means the communication is INBOUND. `false` means the communication is OUTBOUND.

        :param inbound: The inbound of this EmailInitialConfiguration.
        :type: bool
        """
        

        self._inbound = inbound

    @property
    def invited_by(self) -> str:
        """
        Gets the invited_by of this EmailInitialConfiguration.
        The id of the communication (the \"peer\") that \"invited\" this communication, if this occurred.

        :return: The invited_by of this EmailInitialConfiguration.
        :rtype: str
        """
        return self._invited_by

    @invited_by.setter
    def invited_by(self, invited_by: str) -> None:
        """
        Sets the invited_by of this EmailInitialConfiguration.
        The id of the communication (the \"peer\") that \"invited\" this communication, if this occurred.

        :param invited_by: The invited_by of this EmailInitialConfiguration.
        :type: str
        """
        

        self._invited_by = invited_by

    @property
    def additional_info(self) -> Dict[str, str]:
        """
        Gets the additional_info of this EmailInitialConfiguration.
        Additional metadata about this session which should be recorded by the platform but which will not be indexed or searchable. Primarily for diagnostic value. Any information that needs to be accessible through other components like Analytics should be moved to dedicated fields.

        :return: The additional_info of this EmailInitialConfiguration.
        :rtype: dict(str, str)
        """
        return self._additional_info

    @additional_info.setter
    def additional_info(self, additional_info: Dict[str, str]) -> None:
        """
        Sets the additional_info of this EmailInitialConfiguration.
        Additional metadata about this session which should be recorded by the platform but which will not be indexed or searchable. Primarily for diagnostic value. Any information that needs to be accessible through other components like Analytics should be moved to dedicated fields.

        :param additional_info: The additional_info of this EmailInitialConfiguration.
        :type: dict(str, str)
        """
        

        self._additional_info = additional_info

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

