# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import Attachment
    from . import ConversationRoutingData
    from . import DomainEntityRef
    from . import ErrorInfo
    from . import JourneyContext
    from . import Wrapup

class EmailMediaParticipant(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        EmailMediaParticipant - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'address': 'str',
            'start_time': 'datetime',
            'start_alerting_time': 'datetime',
            'connected_time': 'datetime',
            'end_time': 'datetime',
            'start_hold_time': 'datetime',
            'purpose': 'str',
            'state': 'str',
            'direction': 'str',
            'disconnect_type': 'str',
            'held': 'bool',
            'wrapup_required': 'bool',
            'wrapup_prompt': 'str',
            'media_roles': 'list[str]',
            'user': 'DomainEntityRef',
            'queue': 'DomainEntityRef',
            'team': 'DomainEntityRef',
            'attributes': 'dict(str, str)',
            'error_info': 'ErrorInfo',
            'script': 'DomainEntityRef',
            'wrapup_timeout_ms': 'int',
            'wrapup_skipped': 'bool',
            'alerting_timeout_ms': 'int',
            'provider': 'str',
            'external_contact': 'DomainEntityRef',
            'external_contact_initial_division_id': 'str',
            'external_organization': 'DomainEntityRef',
            'wrapup': 'Wrapup',
            'peer': 'str',
            'flagged_reason': 'str',
            'journey_context': 'JourneyContext',
            'conversation_routing_data': 'ConversationRoutingData',
            'start_acw_time': 'datetime',
            'end_acw_time': 'datetime',
            'park_time': 'datetime',
            'resume_time': 'datetime',
            'subject': 'str',
            'messages_sent': 'int',
            'auto_generated': 'bool',
            'draft_attachments': 'list[Attachment]',
            'spam': 'bool',
            'message_id': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'address': 'address',
            'start_time': 'startTime',
            'start_alerting_time': 'startAlertingTime',
            'connected_time': 'connectedTime',
            'end_time': 'endTime',
            'start_hold_time': 'startHoldTime',
            'purpose': 'purpose',
            'state': 'state',
            'direction': 'direction',
            'disconnect_type': 'disconnectType',
            'held': 'held',
            'wrapup_required': 'wrapupRequired',
            'wrapup_prompt': 'wrapupPrompt',
            'media_roles': 'mediaRoles',
            'user': 'user',
            'queue': 'queue',
            'team': 'team',
            'attributes': 'attributes',
            'error_info': 'errorInfo',
            'script': 'script',
            'wrapup_timeout_ms': 'wrapupTimeoutMs',
            'wrapup_skipped': 'wrapupSkipped',
            'alerting_timeout_ms': 'alertingTimeoutMs',
            'provider': 'provider',
            'external_contact': 'externalContact',
            'external_contact_initial_division_id': 'externalContactInitialDivisionId',
            'external_organization': 'externalOrganization',
            'wrapup': 'wrapup',
            'peer': 'peer',
            'flagged_reason': 'flaggedReason',
            'journey_context': 'journeyContext',
            'conversation_routing_data': 'conversationRoutingData',
            'start_acw_time': 'startAcwTime',
            'end_acw_time': 'endAcwTime',
            'park_time': 'parkTime',
            'resume_time': 'resumeTime',
            'subject': 'subject',
            'messages_sent': 'messagesSent',
            'auto_generated': 'autoGenerated',
            'draft_attachments': 'draftAttachments',
            'spam': 'spam',
            'message_id': 'messageId'
        }

        self._id = None
        self._name = None
        self._address = None
        self._start_time = None
        self._start_alerting_time = None
        self._connected_time = None
        self._end_time = None
        self._start_hold_time = None
        self._purpose = None
        self._state = None
        self._direction = None
        self._disconnect_type = None
        self._held = None
        self._wrapup_required = None
        self._wrapup_prompt = None
        self._media_roles = None
        self._user = None
        self._queue = None
        self._team = None
        self._attributes = None
        self._error_info = None
        self._script = None
        self._wrapup_timeout_ms = None
        self._wrapup_skipped = None
        self._alerting_timeout_ms = None
        self._provider = None
        self._external_contact = None
        self._external_contact_initial_division_id = None
        self._external_organization = None
        self._wrapup = None
        self._peer = None
        self._flagged_reason = None
        self._journey_context = None
        self._conversation_routing_data = None
        self._start_acw_time = None
        self._end_acw_time = None
        self._park_time = None
        self._resume_time = None
        self._subject = None
        self._messages_sent = None
        self._auto_generated = None
        self._draft_attachments = None
        self._spam = None
        self._message_id = None

    @property
    def id(self) -> str:
        """
        Gets the id of this EmailMediaParticipant.
        The unique participant ID.

        :return: The id of this EmailMediaParticipant.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this EmailMediaParticipant.
        The unique participant ID.

        :param id: The id of this EmailMediaParticipant.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this EmailMediaParticipant.
        The display friendly name of the participant.

        :return: The name of this EmailMediaParticipant.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this EmailMediaParticipant.
        The display friendly name of the participant.

        :param name: The name of this EmailMediaParticipant.
        :type: str
        """
        

        self._name = name

    @property
    def address(self) -> str:
        """
        Gets the address of this EmailMediaParticipant.
        The participant address.

        :return: The address of this EmailMediaParticipant.
        :rtype: str
        """
        return self._address

    @address.setter
    def address(self, address: str) -> None:
        """
        Sets the address of this EmailMediaParticipant.
        The participant address.

        :param address: The address of this EmailMediaParticipant.
        :type: str
        """
        

        self._address = address

    @property
    def start_time(self) -> datetime:
        """
        Gets the start_time of this EmailMediaParticipant.
        The time when this participant first joined the conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The start_time of this EmailMediaParticipant.
        :rtype: datetime
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time: datetime) -> None:
        """
        Sets the start_time of this EmailMediaParticipant.
        The time when this participant first joined the conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param start_time: The start_time of this EmailMediaParticipant.
        :type: datetime
        """
        

        self._start_time = start_time

    @property
    def start_alerting_time(self) -> datetime:
        """
        Gets the start_alerting_time of this EmailMediaParticipant.
        The timestamp when it is first put into an alerting state. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The start_alerting_time of this EmailMediaParticipant.
        :rtype: datetime
        """
        return self._start_alerting_time

    @start_alerting_time.setter
    def start_alerting_time(self, start_alerting_time: datetime) -> None:
        """
        Sets the start_alerting_time of this EmailMediaParticipant.
        The timestamp when it is first put into an alerting state. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param start_alerting_time: The start_alerting_time of this EmailMediaParticipant.
        :type: datetime
        """
        

        self._start_alerting_time = start_alerting_time

    @property
    def connected_time(self) -> datetime:
        """
        Gets the connected_time of this EmailMediaParticipant.
        The time when this participant went connected for this media (eg: video connected time). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The connected_time of this EmailMediaParticipant.
        :rtype: datetime
        """
        return self._connected_time

    @connected_time.setter
    def connected_time(self, connected_time: datetime) -> None:
        """
        Sets the connected_time of this EmailMediaParticipant.
        The time when this participant went connected for this media (eg: video connected time). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param connected_time: The connected_time of this EmailMediaParticipant.
        :type: datetime
        """
        

        self._connected_time = connected_time

    @property
    def end_time(self) -> datetime:
        """
        Gets the end_time of this EmailMediaParticipant.
        The time when this participant went disconnected for this media (eg: video disconnected time). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The end_time of this EmailMediaParticipant.
        :rtype: datetime
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time: datetime) -> None:
        """
        Sets the end_time of this EmailMediaParticipant.
        The time when this participant went disconnected for this media (eg: video disconnected time). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param end_time: The end_time of this EmailMediaParticipant.
        :type: datetime
        """
        

        self._end_time = end_time

    @property
    def start_hold_time(self) -> datetime:
        """
        Gets the start_hold_time of this EmailMediaParticipant.
        The time when this participant's hold started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The start_hold_time of this EmailMediaParticipant.
        :rtype: datetime
        """
        return self._start_hold_time

    @start_hold_time.setter
    def start_hold_time(self, start_hold_time: datetime) -> None:
        """
        Sets the start_hold_time of this EmailMediaParticipant.
        The time when this participant's hold started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param start_hold_time: The start_hold_time of this EmailMediaParticipant.
        :type: datetime
        """
        

        self._start_hold_time = start_hold_time

    @property
    def purpose(self) -> str:
        """
        Gets the purpose of this EmailMediaParticipant.
        The participant's purpose.  Values can be: 'agent', 'user', 'customer', 'external', 'acd', 'ivr

        :return: The purpose of this EmailMediaParticipant.
        :rtype: str
        """
        return self._purpose

    @purpose.setter
    def purpose(self, purpose: str) -> None:
        """
        Sets the purpose of this EmailMediaParticipant.
        The participant's purpose.  Values can be: 'agent', 'user', 'customer', 'external', 'acd', 'ivr

        :param purpose: The purpose of this EmailMediaParticipant.
        :type: str
        """
        

        self._purpose = purpose

    @property
    def state(self) -> str:
        """
        Gets the state of this EmailMediaParticipant.
        The participant's state.  Values can be: 'alerting', 'connected', 'disconnected', 'dialing', 'contacting

        :return: The state of this EmailMediaParticipant.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this EmailMediaParticipant.
        The participant's state.  Values can be: 'alerting', 'connected', 'disconnected', 'dialing', 'contacting

        :param state: The state of this EmailMediaParticipant.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "converting", "uploading", "transmitting", "parked", "none"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def direction(self) -> str:
        """
        Gets the direction of this EmailMediaParticipant.
        The participant's direction.  Values can be: 'inbound' or 'outbound'

        :return: The direction of this EmailMediaParticipant.
        :rtype: str
        """
        return self._direction

    @direction.setter
    def direction(self, direction: str) -> None:
        """
        Sets the direction of this EmailMediaParticipant.
        The participant's direction.  Values can be: 'inbound' or 'outbound'

        :param direction: The direction of this EmailMediaParticipant.
        :type: str
        """
        if isinstance(direction, int):
            direction = str(direction)
        allowed_values = ["inbound", "outbound"]
        if direction.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for direction -> " + direction)
            self._direction = "outdated_sdk_version"
        else:
            self._direction = direction

    @property
    def disconnect_type(self) -> str:
        """
        Gets the disconnect_type of this EmailMediaParticipant.
        The reason the participant was disconnected from the conversation.

        :return: The disconnect_type of this EmailMediaParticipant.
        :rtype: str
        """
        return self._disconnect_type

    @disconnect_type.setter
    def disconnect_type(self, disconnect_type: str) -> None:
        """
        Sets the disconnect_type of this EmailMediaParticipant.
        The reason the participant was disconnected from the conversation.

        :param disconnect_type: The disconnect_type of this EmailMediaParticipant.
        :type: str
        """
        if isinstance(disconnect_type, int):
            disconnect_type = str(disconnect_type)
        allowed_values = ["endpoint", "endpoint.donotdisturb", "client", "system", "transfer", "transfer.conference", "transfer.consult", "transfer.donotdisturb", "transfer.forward", "transfer.noanswer", "transfer.notavailable", "transport.failure", "error", "peer", "other", "spam", "inactivity"]
        if disconnect_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for disconnect_type -> " + disconnect_type)
            self._disconnect_type = "outdated_sdk_version"
        else:
            self._disconnect_type = disconnect_type

    @property
    def held(self) -> bool:
        """
        Gets the held of this EmailMediaParticipant.
        Value is true when the participant is on hold.

        :return: The held of this EmailMediaParticipant.
        :rtype: bool
        """
        return self._held

    @held.setter
    def held(self, held: bool) -> None:
        """
        Sets the held of this EmailMediaParticipant.
        Value is true when the participant is on hold.

        :param held: The held of this EmailMediaParticipant.
        :type: bool
        """
        

        self._held = held

    @property
    def wrapup_required(self) -> bool:
        """
        Gets the wrapup_required of this EmailMediaParticipant.
        Value is true when the participant requires wrap-up.

        :return: The wrapup_required of this EmailMediaParticipant.
        :rtype: bool
        """
        return self._wrapup_required

    @wrapup_required.setter
    def wrapup_required(self, wrapup_required: bool) -> None:
        """
        Sets the wrapup_required of this EmailMediaParticipant.
        Value is true when the participant requires wrap-up.

        :param wrapup_required: The wrapup_required of this EmailMediaParticipant.
        :type: bool
        """
        

        self._wrapup_required = wrapup_required

    @property
    def wrapup_prompt(self) -> str:
        """
        Gets the wrapup_prompt of this EmailMediaParticipant.
        The wrap-up prompt indicating the type of wrap-up to be performed.

        :return: The wrapup_prompt of this EmailMediaParticipant.
        :rtype: str
        """
        return self._wrapup_prompt

    @wrapup_prompt.setter
    def wrapup_prompt(self, wrapup_prompt: str) -> None:
        """
        Sets the wrapup_prompt of this EmailMediaParticipant.
        The wrap-up prompt indicating the type of wrap-up to be performed.

        :param wrapup_prompt: The wrapup_prompt of this EmailMediaParticipant.
        :type: str
        """
        

        self._wrapup_prompt = wrapup_prompt

    @property
    def media_roles(self) -> List[str]:
        """
        Gets the media_roles of this EmailMediaParticipant.
        List of roles this participant's media has had on the conversation, ie monitor, coach, etc

        :return: The media_roles of this EmailMediaParticipant.
        :rtype: list[str]
        """
        return self._media_roles

    @media_roles.setter
    def media_roles(self, media_roles: List[str]) -> None:
        """
        Sets the media_roles of this EmailMediaParticipant.
        List of roles this participant's media has had on the conversation, ie monitor, coach, etc

        :param media_roles: The media_roles of this EmailMediaParticipant.
        :type: list[str]
        """
        

        self._media_roles = media_roles

    @property
    def user(self) -> 'DomainEntityRef':
        """
        Gets the user of this EmailMediaParticipant.
        The PureCloud user for this participant.

        :return: The user of this EmailMediaParticipant.
        :rtype: DomainEntityRef
        """
        return self._user

    @user.setter
    def user(self, user: 'DomainEntityRef') -> None:
        """
        Sets the user of this EmailMediaParticipant.
        The PureCloud user for this participant.

        :param user: The user of this EmailMediaParticipant.
        :type: DomainEntityRef
        """
        

        self._user = user

    @property
    def queue(self) -> 'DomainEntityRef':
        """
        Gets the queue of this EmailMediaParticipant.
        The PureCloud queue for this participant.

        :return: The queue of this EmailMediaParticipant.
        :rtype: DomainEntityRef
        """
        return self._queue

    @queue.setter
    def queue(self, queue: 'DomainEntityRef') -> None:
        """
        Sets the queue of this EmailMediaParticipant.
        The PureCloud queue for this participant.

        :param queue: The queue of this EmailMediaParticipant.
        :type: DomainEntityRef
        """
        

        self._queue = queue

    @property
    def team(self) -> 'DomainEntityRef':
        """
        Gets the team of this EmailMediaParticipant.
        The PureCloud team for this participant.

        :return: The team of this EmailMediaParticipant.
        :rtype: DomainEntityRef
        """
        return self._team

    @team.setter
    def team(self, team: 'DomainEntityRef') -> None:
        """
        Sets the team of this EmailMediaParticipant.
        The PureCloud team for this participant.

        :param team: The team of this EmailMediaParticipant.
        :type: DomainEntityRef
        """
        

        self._team = team

    @property
    def attributes(self) -> Dict[str, str]:
        """
        Gets the attributes of this EmailMediaParticipant.
        A list of ad-hoc attributes for the participant.

        :return: The attributes of this EmailMediaParticipant.
        :rtype: dict(str, str)
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes: Dict[str, str]) -> None:
        """
        Sets the attributes of this EmailMediaParticipant.
        A list of ad-hoc attributes for the participant.

        :param attributes: The attributes of this EmailMediaParticipant.
        :type: dict(str, str)
        """
        

        self._attributes = attributes

    @property
    def error_info(self) -> 'ErrorInfo':
        """
        Gets the error_info of this EmailMediaParticipant.
        If the conversation ends in error, contains additional error details.

        :return: The error_info of this EmailMediaParticipant.
        :rtype: ErrorInfo
        """
        return self._error_info

    @error_info.setter
    def error_info(self, error_info: 'ErrorInfo') -> None:
        """
        Sets the error_info of this EmailMediaParticipant.
        If the conversation ends in error, contains additional error details.

        :param error_info: The error_info of this EmailMediaParticipant.
        :type: ErrorInfo
        """
        

        self._error_info = error_info

    @property
    def script(self) -> 'DomainEntityRef':
        """
        Gets the script of this EmailMediaParticipant.
        The Engage script that should be used by this participant.

        :return: The script of this EmailMediaParticipant.
        :rtype: DomainEntityRef
        """
        return self._script

    @script.setter
    def script(self, script: 'DomainEntityRef') -> None:
        """
        Sets the script of this EmailMediaParticipant.
        The Engage script that should be used by this participant.

        :param script: The script of this EmailMediaParticipant.
        :type: DomainEntityRef
        """
        

        self._script = script

    @property
    def wrapup_timeout_ms(self) -> int:
        """
        Gets the wrapup_timeout_ms of this EmailMediaParticipant.
        The amount of time the participant has to complete wrap-up.

        :return: The wrapup_timeout_ms of this EmailMediaParticipant.
        :rtype: int
        """
        return self._wrapup_timeout_ms

    @wrapup_timeout_ms.setter
    def wrapup_timeout_ms(self, wrapup_timeout_ms: int) -> None:
        """
        Sets the wrapup_timeout_ms of this EmailMediaParticipant.
        The amount of time the participant has to complete wrap-up.

        :param wrapup_timeout_ms: The wrapup_timeout_ms of this EmailMediaParticipant.
        :type: int
        """
        

        self._wrapup_timeout_ms = wrapup_timeout_ms

    @property
    def wrapup_skipped(self) -> bool:
        """
        Gets the wrapup_skipped of this EmailMediaParticipant.
        Value is true when the participant has skipped wrap-up.

        :return: The wrapup_skipped of this EmailMediaParticipant.
        :rtype: bool
        """
        return self._wrapup_skipped

    @wrapup_skipped.setter
    def wrapup_skipped(self, wrapup_skipped: bool) -> None:
        """
        Sets the wrapup_skipped of this EmailMediaParticipant.
        Value is true when the participant has skipped wrap-up.

        :param wrapup_skipped: The wrapup_skipped of this EmailMediaParticipant.
        :type: bool
        """
        

        self._wrapup_skipped = wrapup_skipped

    @property
    def alerting_timeout_ms(self) -> int:
        """
        Gets the alerting_timeout_ms of this EmailMediaParticipant.
        Specifies how long the agent has to answer an interaction before being marked as not responding.

        :return: The alerting_timeout_ms of this EmailMediaParticipant.
        :rtype: int
        """
        return self._alerting_timeout_ms

    @alerting_timeout_ms.setter
    def alerting_timeout_ms(self, alerting_timeout_ms: int) -> None:
        """
        Sets the alerting_timeout_ms of this EmailMediaParticipant.
        Specifies how long the agent has to answer an interaction before being marked as not responding.

        :param alerting_timeout_ms: The alerting_timeout_ms of this EmailMediaParticipant.
        :type: int
        """
        

        self._alerting_timeout_ms = alerting_timeout_ms

    @property
    def provider(self) -> str:
        """
        Gets the provider of this EmailMediaParticipant.
        The source provider for the communication.

        :return: The provider of this EmailMediaParticipant.
        :rtype: str
        """
        return self._provider

    @provider.setter
    def provider(self, provider: str) -> None:
        """
        Sets the provider of this EmailMediaParticipant.
        The source provider for the communication.

        :param provider: The provider of this EmailMediaParticipant.
        :type: str
        """
        

        self._provider = provider

    @property
    def external_contact(self) -> 'DomainEntityRef':
        """
        Gets the external_contact of this EmailMediaParticipant.
        If this participant represents an external contact, then this will be the reference for the external contact.

        :return: The external_contact of this EmailMediaParticipant.
        :rtype: DomainEntityRef
        """
        return self._external_contact

    @external_contact.setter
    def external_contact(self, external_contact: 'DomainEntityRef') -> None:
        """
        Sets the external_contact of this EmailMediaParticipant.
        If this participant represents an external contact, then this will be the reference for the external contact.

        :param external_contact: The external_contact of this EmailMediaParticipant.
        :type: DomainEntityRef
        """
        

        self._external_contact = external_contact

    @property
    def external_contact_initial_division_id(self) -> str:
        """
        Gets the external_contact_initial_division_id of this EmailMediaParticipant.
        If this participant represents an external contact, then this will be the initial division for the external contact. This value will not be updated if the external contact is reassigned.

        :return: The external_contact_initial_division_id of this EmailMediaParticipant.
        :rtype: str
        """
        return self._external_contact_initial_division_id

    @external_contact_initial_division_id.setter
    def external_contact_initial_division_id(self, external_contact_initial_division_id: str) -> None:
        """
        Sets the external_contact_initial_division_id of this EmailMediaParticipant.
        If this participant represents an external contact, then this will be the initial division for the external contact. This value will not be updated if the external contact is reassigned.

        :param external_contact_initial_division_id: The external_contact_initial_division_id of this EmailMediaParticipant.
        :type: str
        """
        

        self._external_contact_initial_division_id = external_contact_initial_division_id

    @property
    def external_organization(self) -> 'DomainEntityRef':
        """
        Gets the external_organization of this EmailMediaParticipant.
        If this participant represents an external org, then this will be the reference for the external org.

        :return: The external_organization of this EmailMediaParticipant.
        :rtype: DomainEntityRef
        """
        return self._external_organization

    @external_organization.setter
    def external_organization(self, external_organization: 'DomainEntityRef') -> None:
        """
        Sets the external_organization of this EmailMediaParticipant.
        If this participant represents an external org, then this will be the reference for the external org.

        :param external_organization: The external_organization of this EmailMediaParticipant.
        :type: DomainEntityRef
        """
        

        self._external_organization = external_organization

    @property
    def wrapup(self) -> 'Wrapup':
        """
        Gets the wrapup of this EmailMediaParticipant.
        Wrapup for this participant, if it has been applied.

        :return: The wrapup of this EmailMediaParticipant.
        :rtype: Wrapup
        """
        return self._wrapup

    @wrapup.setter
    def wrapup(self, wrapup: 'Wrapup') -> None:
        """
        Sets the wrapup of this EmailMediaParticipant.
        Wrapup for this participant, if it has been applied.

        :param wrapup: The wrapup of this EmailMediaParticipant.
        :type: Wrapup
        """
        

        self._wrapup = wrapup

    @property
    def peer(self) -> str:
        """
        Gets the peer of this EmailMediaParticipant.
        The peer communication corresponding to a matching leg for this communication.

        :return: The peer of this EmailMediaParticipant.
        :rtype: str
        """
        return self._peer

    @peer.setter
    def peer(self, peer: str) -> None:
        """
        Sets the peer of this EmailMediaParticipant.
        The peer communication corresponding to a matching leg for this communication.

        :param peer: The peer of this EmailMediaParticipant.
        :type: str
        """
        

        self._peer = peer

    @property
    def flagged_reason(self) -> str:
        """
        Gets the flagged_reason of this EmailMediaParticipant.
        The reason specifying why participant flagged the conversation.

        :return: The flagged_reason of this EmailMediaParticipant.
        :rtype: str
        """
        return self._flagged_reason

    @flagged_reason.setter
    def flagged_reason(self, flagged_reason: str) -> None:
        """
        Sets the flagged_reason of this EmailMediaParticipant.
        The reason specifying why participant flagged the conversation.

        :param flagged_reason: The flagged_reason of this EmailMediaParticipant.
        :type: str
        """
        if isinstance(flagged_reason, int):
            flagged_reason = str(flagged_reason)
        allowed_values = ["general"]
        if flagged_reason.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for flagged_reason -> " + flagged_reason)
            self._flagged_reason = "outdated_sdk_version"
        else:
            self._flagged_reason = flagged_reason

    @property
    def journey_context(self) -> 'JourneyContext':
        """
        Gets the journey_context of this EmailMediaParticipant.
        Journey System data/context that is applicable to this communication.  When used for historical purposes, the context should be immutable.  When null, there is no applicable Journey System context.

        :return: The journey_context of this EmailMediaParticipant.
        :rtype: JourneyContext
        """
        return self._journey_context

    @journey_context.setter
    def journey_context(self, journey_context: 'JourneyContext') -> None:
        """
        Sets the journey_context of this EmailMediaParticipant.
        Journey System data/context that is applicable to this communication.  When used for historical purposes, the context should be immutable.  When null, there is no applicable Journey System context.

        :param journey_context: The journey_context of this EmailMediaParticipant.
        :type: JourneyContext
        """
        

        self._journey_context = journey_context

    @property
    def conversation_routing_data(self) -> 'ConversationRoutingData':
        """
        Gets the conversation_routing_data of this EmailMediaParticipant.
        Information on how a communication should be routed to an agent.

        :return: The conversation_routing_data of this EmailMediaParticipant.
        :rtype: ConversationRoutingData
        """
        return self._conversation_routing_data

    @conversation_routing_data.setter
    def conversation_routing_data(self, conversation_routing_data: 'ConversationRoutingData') -> None:
        """
        Sets the conversation_routing_data of this EmailMediaParticipant.
        Information on how a communication should be routed to an agent.

        :param conversation_routing_data: The conversation_routing_data of this EmailMediaParticipant.
        :type: ConversationRoutingData
        """
        

        self._conversation_routing_data = conversation_routing_data

    @property
    def start_acw_time(self) -> datetime:
        """
        Gets the start_acw_time of this EmailMediaParticipant.
        The timestamp when this participant started after-call work. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The start_acw_time of this EmailMediaParticipant.
        :rtype: datetime
        """
        return self._start_acw_time

    @start_acw_time.setter
    def start_acw_time(self, start_acw_time: datetime) -> None:
        """
        Sets the start_acw_time of this EmailMediaParticipant.
        The timestamp when this participant started after-call work. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param start_acw_time: The start_acw_time of this EmailMediaParticipant.
        :type: datetime
        """
        

        self._start_acw_time = start_acw_time

    @property
    def end_acw_time(self) -> datetime:
        """
        Gets the end_acw_time of this EmailMediaParticipant.
        The timestamp when this participant ended after-call work. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The end_acw_time of this EmailMediaParticipant.
        :rtype: datetime
        """
        return self._end_acw_time

    @end_acw_time.setter
    def end_acw_time(self, end_acw_time: datetime) -> None:
        """
        Sets the end_acw_time of this EmailMediaParticipant.
        The timestamp when this participant ended after-call work. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param end_acw_time: The end_acw_time of this EmailMediaParticipant.
        :type: datetime
        """
        

        self._end_acw_time = end_acw_time

    @property
    def park_time(self) -> datetime:
        """
        Gets the park_time of this EmailMediaParticipant.
        The time when this participant's communication was last parked.  Does not reset on resume. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The park_time of this EmailMediaParticipant.
        :rtype: datetime
        """
        return self._park_time

    @park_time.setter
    def park_time(self, park_time: datetime) -> None:
        """
        Sets the park_time of this EmailMediaParticipant.
        The time when this participant's communication was last parked.  Does not reset on resume. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param park_time: The park_time of this EmailMediaParticipant.
        :type: datetime
        """
        

        self._park_time = park_time

    @property
    def resume_time(self) -> datetime:
        """
        Gets the resume_time of this EmailMediaParticipant.
        The time when this participant's communications will resume. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The resume_time of this EmailMediaParticipant.
        :rtype: datetime
        """
        return self._resume_time

    @resume_time.setter
    def resume_time(self, resume_time: datetime) -> None:
        """
        Sets the resume_time of this EmailMediaParticipant.
        The time when this participant's communications will resume. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param resume_time: The resume_time of this EmailMediaParticipant.
        :type: datetime
        """
        

        self._resume_time = resume_time

    @property
    def subject(self) -> str:
        """
        Gets the subject of this EmailMediaParticipant.
        The subject of the email.

        :return: The subject of this EmailMediaParticipant.
        :rtype: str
        """
        return self._subject

    @subject.setter
    def subject(self, subject: str) -> None:
        """
        Sets the subject of this EmailMediaParticipant.
        The subject of the email.

        :param subject: The subject of this EmailMediaParticipant.
        :type: str
        """
        

        self._subject = subject

    @property
    def messages_sent(self) -> int:
        """
        Gets the messages_sent of this EmailMediaParticipant.
        The number of messages that have been sent in this email conversation.

        :return: The messages_sent of this EmailMediaParticipant.
        :rtype: int
        """
        return self._messages_sent

    @messages_sent.setter
    def messages_sent(self, messages_sent: int) -> None:
        """
        Sets the messages_sent of this EmailMediaParticipant.
        The number of messages that have been sent in this email conversation.

        :param messages_sent: The messages_sent of this EmailMediaParticipant.
        :type: int
        """
        

        self._messages_sent = messages_sent

    @property
    def auto_generated(self) -> bool:
        """
        Gets the auto_generated of this EmailMediaParticipant.
        Indicates that the email was auto-generated like an Out of Office reply.

        :return: The auto_generated of this EmailMediaParticipant.
        :rtype: bool
        """
        return self._auto_generated

    @auto_generated.setter
    def auto_generated(self, auto_generated: bool) -> None:
        """
        Sets the auto_generated of this EmailMediaParticipant.
        Indicates that the email was auto-generated like an Out of Office reply.

        :param auto_generated: The auto_generated of this EmailMediaParticipant.
        :type: bool
        """
        

        self._auto_generated = auto_generated

    @property
    def draft_attachments(self) -> List['Attachment']:
        """
        Gets the draft_attachments of this EmailMediaParticipant.
        A list of uploaded attachments on the email draft.

        :return: The draft_attachments of this EmailMediaParticipant.
        :rtype: list[Attachment]
        """
        return self._draft_attachments

    @draft_attachments.setter
    def draft_attachments(self, draft_attachments: List['Attachment']) -> None:
        """
        Sets the draft_attachments of this EmailMediaParticipant.
        A list of uploaded attachments on the email draft.

        :param draft_attachments: The draft_attachments of this EmailMediaParticipant.
        :type: list[Attachment]
        """
        

        self._draft_attachments = draft_attachments

    @property
    def spam(self) -> bool:
        """
        Gets the spam of this EmailMediaParticipant.
        Indicates if the inbound email was marked as spam.

        :return: The spam of this EmailMediaParticipant.
        :rtype: bool
        """
        return self._spam

    @spam.setter
    def spam(self, spam: bool) -> None:
        """
        Sets the spam of this EmailMediaParticipant.
        Indicates if the inbound email was marked as spam.

        :param spam: The spam of this EmailMediaParticipant.
        :type: bool
        """
        

        self._spam = spam

    @property
    def message_id(self) -> str:
        """
        Gets the message_id of this EmailMediaParticipant.
        A globally unique identifier for the stored content of this communication.

        :return: The message_id of this EmailMediaParticipant.
        :rtype: str
        """
        return self._message_id

    @message_id.setter
    def message_id(self, message_id: str) -> None:
        """
        Sets the message_id of this EmailMediaParticipant.
        A globally unique identifier for the stored content of this communication.

        :param message_id: The message_id of this EmailMediaParticipant.
        :type: str
        """
        

        self._message_id = message_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

