# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import Attachment
    from . import EmailAddress

class EmailMessageReply(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        EmailMessageReply - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'to': 'list[EmailAddress]',
            'cc': 'list[EmailAddress]',
            'bcc': 'list[EmailAddress]',
            'pcFrom': 'EmailAddress',
            'reply_to': 'EmailAddress',
            'subject': 'str',
            'attachments': 'list[Attachment]',
            'text_body': 'str',
            'html_body': 'str',
            'time': 'datetime',
            'history_included': 'bool',
            'email_size_bytes': 'int',
            'max_email_size_bytes': 'int'
        }

        self.attribute_map = {
            'to': 'to',
            'cc': 'cc',
            'bcc': 'bcc',
            'pcFrom': 'from',
            'reply_to': 'replyTo',
            'subject': 'subject',
            'attachments': 'attachments',
            'text_body': 'textBody',
            'html_body': 'htmlBody',
            'time': 'time',
            'history_included': 'historyIncluded',
            'email_size_bytes': 'emailSizeBytes',
            'max_email_size_bytes': 'maxEmailSizeBytes'
        }

        self._to = None
        self._cc = None
        self._bcc = None
        self._pcFrom = None
        self._reply_to = None
        self._subject = None
        self._attachments = None
        self._text_body = None
        self._html_body = None
        self._time = None
        self._history_included = None
        self._email_size_bytes = None
        self._max_email_size_bytes = None

    @property
    def to(self) -> List['EmailAddress']:
        """
        Gets the to of this EmailMessageReply.
        The recipients of the email message.

        :return: The to of this EmailMessageReply.
        :rtype: list[EmailAddress]
        """
        return self._to

    @to.setter
    def to(self, to: List['EmailAddress']) -> None:
        """
        Sets the to of this EmailMessageReply.
        The recipients of the email message.

        :param to: The to of this EmailMessageReply.
        :type: list[EmailAddress]
        """
        

        self._to = to

    @property
    def cc(self) -> List['EmailAddress']:
        """
        Gets the cc of this EmailMessageReply.
        The recipients that were copied on the email message.

        :return: The cc of this EmailMessageReply.
        :rtype: list[EmailAddress]
        """
        return self._cc

    @cc.setter
    def cc(self, cc: List['EmailAddress']) -> None:
        """
        Sets the cc of this EmailMessageReply.
        The recipients that were copied on the email message.

        :param cc: The cc of this EmailMessageReply.
        :type: list[EmailAddress]
        """
        

        self._cc = cc

    @property
    def bcc(self) -> List['EmailAddress']:
        """
        Gets the bcc of this EmailMessageReply.
        The recipients that were blind copied on the email message.

        :return: The bcc of this EmailMessageReply.
        :rtype: list[EmailAddress]
        """
        return self._bcc

    @bcc.setter
    def bcc(self, bcc: List['EmailAddress']) -> None:
        """
        Sets the bcc of this EmailMessageReply.
        The recipients that were blind copied on the email message.

        :param bcc: The bcc of this EmailMessageReply.
        :type: list[EmailAddress]
        """
        

        self._bcc = bcc

    @property
    def pcFrom(self) -> 'EmailAddress':
        """
        Gets the pcFrom of this EmailMessageReply.
        The sender of the email message.

        :return: The pcFrom of this EmailMessageReply.
        :rtype: EmailAddress
        """
        return self._pcFrom

    @pcFrom.setter
    def pcFrom(self, pcFrom: 'EmailAddress') -> None:
        """
        Sets the pcFrom of this EmailMessageReply.
        The sender of the email message.

        :param pcFrom: The pcFrom of this EmailMessageReply.
        :type: EmailAddress
        """
        

        self._pcFrom = pcFrom

    @property
    def reply_to(self) -> 'EmailAddress':
        """
        Gets the reply_to of this EmailMessageReply.
        The receiver of the reply email message.

        :return: The reply_to of this EmailMessageReply.
        :rtype: EmailAddress
        """
        return self._reply_to

    @reply_to.setter
    def reply_to(self, reply_to: 'EmailAddress') -> None:
        """
        Sets the reply_to of this EmailMessageReply.
        The receiver of the reply email message.

        :param reply_to: The reply_to of this EmailMessageReply.
        :type: EmailAddress
        """
        

        self._reply_to = reply_to

    @property
    def subject(self) -> str:
        """
        Gets the subject of this EmailMessageReply.
        The subject of the email message.

        :return: The subject of this EmailMessageReply.
        :rtype: str
        """
        return self._subject

    @subject.setter
    def subject(self, subject: str) -> None:
        """
        Sets the subject of this EmailMessageReply.
        The subject of the email message.

        :param subject: The subject of this EmailMessageReply.
        :type: str
        """
        

        self._subject = subject

    @property
    def attachments(self) -> List['Attachment']:
        """
        Gets the attachments of this EmailMessageReply.
        The attachments of the email message.

        :return: The attachments of this EmailMessageReply.
        :rtype: list[Attachment]
        """
        return self._attachments

    @attachments.setter
    def attachments(self, attachments: List['Attachment']) -> None:
        """
        Sets the attachments of this EmailMessageReply.
        The attachments of the email message.

        :param attachments: The attachments of this EmailMessageReply.
        :type: list[Attachment]
        """
        

        self._attachments = attachments

    @property
    def text_body(self) -> str:
        """
        Gets the text_body of this EmailMessageReply.
        The text body of the email message.

        :return: The text_body of this EmailMessageReply.
        :rtype: str
        """
        return self._text_body

    @text_body.setter
    def text_body(self, text_body: str) -> None:
        """
        Sets the text_body of this EmailMessageReply.
        The text body of the email message.

        :param text_body: The text_body of this EmailMessageReply.
        :type: str
        """
        

        self._text_body = text_body

    @property
    def html_body(self) -> str:
        """
        Gets the html_body of this EmailMessageReply.
        The html body of the email message.

        :return: The html_body of this EmailMessageReply.
        :rtype: str
        """
        return self._html_body

    @html_body.setter
    def html_body(self, html_body: str) -> None:
        """
        Sets the html_body of this EmailMessageReply.
        The html body of the email message.

        :param html_body: The html_body of this EmailMessageReply.
        :type: str
        """
        

        self._html_body = html_body

    @property
    def time(self) -> datetime:
        """
        Gets the time of this EmailMessageReply.
        The time when the message was received or sent. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The time of this EmailMessageReply.
        :rtype: datetime
        """
        return self._time

    @time.setter
    def time(self, time: datetime) -> None:
        """
        Sets the time of this EmailMessageReply.
        The time when the message was received or sent. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param time: The time of this EmailMessageReply.
        :type: datetime
        """
        

        self._time = time

    @property
    def history_included(self) -> bool:
        """
        Gets the history_included of this EmailMessageReply.
        Indicates whether the history of previous emails of the conversation is included within the email bodies of this message.

        :return: The history_included of this EmailMessageReply.
        :rtype: bool
        """
        return self._history_included

    @history_included.setter
    def history_included(self, history_included: bool) -> None:
        """
        Sets the history_included of this EmailMessageReply.
        Indicates whether the history of previous emails of the conversation is included within the email bodies of this message.

        :param history_included: The history_included of this EmailMessageReply.
        :type: bool
        """
        

        self._history_included = history_included

    @property
    def email_size_bytes(self) -> int:
        """
        Gets the email_size_bytes of this EmailMessageReply.
        Indicates an estimation of the size of the current email as a whole, in its final, ready to be sent form.

        :return: The email_size_bytes of this EmailMessageReply.
        :rtype: int
        """
        return self._email_size_bytes

    @email_size_bytes.setter
    def email_size_bytes(self, email_size_bytes: int) -> None:
        """
        Sets the email_size_bytes of this EmailMessageReply.
        Indicates an estimation of the size of the current email as a whole, in its final, ready to be sent form.

        :param email_size_bytes: The email_size_bytes of this EmailMessageReply.
        :type: int
        """
        

        self._email_size_bytes = email_size_bytes

    @property
    def max_email_size_bytes(self) -> int:
        """
        Gets the max_email_size_bytes of this EmailMessageReply.
        Indicates the maximum allowed size for an email to be send via SMTP server, based on the email domain configuration

        :return: The max_email_size_bytes of this EmailMessageReply.
        :rtype: int
        """
        return self._max_email_size_bytes

    @max_email_size_bytes.setter
    def max_email_size_bytes(self, max_email_size_bytes: int) -> None:
        """
        Sets the max_email_size_bytes of this EmailMessageReply.
        Indicates the maximum allowed size for an email to be send via SMTP server, based on the email domain configuration

        :param max_email_size_bytes: The max_email_size_bytes of this EmailMessageReply.
        :type: int
        """
        

        self._max_email_size_bytes = max_email_size_bytes

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

