# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DnsRecordEntry

class EmailOutboundDomainResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        EmailOutboundDomainResult - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'dns_cname_bounce_record': 'DnsRecordEntry',
            'dns_txt_sending_record': 'DnsRecordEntry',
            'domain_name': 'str',
            'sender_status': 'str',
            'sender_type': 'str'
        }

        self.attribute_map = {
            'dns_cname_bounce_record': 'dnsCnameBounceRecord',
            'dns_txt_sending_record': 'dnsTxtSendingRecord',
            'domain_name': 'domainName',
            'sender_status': 'senderStatus',
            'sender_type': 'senderType'
        }

        self._dns_cname_bounce_record = None
        self._dns_txt_sending_record = None
        self._domain_name = None
        self._sender_status = None
        self._sender_type = None

    @property
    def dns_cname_bounce_record(self) -> 'DnsRecordEntry':
        """
        Gets the dns_cname_bounce_record of this EmailOutboundDomainResult.


        :return: The dns_cname_bounce_record of this EmailOutboundDomainResult.
        :rtype: DnsRecordEntry
        """
        return self._dns_cname_bounce_record

    @dns_cname_bounce_record.setter
    def dns_cname_bounce_record(self, dns_cname_bounce_record: 'DnsRecordEntry') -> None:
        """
        Sets the dns_cname_bounce_record of this EmailOutboundDomainResult.


        :param dns_cname_bounce_record: The dns_cname_bounce_record of this EmailOutboundDomainResult.
        :type: DnsRecordEntry
        """
        

        self._dns_cname_bounce_record = dns_cname_bounce_record

    @property
    def dns_txt_sending_record(self) -> 'DnsRecordEntry':
        """
        Gets the dns_txt_sending_record of this EmailOutboundDomainResult.


        :return: The dns_txt_sending_record of this EmailOutboundDomainResult.
        :rtype: DnsRecordEntry
        """
        return self._dns_txt_sending_record

    @dns_txt_sending_record.setter
    def dns_txt_sending_record(self, dns_txt_sending_record: 'DnsRecordEntry') -> None:
        """
        Sets the dns_txt_sending_record of this EmailOutboundDomainResult.


        :param dns_txt_sending_record: The dns_txt_sending_record of this EmailOutboundDomainResult.
        :type: DnsRecordEntry
        """
        

        self._dns_txt_sending_record = dns_txt_sending_record

    @property
    def domain_name(self) -> str:
        """
        Gets the domain_name of this EmailOutboundDomainResult.


        :return: The domain_name of this EmailOutboundDomainResult.
        :rtype: str
        """
        return self._domain_name

    @domain_name.setter
    def domain_name(self, domain_name: str) -> None:
        """
        Sets the domain_name of this EmailOutboundDomainResult.


        :param domain_name: The domain_name of this EmailOutboundDomainResult.
        :type: str
        """
        

        self._domain_name = domain_name

    @property
    def sender_status(self) -> str:
        """
        Gets the sender_status of this EmailOutboundDomainResult.


        :return: The sender_status of this EmailOutboundDomainResult.
        :rtype: str
        """
        return self._sender_status

    @sender_status.setter
    def sender_status(self, sender_status: str) -> None:
        """
        Sets the sender_status of this EmailOutboundDomainResult.


        :param sender_status: The sender_status of this EmailOutboundDomainResult.
        :type: str
        """
        if isinstance(sender_status, int):
            sender_status = str(sender_status)
        allowed_values = ["RequestReceived", "ProvisionRequestSentVendor", "Provisioned", "Error", "Deprovisioned"]
        if sender_status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for sender_status -> " + sender_status)
            self._sender_status = "outdated_sdk_version"
        else:
            self._sender_status = sender_status

    @property
    def sender_type(self) -> str:
        """
        Gets the sender_type of this EmailOutboundDomainResult.


        :return: The sender_type of this EmailOutboundDomainResult.
        :rtype: str
        """
        return self._sender_type

    @sender_type.setter
    def sender_type(self, sender_type: str) -> None:
        """
        Sets the sender_type of this EmailOutboundDomainResult.


        :param sender_type: The sender_type of this EmailOutboundDomainResult.
        :type: str
        """
        if isinstance(sender_type, int):
            sender_type = str(sender_type)
        allowed_values = ["Unknown", "EmailDomain", "MockEmailDomain", "EmailSmtpDomain"]
        if sender_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for sender_type -> " + sender_type)
            self._sender_type = "outdated_sdk_version"
        else:
            self._sender_type = sender_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

