# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import LocalEncryptionConfiguration
    from . import User

class EncryptionKey(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        EncryptionKey - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'create_date': 'datetime',
            'keydata_summary': 'str',
            'user': 'User',
            'local_encryption_configuration': 'LocalEncryptionConfiguration',
            'key_configuration_type': 'str',
            'kms_key_arn': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'create_date': 'createDate',
            'keydata_summary': 'keydataSummary',
            'user': 'user',
            'local_encryption_configuration': 'localEncryptionConfiguration',
            'key_configuration_type': 'keyConfigurationType',
            'kms_key_arn': 'kmsKeyArn',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._create_date = None
        self._keydata_summary = None
        self._user = None
        self._local_encryption_configuration = None
        self._key_configuration_type = None
        self._kms_key_arn = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this EncryptionKey.
        The globally unique identifier for the object.

        :return: The id of this EncryptionKey.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this EncryptionKey.
        The globally unique identifier for the object.

        :param id: The id of this EncryptionKey.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this EncryptionKey.


        :return: The name of this EncryptionKey.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this EncryptionKey.


        :param name: The name of this EncryptionKey.
        :type: str
        """
        

        self._name = name

    @property
    def create_date(self) -> datetime:
        """
        Gets the create_date of this EncryptionKey.
        create date of the key pair. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The create_date of this EncryptionKey.
        :rtype: datetime
        """
        return self._create_date

    @create_date.setter
    def create_date(self, create_date: datetime) -> None:
        """
        Sets the create_date of this EncryptionKey.
        create date of the key pair. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param create_date: The create_date of this EncryptionKey.
        :type: datetime
        """
        

        self._create_date = create_date

    @property
    def keydata_summary(self) -> str:
        """
        Gets the keydata_summary of this EncryptionKey.
        key data summary (base 64 encoded public key)

        :return: The keydata_summary of this EncryptionKey.
        :rtype: str
        """
        return self._keydata_summary

    @keydata_summary.setter
    def keydata_summary(self, keydata_summary: str) -> None:
        """
        Sets the keydata_summary of this EncryptionKey.
        key data summary (base 64 encoded public key)

        :param keydata_summary: The keydata_summary of this EncryptionKey.
        :type: str
        """
        

        self._keydata_summary = keydata_summary

    @property
    def user(self) -> 'User':
        """
        Gets the user of this EncryptionKey.
        user that requested generation of public key

        :return: The user of this EncryptionKey.
        :rtype: User
        """
        return self._user

    @user.setter
    def user(self, user: 'User') -> None:
        """
        Sets the user of this EncryptionKey.
        user that requested generation of public key

        :param user: The user of this EncryptionKey.
        :type: User
        """
        

        self._user = user

    @property
    def local_encryption_configuration(self) -> 'LocalEncryptionConfiguration':
        """
        Gets the local_encryption_configuration of this EncryptionKey.
        Local configuration

        :return: The local_encryption_configuration of this EncryptionKey.
        :rtype: LocalEncryptionConfiguration
        """
        return self._local_encryption_configuration

    @local_encryption_configuration.setter
    def local_encryption_configuration(self, local_encryption_configuration: 'LocalEncryptionConfiguration') -> None:
        """
        Sets the local_encryption_configuration of this EncryptionKey.
        Local configuration

        :param local_encryption_configuration: The local_encryption_configuration of this EncryptionKey.
        :type: LocalEncryptionConfiguration
        """
        

        self._local_encryption_configuration = local_encryption_configuration

    @property
    def key_configuration_type(self) -> str:
        """
        Gets the key_configuration_type of this EncryptionKey.
        Key type used in this configuration

        :return: The key_configuration_type of this EncryptionKey.
        :rtype: str
        """
        return self._key_configuration_type

    @key_configuration_type.setter
    def key_configuration_type(self, key_configuration_type: str) -> None:
        """
        Sets the key_configuration_type of this EncryptionKey.
        Key type used in this configuration

        :param key_configuration_type: The key_configuration_type of this EncryptionKey.
        :type: str
        """
        if isinstance(key_configuration_type, int):
            key_configuration_type = str(key_configuration_type)
        allowed_values = ["KmsSymmetric", "LocalKeyManager", "Native", "None"]
        if key_configuration_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for key_configuration_type -> " + key_configuration_type)
            self._key_configuration_type = "outdated_sdk_version"
        else:
            self._key_configuration_type = key_configuration_type

    @property
    def kms_key_arn(self) -> str:
        """
        Gets the kms_key_arn of this EncryptionKey.
        ARN of internal key to be wrapped by AWS KMS Symmetric key

        :return: The kms_key_arn of this EncryptionKey.
        :rtype: str
        """
        return self._kms_key_arn

    @kms_key_arn.setter
    def kms_key_arn(self, kms_key_arn: str) -> None:
        """
        Sets the kms_key_arn of this EncryptionKey.
        ARN of internal key to be wrapped by AWS KMS Symmetric key

        :param kms_key_arn: The kms_key_arn of this EncryptionKey.
        :type: str
        """
        

        self._kms_key_arn = kms_key_arn

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this EncryptionKey.
        The URI for this object

        :return: The self_uri of this EncryptionKey.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this EncryptionKey.
        The URI for this object

        :param self_uri: The self_uri of this EncryptionKey.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

