# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class EntityTypeCriteria(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        EntityTypeCriteria - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'key': 'str',
            'values': 'list[str]',
            'should_ignore_case': 'bool',
            'operator': 'str',
            'entity_type': 'str'
        }

        self.attribute_map = {
            'key': 'key',
            'values': 'values',
            'should_ignore_case': 'shouldIgnoreCase',
            'operator': 'operator',
            'entity_type': 'entityType'
        }

        self._key = None
        self._values = None
        self._should_ignore_case = None
        self._operator = None
        self._entity_type = None

    @property
    def key(self) -> str:
        """
        Gets the key of this EntityTypeCriteria.
        The criteria key.

        :return: The key of this EntityTypeCriteria.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key: str) -> None:
        """
        Sets the key of this EntityTypeCriteria.
        The criteria key.

        :param key: The key of this EntityTypeCriteria.
        :type: str
        """
        

        self._key = key

    @property
    def values(self) -> List[str]:
        """
        Gets the values of this EntityTypeCriteria.
        The criteria values.

        :return: The values of this EntityTypeCriteria.
        :rtype: list[str]
        """
        return self._values

    @values.setter
    def values(self, values: List[str]) -> None:
        """
        Sets the values of this EntityTypeCriteria.
        The criteria values.

        :param values: The values of this EntityTypeCriteria.
        :type: list[str]
        """
        

        self._values = values

    @property
    def should_ignore_case(self) -> bool:
        """
        Gets the should_ignore_case of this EntityTypeCriteria.
        Should criteria be case insensitive.

        :return: The should_ignore_case of this EntityTypeCriteria.
        :rtype: bool
        """
        return self._should_ignore_case

    @should_ignore_case.setter
    def should_ignore_case(self, should_ignore_case: bool) -> None:
        """
        Sets the should_ignore_case of this EntityTypeCriteria.
        Should criteria be case insensitive.

        :param should_ignore_case: The should_ignore_case of this EntityTypeCriteria.
        :type: bool
        """
        

        self._should_ignore_case = should_ignore_case

    @property
    def operator(self) -> str:
        """
        Gets the operator of this EntityTypeCriteria.
        The comparison operator.

        :return: The operator of this EntityTypeCriteria.
        :rtype: str
        """
        return self._operator

    @operator.setter
    def operator(self, operator: str) -> None:
        """
        Sets the operator of this EntityTypeCriteria.
        The comparison operator.

        :param operator: The operator of this EntityTypeCriteria.
        :type: str
        """
        if isinstance(operator, int):
            operator = str(operator)
        allowed_values = ["containsAll", "containsAny", "notContainsAll", "notContainsAny", "equal", "notEqual", "greaterThan", "greaterThanOrEqual", "lessThan", "lessThanOrEqual", "startsWith", "endsWith"]
        if operator.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for operator -> " + operator)
            self._operator = "outdated_sdk_version"
        else:
            self._operator = operator

    @property
    def entity_type(self) -> str:
        """
        Gets the entity_type of this EntityTypeCriteria.
        The entity to match the pattern against.

        :return: The entity_type of this EntityTypeCriteria.
        :rtype: str
        """
        return self._entity_type

    @entity_type.setter
    def entity_type(self, entity_type: str) -> None:
        """
        Sets the entity_type of this EntityTypeCriteria.
        The entity to match the pattern against.

        :param entity_type: The entity_type of this EntityTypeCriteria.
        :type: str
        """
        if isinstance(entity_type, int):
            entity_type = str(entity_type)
        allowed_values = ["visit"]
        if entity_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for entity_type -> " + entity_type)
            self._entity_type = "outdated_sdk_version"
        else:
            self._entity_type = entity_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

