# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class EstimateAvailableFullDayTimeOffResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        EstimateAvailableFullDayTimeOffResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'date': 'date',
            'duration_minutes': 'int',
            'payable_minutes': 'int',
            'flexible': 'bool'
        }

        self.attribute_map = {
            'date': 'date',
            'duration_minutes': 'durationMinutes',
            'payable_minutes': 'payableMinutes',
            'flexible': 'flexible'
        }

        self._date = None
        self._duration_minutes = None
        self._payable_minutes = None
        self._flexible = None

    @property
    def date(self) -> date:
        """
        Gets the date of this EstimateAvailableFullDayTimeOffResponse.
        Date in yyyy-MM-dd format for full day request. Should be interpreted in the business unit's configured time zone. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date of this EstimateAvailableFullDayTimeOffResponse.
        :rtype: date
        """
        return self._date

    @date.setter
    def date(self, date: date) -> None:
        """
        Sets the date of this EstimateAvailableFullDayTimeOffResponse.
        Date in yyyy-MM-dd format for full day request. Should be interpreted in the business unit's configured time zone. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date: The date of this EstimateAvailableFullDayTimeOffResponse.
        :type: date
        """
        

        self._date = date

    @property
    def duration_minutes(self) -> int:
        """
        Gets the duration_minutes of this EstimateAvailableFullDayTimeOffResponse.
        An estimation of time off request length in minutes

        :return: The duration_minutes of this EstimateAvailableFullDayTimeOffResponse.
        :rtype: int
        """
        return self._duration_minutes

    @duration_minutes.setter
    def duration_minutes(self, duration_minutes: int) -> None:
        """
        Sets the duration_minutes of this EstimateAvailableFullDayTimeOffResponse.
        An estimation of time off request length in minutes

        :param duration_minutes: The duration_minutes of this EstimateAvailableFullDayTimeOffResponse.
        :type: int
        """
        

        self._duration_minutes = duration_minutes

    @property
    def payable_minutes(self) -> int:
        """
        Gets the payable_minutes of this EstimateAvailableFullDayTimeOffResponse.
        An estimation of payable part of time off request in minutes

        :return: The payable_minutes of this EstimateAvailableFullDayTimeOffResponse.
        :rtype: int
        """
        return self._payable_minutes

    @payable_minutes.setter
    def payable_minutes(self, payable_minutes: int) -> None:
        """
        Sets the payable_minutes of this EstimateAvailableFullDayTimeOffResponse.
        An estimation of payable part of time off request in minutes

        :param payable_minutes: The payable_minutes of this EstimateAvailableFullDayTimeOffResponse.
        :type: int
        """
        

        self._payable_minutes = payable_minutes

    @property
    def flexible(self) -> bool:
        """
        Gets the flexible of this EstimateAvailableFullDayTimeOffResponse.
        Whether there is flexibility for a user to choose different hours than the system estimated

        :return: The flexible of this EstimateAvailableFullDayTimeOffResponse.
        :rtype: bool
        """
        return self._flexible

    @flexible.setter
    def flexible(self, flexible: bool) -> None:
        """
        Sets the flexible of this EstimateAvailableFullDayTimeOffResponse.
        Whether there is flexibility for a user to choose different hours than the system estimated

        :param flexible: The flexible of this EstimateAvailableFullDayTimeOffResponse.
        :type: bool
        """
        

        self._flexible = flexible

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

