# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import EstimateAvailableFullDayTimeOffRequest
    from . import EstimateAvailablePartialDayTimeOffRequest

class EstimateAvailableTimeOffRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        EstimateAvailableTimeOffRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'full_day_dates': 'list[EstimateAvailableFullDayTimeOffRequest]',
            'partial_day_dates': 'list[EstimateAvailablePartialDayTimeOffRequest]',
            'activity_code_id': 'str',
            'paid': 'bool'
        }

        self.attribute_map = {
            'full_day_dates': 'fullDayDates',
            'partial_day_dates': 'partialDayDates',
            'activity_code_id': 'activityCodeId',
            'paid': 'paid'
        }

        self._full_day_dates = None
        self._partial_day_dates = None
        self._activity_code_id = None
        self._paid = None

    @property
    def full_day_dates(self) -> List['EstimateAvailableFullDayTimeOffRequest']:
        """
        Gets the full_day_dates of this EstimateAvailableTimeOffRequest.
        Full day dates. partialDayDates must be empty if this field is populated

        :return: The full_day_dates of this EstimateAvailableTimeOffRequest.
        :rtype: list[EstimateAvailableFullDayTimeOffRequest]
        """
        return self._full_day_dates

    @full_day_dates.setter
    def full_day_dates(self, full_day_dates: List['EstimateAvailableFullDayTimeOffRequest']) -> None:
        """
        Sets the full_day_dates of this EstimateAvailableTimeOffRequest.
        Full day dates. partialDayDates must be empty if this field is populated

        :param full_day_dates: The full_day_dates of this EstimateAvailableTimeOffRequest.
        :type: list[EstimateAvailableFullDayTimeOffRequest]
        """
        

        self._full_day_dates = full_day_dates

    @property
    def partial_day_dates(self) -> List['EstimateAvailablePartialDayTimeOffRequest']:
        """
        Gets the partial_day_dates of this EstimateAvailableTimeOffRequest.
        Partial day dates. fullDayDates must be empty if this field is populated

        :return: The partial_day_dates of this EstimateAvailableTimeOffRequest.
        :rtype: list[EstimateAvailablePartialDayTimeOffRequest]
        """
        return self._partial_day_dates

    @partial_day_dates.setter
    def partial_day_dates(self, partial_day_dates: List['EstimateAvailablePartialDayTimeOffRequest']) -> None:
        """
        Sets the partial_day_dates of this EstimateAvailableTimeOffRequest.
        Partial day dates. fullDayDates must be empty if this field is populated

        :param partial_day_dates: The partial_day_dates of this EstimateAvailableTimeOffRequest.
        :type: list[EstimateAvailablePartialDayTimeOffRequest]
        """
        

        self._partial_day_dates = partial_day_dates

    @property
    def activity_code_id(self) -> str:
        """
        Gets the activity_code_id of this EstimateAvailableTimeOffRequest.
        The ID of the activity code associated with the time off request. Activity code must be of the TimeOff category

        :return: The activity_code_id of this EstimateAvailableTimeOffRequest.
        :rtype: str
        """
        return self._activity_code_id

    @activity_code_id.setter
    def activity_code_id(self, activity_code_id: str) -> None:
        """
        Sets the activity_code_id of this EstimateAvailableTimeOffRequest.
        The ID of the activity code associated with the time off request. Activity code must be of the TimeOff category

        :param activity_code_id: The activity_code_id of this EstimateAvailableTimeOffRequest.
        :type: str
        """
        

        self._activity_code_id = activity_code_id

    @property
    def paid(self) -> bool:
        """
        Gets the paid of this EstimateAvailableTimeOffRequest.
        Whether this estimate is for a paid time off request

        :return: The paid of this EstimateAvailableTimeOffRequest.
        :rtype: bool
        """
        return self._paid

    @paid.setter
    def paid(self, paid: bool) -> None:
        """
        Sets the paid of this EstimateAvailableTimeOffRequest.
        Whether this estimate is for a paid time off request

        :param paid: The paid of this EstimateAvailableTimeOffRequest.
        :type: bool
        """
        

        self._paid = paid

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

