# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import EvaluationQuestionGroupScore
    from . import TranscriptTopic

class EvaluationScoringSet(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        EvaluationScoringSet - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'total_score': 'float',
            'total_critical_score': 'float',
            'total_non_critical_score': 'float',
            'question_group_scores': 'list[EvaluationQuestionGroupScore]',
            'any_failed_kill_questions': 'bool',
            'comments': 'str',
            'private_comments': 'str',
            'agent_comments': 'str',
            'transcript_topics': 'list[TranscriptTopic]'
        }

        self.attribute_map = {
            'total_score': 'totalScore',
            'total_critical_score': 'totalCriticalScore',
            'total_non_critical_score': 'totalNonCriticalScore',
            'question_group_scores': 'questionGroupScores',
            'any_failed_kill_questions': 'anyFailedKillQuestions',
            'comments': 'comments',
            'private_comments': 'privateComments',
            'agent_comments': 'agentComments',
            'transcript_topics': 'transcriptTopics'
        }

        self._total_score = None
        self._total_critical_score = None
        self._total_non_critical_score = None
        self._question_group_scores = None
        self._any_failed_kill_questions = None
        self._comments = None
        self._private_comments = None
        self._agent_comments = None
        self._transcript_topics = None

    @property
    def total_score(self) -> float:
        """
        Gets the total_score of this EvaluationScoringSet.
        Score of all questions

        :return: The total_score of this EvaluationScoringSet.
        :rtype: float
        """
        return self._total_score

    @total_score.setter
    def total_score(self, total_score: float) -> None:
        """
        Sets the total_score of this EvaluationScoringSet.
        Score of all questions

        :param total_score: The total_score of this EvaluationScoringSet.
        :type: float
        """
        

        self._total_score = total_score

    @property
    def total_critical_score(self) -> float:
        """
        Gets the total_critical_score of this EvaluationScoringSet.
        Score of only the critical questions

        :return: The total_critical_score of this EvaluationScoringSet.
        :rtype: float
        """
        return self._total_critical_score

    @total_critical_score.setter
    def total_critical_score(self, total_critical_score: float) -> None:
        """
        Sets the total_critical_score of this EvaluationScoringSet.
        Score of only the critical questions

        :param total_critical_score: The total_critical_score of this EvaluationScoringSet.
        :type: float
        """
        

        self._total_critical_score = total_critical_score

    @property
    def total_non_critical_score(self) -> float:
        """
        Gets the total_non_critical_score of this EvaluationScoringSet.
        Score of only the non-critical questions

        :return: The total_non_critical_score of this EvaluationScoringSet.
        :rtype: float
        """
        return self._total_non_critical_score

    @total_non_critical_score.setter
    def total_non_critical_score(self, total_non_critical_score: float) -> None:
        """
        Sets the total_non_critical_score of this EvaluationScoringSet.
        Score of only the non-critical questions

        :param total_non_critical_score: The total_non_critical_score of this EvaluationScoringSet.
        :type: float
        """
        

        self._total_non_critical_score = total_non_critical_score

    @property
    def question_group_scores(self) -> List['EvaluationQuestionGroupScore']:
        """
        Gets the question_group_scores of this EvaluationScoringSet.


        :return: The question_group_scores of this EvaluationScoringSet.
        :rtype: list[EvaluationQuestionGroupScore]
        """
        return self._question_group_scores

    @question_group_scores.setter
    def question_group_scores(self, question_group_scores: List['EvaluationQuestionGroupScore']) -> None:
        """
        Sets the question_group_scores of this EvaluationScoringSet.


        :param question_group_scores: The question_group_scores of this EvaluationScoringSet.
        :type: list[EvaluationQuestionGroupScore]
        """
        

        self._question_group_scores = question_group_scores

    @property
    def any_failed_kill_questions(self) -> bool:
        """
        Gets the any_failed_kill_questions of this EvaluationScoringSet.
        Indicates that at least one fatal question was answered without having the highest score available for the question

        :return: The any_failed_kill_questions of this EvaluationScoringSet.
        :rtype: bool
        """
        return self._any_failed_kill_questions

    @any_failed_kill_questions.setter
    def any_failed_kill_questions(self, any_failed_kill_questions: bool) -> None:
        """
        Sets the any_failed_kill_questions of this EvaluationScoringSet.
        Indicates that at least one fatal question was answered without having the highest score available for the question

        :param any_failed_kill_questions: The any_failed_kill_questions of this EvaluationScoringSet.
        :type: bool
        """
        

        self._any_failed_kill_questions = any_failed_kill_questions

    @property
    def comments(self) -> str:
        """
        Gets the comments of this EvaluationScoringSet.
        Overall comments from the evaluator

        :return: The comments of this EvaluationScoringSet.
        :rtype: str
        """
        return self._comments

    @comments.setter
    def comments(self, comments: str) -> None:
        """
        Sets the comments of this EvaluationScoringSet.
        Overall comments from the evaluator

        :param comments: The comments of this EvaluationScoringSet.
        :type: str
        """
        

        self._comments = comments

    @property
    def private_comments(self) -> str:
        """
        Gets the private_comments of this EvaluationScoringSet.
        Overall private comments from the evaluator

        :return: The private_comments of this EvaluationScoringSet.
        :rtype: str
        """
        return self._private_comments

    @private_comments.setter
    def private_comments(self, private_comments: str) -> None:
        """
        Sets the private_comments of this EvaluationScoringSet.
        Overall private comments from the evaluator

        :param private_comments: The private_comments of this EvaluationScoringSet.
        :type: str
        """
        

        self._private_comments = private_comments

    @property
    def agent_comments(self) -> str:
        """
        Gets the agent_comments of this EvaluationScoringSet.
        Comments from the agent while reviewing evaluation results

        :return: The agent_comments of this EvaluationScoringSet.
        :rtype: str
        """
        return self._agent_comments

    @agent_comments.setter
    def agent_comments(self, agent_comments: str) -> None:
        """
        Sets the agent_comments of this EvaluationScoringSet.
        Comments from the agent while reviewing evaluation results

        :param agent_comments: The agent_comments of this EvaluationScoringSet.
        :type: str
        """
        

        self._agent_comments = agent_comments

    @property
    def transcript_topics(self) -> List['TranscriptTopic']:
        """
        Gets the transcript_topics of this EvaluationScoringSet.
        List of topics found within the conversation's transcripts

        :return: The transcript_topics of this EvaluationScoringSet.
        :rtype: list[TranscriptTopic]
        """
        return self._transcript_topics

    @transcript_topics.setter
    def transcript_topics(self, transcript_topics: List['TranscriptTopic']) -> None:
        """
        Sets the transcript_topics of this EvaluationScoringSet.
        List of topics found within the conversation's transcripts

        :param transcript_topics: The transcript_topics of this EvaluationScoringSet.
        :type: list[TranscriptTopic]
        """
        

        self._transcript_topics = transcript_topics

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

