# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class EventError(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        EventError - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'event_id': 'str',
            'message': 'str',
            'retryable': 'bool'
        }

        self.attribute_map = {
            'event_id': 'eventId',
            'message': 'message',
            'retryable': 'retryable'
        }

        self._event_id = None
        self._message = None
        self._retryable = None

    @property
    def event_id(self) -> str:
        """
        Gets the event_id of this EventError.
        The eventId (V4 UUID) for the event that encountered an error.

        :return: The event_id of this EventError.
        :rtype: str
        """
        return self._event_id

    @event_id.setter
    def event_id(self, event_id: str) -> None:
        """
        Sets the event_id of this EventError.
        The eventId (V4 UUID) for the event that encountered an error.

        :param event_id: The event_id of this EventError.
        :type: str
        """
        

        self._event_id = event_id

    @property
    def message(self) -> str:
        """
        Gets the message of this EventError.
        A message describing the error.

        :return: The message of this EventError.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message: str) -> None:
        """
        Sets the message of this EventError.
        A message describing the error.

        :param message: The message of this EventError.
        :type: str
        """
        

        self._message = message

    @property
    def retryable(self) -> bool:
        """
        Gets the retryable of this EventError.
        The event for this eventId can be resubmitted if this value is true.

        :return: The retryable of this EventError.
        :rtype: bool
        """
        return self._retryable

    @retryable.setter
    def retryable(self, retryable: bool) -> None:
        """
        Sets the retryable of this EventError.
        The event for this eventId can be resubmitted if this value is true.

        :param retryable: The retryable of this EventError.
        :type: bool
        """
        

        self._retryable = retryable

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

