# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class EventQueryRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        EventQueryRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'interval': 'str',
            'event_definition_ids': 'list[str]',
            'search_term': 'str',
            'sort_order': 'str'
        }

        self.attribute_map = {
            'interval': 'interval',
            'event_definition_ids': 'eventDefinitionIds',
            'search_term': 'searchTerm',
            'sort_order': 'sortOrder'
        }

        self._interval = None
        self._event_definition_ids = None
        self._search_term = None
        self._sort_order = None

    @property
    def interval(self) -> str:
        """
        Gets the interval of this EventQueryRequest.
        Date and time range to query. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss

        :return: The interval of this EventQueryRequest.
        :rtype: str
        """
        return self._interval

    @interval.setter
    def interval(self, interval: str) -> None:
        """
        Sets the interval of this EventQueryRequest.
        Date and time range to query. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss

        :param interval: The interval of this EventQueryRequest.
        :type: str
        """
        

        self._interval = interval

    @property
    def event_definition_ids(self) -> List[str]:
        """
        Gets the event_definition_ids of this EventQueryRequest.
        Filter events by a list of event definition ids

        :return: The event_definition_ids of this EventQueryRequest.
        :rtype: list[str]
        """
        return self._event_definition_ids

    @event_definition_ids.setter
    def event_definition_ids(self, event_definition_ids: List[str]) -> None:
        """
        Sets the event_definition_ids of this EventQueryRequest.
        Filter events by a list of event definition ids

        :param event_definition_ids: The event_definition_ids of this EventQueryRequest.
        :type: list[str]
        """
        

        self._event_definition_ids = event_definition_ids

    @property
    def search_term(self) -> str:
        """
        Gets the search_term of this EventQueryRequest.
        Only return events that contain the search term

        :return: The search_term of this EventQueryRequest.
        :rtype: str
        """
        return self._search_term

    @search_term.setter
    def search_term(self, search_term: str) -> None:
        """
        Sets the search_term of this EventQueryRequest.
        Only return events that contain the search term

        :param search_term: The search_term of this EventQueryRequest.
        :type: str
        """
        

        self._search_term = search_term

    @property
    def sort_order(self) -> str:
        """
        Gets the sort_order of this EventQueryRequest.
        Order of results. Default order is DESC.

        :return: The sort_order of this EventQueryRequest.
        :rtype: str
        """
        return self._sort_order

    @sort_order.setter
    def sort_order(self, sort_order: str) -> None:
        """
        Sets the sort_order of this EventQueryRequest.
        Order of results. Default order is DESC.

        :param sort_order: The sort_order of this EventQueryRequest.
        :type: str
        """
        if isinstance(sort_order, int):
            sort_order = str(sort_order)
        allowed_values = ["ASC", "DESC"]
        if sort_order.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for sort_order -> " + sort_order)
            self._sort_order = "outdated_sdk_version"
        else:
            self._sort_order = sort_order

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

