# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ExternalContactsContactChangedTopicAppleOpaqueId
    from . import ExternalContactsContactChangedTopicContactAddress
    from . import ExternalContactsContactChangedTopicDataSchema
    from . import ExternalContactsContactChangedTopicDivision
    from . import ExternalContactsContactChangedTopicExternalId
    from . import ExternalContactsContactChangedTopicExternalOrganization
    from . import ExternalContactsContactChangedTopicFacebookId
    from . import ExternalContactsContactChangedTopicInstagramId
    from . import ExternalContactsContactChangedTopicLineId
    from . import ExternalContactsContactChangedTopicMergeOperation
    from . import ExternalContactsContactChangedTopicPhoneNumber
    from . import ExternalContactsContactChangedTopicTwitterId
    from . import ExternalContactsContactChangedTopicWhatsAppId

class ExternalContactsContactChangedTopicContact(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ExternalContactsContactChangedTopicContact - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'division': 'ExternalContactsContactChangedTopicDivision',
            'external_organization': 'ExternalContactsContactChangedTopicExternalOrganization',
            'type': 'str',
            'first_name': 'str',
            'middle_name': 'str',
            'last_name': 'str',
            'salutation': 'str',
            'title': 'str',
            'work_phone': 'ExternalContactsContactChangedTopicPhoneNumber',
            'cell_phone': 'ExternalContactsContactChangedTopicPhoneNumber',
            'home_phone': 'ExternalContactsContactChangedTopicPhoneNumber',
            'other_phone': 'ExternalContactsContactChangedTopicPhoneNumber',
            'work_email': 'str',
            'personal_email': 'str',
            'other_email': 'str',
            'address': 'ExternalContactsContactChangedTopicContactAddress',
            'survey_opt_out': 'bool',
            'external_system_url': 'str',
            'twitter_id': 'ExternalContactsContactChangedTopicTwitterId',
            'line_id': 'ExternalContactsContactChangedTopicLineId',
            'whats_app_id': 'ExternalContactsContactChangedTopicWhatsAppId',
            'facebook_id': 'ExternalContactsContactChangedTopicFacebookId',
            'instagram_id': 'ExternalContactsContactChangedTopicInstagramId',
            'external_ids': 'list[ExternalContactsContactChangedTopicExternalId]',
            'apple_opaque_ids': 'list[ExternalContactsContactChangedTopicAppleOpaqueId]',
            'canonical_contact_id': 'str',
            'schema': 'ExternalContactsContactChangedTopicDataSchema',
            'custom_fields': 'dict(str, object)',
            'merge_set': 'list[str]',
            'merged_from': 'list[str]',
            'merged_to': 'str',
            'merge_operation': 'ExternalContactsContactChangedTopicMergeOperation',
            'create_date': 'datetime',
            'modify_date': 'datetime'
        }

        self.attribute_map = {
            'id': 'id',
            'division': 'division',
            'external_organization': 'externalOrganization',
            'type': 'type',
            'first_name': 'firstName',
            'middle_name': 'middleName',
            'last_name': 'lastName',
            'salutation': 'salutation',
            'title': 'title',
            'work_phone': 'workPhone',
            'cell_phone': 'cellPhone',
            'home_phone': 'homePhone',
            'other_phone': 'otherPhone',
            'work_email': 'workEmail',
            'personal_email': 'personalEmail',
            'other_email': 'otherEmail',
            'address': 'address',
            'survey_opt_out': 'surveyOptOut',
            'external_system_url': 'externalSystemUrl',
            'twitter_id': 'twitterId',
            'line_id': 'lineId',
            'whats_app_id': 'whatsAppId',
            'facebook_id': 'facebookId',
            'instagram_id': 'instagramId',
            'external_ids': 'externalIds',
            'apple_opaque_ids': 'appleOpaqueIds',
            'canonical_contact_id': 'canonicalContactId',
            'schema': 'schema',
            'custom_fields': 'customFields',
            'merge_set': 'mergeSet',
            'merged_from': 'mergedFrom',
            'merged_to': 'mergedTo',
            'merge_operation': 'mergeOperation',
            'create_date': 'createDate',
            'modify_date': 'modifyDate'
        }

        self._id = None
        self._division = None
        self._external_organization = None
        self._type = None
        self._first_name = None
        self._middle_name = None
        self._last_name = None
        self._salutation = None
        self._title = None
        self._work_phone = None
        self._cell_phone = None
        self._home_phone = None
        self._other_phone = None
        self._work_email = None
        self._personal_email = None
        self._other_email = None
        self._address = None
        self._survey_opt_out = None
        self._external_system_url = None
        self._twitter_id = None
        self._line_id = None
        self._whats_app_id = None
        self._facebook_id = None
        self._instagram_id = None
        self._external_ids = None
        self._apple_opaque_ids = None
        self._canonical_contact_id = None
        self._schema = None
        self._custom_fields = None
        self._merge_set = None
        self._merged_from = None
        self._merged_to = None
        self._merge_operation = None
        self._create_date = None
        self._modify_date = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ExternalContactsContactChangedTopicContact.


        :return: The id of this ExternalContactsContactChangedTopicContact.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ExternalContactsContactChangedTopicContact.


        :param id: The id of this ExternalContactsContactChangedTopicContact.
        :type: str
        """
        

        self._id = id

    @property
    def division(self) -> 'ExternalContactsContactChangedTopicDivision':
        """
        Gets the division of this ExternalContactsContactChangedTopicContact.


        :return: The division of this ExternalContactsContactChangedTopicContact.
        :rtype: ExternalContactsContactChangedTopicDivision
        """
        return self._division

    @division.setter
    def division(self, division: 'ExternalContactsContactChangedTopicDivision') -> None:
        """
        Sets the division of this ExternalContactsContactChangedTopicContact.


        :param division: The division of this ExternalContactsContactChangedTopicContact.
        :type: ExternalContactsContactChangedTopicDivision
        """
        

        self._division = division

    @property
    def external_organization(self) -> 'ExternalContactsContactChangedTopicExternalOrganization':
        """
        Gets the external_organization of this ExternalContactsContactChangedTopicContact.


        :return: The external_organization of this ExternalContactsContactChangedTopicContact.
        :rtype: ExternalContactsContactChangedTopicExternalOrganization
        """
        return self._external_organization

    @external_organization.setter
    def external_organization(self, external_organization: 'ExternalContactsContactChangedTopicExternalOrganization') -> None:
        """
        Sets the external_organization of this ExternalContactsContactChangedTopicContact.


        :param external_organization: The external_organization of this ExternalContactsContactChangedTopicContact.
        :type: ExternalContactsContactChangedTopicExternalOrganization
        """
        

        self._external_organization = external_organization

    @property
    def type(self) -> str:
        """
        Gets the type of this ExternalContactsContactChangedTopicContact.


        :return: The type of this ExternalContactsContactChangedTopicContact.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this ExternalContactsContactChangedTopicContact.


        :param type: The type of this ExternalContactsContactChangedTopicContact.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Ephemeral", "Identified", "Curated"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def first_name(self) -> str:
        """
        Gets the first_name of this ExternalContactsContactChangedTopicContact.


        :return: The first_name of this ExternalContactsContactChangedTopicContact.
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name: str) -> None:
        """
        Sets the first_name of this ExternalContactsContactChangedTopicContact.


        :param first_name: The first_name of this ExternalContactsContactChangedTopicContact.
        :type: str
        """
        

        self._first_name = first_name

    @property
    def middle_name(self) -> str:
        """
        Gets the middle_name of this ExternalContactsContactChangedTopicContact.


        :return: The middle_name of this ExternalContactsContactChangedTopicContact.
        :rtype: str
        """
        return self._middle_name

    @middle_name.setter
    def middle_name(self, middle_name: str) -> None:
        """
        Sets the middle_name of this ExternalContactsContactChangedTopicContact.


        :param middle_name: The middle_name of this ExternalContactsContactChangedTopicContact.
        :type: str
        """
        

        self._middle_name = middle_name

    @property
    def last_name(self) -> str:
        """
        Gets the last_name of this ExternalContactsContactChangedTopicContact.


        :return: The last_name of this ExternalContactsContactChangedTopicContact.
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name: str) -> None:
        """
        Sets the last_name of this ExternalContactsContactChangedTopicContact.


        :param last_name: The last_name of this ExternalContactsContactChangedTopicContact.
        :type: str
        """
        

        self._last_name = last_name

    @property
    def salutation(self) -> str:
        """
        Gets the salutation of this ExternalContactsContactChangedTopicContact.


        :return: The salutation of this ExternalContactsContactChangedTopicContact.
        :rtype: str
        """
        return self._salutation

    @salutation.setter
    def salutation(self, salutation: str) -> None:
        """
        Sets the salutation of this ExternalContactsContactChangedTopicContact.


        :param salutation: The salutation of this ExternalContactsContactChangedTopicContact.
        :type: str
        """
        

        self._salutation = salutation

    @property
    def title(self) -> str:
        """
        Gets the title of this ExternalContactsContactChangedTopicContact.


        :return: The title of this ExternalContactsContactChangedTopicContact.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title: str) -> None:
        """
        Sets the title of this ExternalContactsContactChangedTopicContact.


        :param title: The title of this ExternalContactsContactChangedTopicContact.
        :type: str
        """
        

        self._title = title

    @property
    def work_phone(self) -> 'ExternalContactsContactChangedTopicPhoneNumber':
        """
        Gets the work_phone of this ExternalContactsContactChangedTopicContact.


        :return: The work_phone of this ExternalContactsContactChangedTopicContact.
        :rtype: ExternalContactsContactChangedTopicPhoneNumber
        """
        return self._work_phone

    @work_phone.setter
    def work_phone(self, work_phone: 'ExternalContactsContactChangedTopicPhoneNumber') -> None:
        """
        Sets the work_phone of this ExternalContactsContactChangedTopicContact.


        :param work_phone: The work_phone of this ExternalContactsContactChangedTopicContact.
        :type: ExternalContactsContactChangedTopicPhoneNumber
        """
        

        self._work_phone = work_phone

    @property
    def cell_phone(self) -> 'ExternalContactsContactChangedTopicPhoneNumber':
        """
        Gets the cell_phone of this ExternalContactsContactChangedTopicContact.


        :return: The cell_phone of this ExternalContactsContactChangedTopicContact.
        :rtype: ExternalContactsContactChangedTopicPhoneNumber
        """
        return self._cell_phone

    @cell_phone.setter
    def cell_phone(self, cell_phone: 'ExternalContactsContactChangedTopicPhoneNumber') -> None:
        """
        Sets the cell_phone of this ExternalContactsContactChangedTopicContact.


        :param cell_phone: The cell_phone of this ExternalContactsContactChangedTopicContact.
        :type: ExternalContactsContactChangedTopicPhoneNumber
        """
        

        self._cell_phone = cell_phone

    @property
    def home_phone(self) -> 'ExternalContactsContactChangedTopicPhoneNumber':
        """
        Gets the home_phone of this ExternalContactsContactChangedTopicContact.


        :return: The home_phone of this ExternalContactsContactChangedTopicContact.
        :rtype: ExternalContactsContactChangedTopicPhoneNumber
        """
        return self._home_phone

    @home_phone.setter
    def home_phone(self, home_phone: 'ExternalContactsContactChangedTopicPhoneNumber') -> None:
        """
        Sets the home_phone of this ExternalContactsContactChangedTopicContact.


        :param home_phone: The home_phone of this ExternalContactsContactChangedTopicContact.
        :type: ExternalContactsContactChangedTopicPhoneNumber
        """
        

        self._home_phone = home_phone

    @property
    def other_phone(self) -> 'ExternalContactsContactChangedTopicPhoneNumber':
        """
        Gets the other_phone of this ExternalContactsContactChangedTopicContact.


        :return: The other_phone of this ExternalContactsContactChangedTopicContact.
        :rtype: ExternalContactsContactChangedTopicPhoneNumber
        """
        return self._other_phone

    @other_phone.setter
    def other_phone(self, other_phone: 'ExternalContactsContactChangedTopicPhoneNumber') -> None:
        """
        Sets the other_phone of this ExternalContactsContactChangedTopicContact.


        :param other_phone: The other_phone of this ExternalContactsContactChangedTopicContact.
        :type: ExternalContactsContactChangedTopicPhoneNumber
        """
        

        self._other_phone = other_phone

    @property
    def work_email(self) -> str:
        """
        Gets the work_email of this ExternalContactsContactChangedTopicContact.


        :return: The work_email of this ExternalContactsContactChangedTopicContact.
        :rtype: str
        """
        return self._work_email

    @work_email.setter
    def work_email(self, work_email: str) -> None:
        """
        Sets the work_email of this ExternalContactsContactChangedTopicContact.


        :param work_email: The work_email of this ExternalContactsContactChangedTopicContact.
        :type: str
        """
        

        self._work_email = work_email

    @property
    def personal_email(self) -> str:
        """
        Gets the personal_email of this ExternalContactsContactChangedTopicContact.


        :return: The personal_email of this ExternalContactsContactChangedTopicContact.
        :rtype: str
        """
        return self._personal_email

    @personal_email.setter
    def personal_email(self, personal_email: str) -> None:
        """
        Sets the personal_email of this ExternalContactsContactChangedTopicContact.


        :param personal_email: The personal_email of this ExternalContactsContactChangedTopicContact.
        :type: str
        """
        

        self._personal_email = personal_email

    @property
    def other_email(self) -> str:
        """
        Gets the other_email of this ExternalContactsContactChangedTopicContact.


        :return: The other_email of this ExternalContactsContactChangedTopicContact.
        :rtype: str
        """
        return self._other_email

    @other_email.setter
    def other_email(self, other_email: str) -> None:
        """
        Sets the other_email of this ExternalContactsContactChangedTopicContact.


        :param other_email: The other_email of this ExternalContactsContactChangedTopicContact.
        :type: str
        """
        

        self._other_email = other_email

    @property
    def address(self) -> 'ExternalContactsContactChangedTopicContactAddress':
        """
        Gets the address of this ExternalContactsContactChangedTopicContact.


        :return: The address of this ExternalContactsContactChangedTopicContact.
        :rtype: ExternalContactsContactChangedTopicContactAddress
        """
        return self._address

    @address.setter
    def address(self, address: 'ExternalContactsContactChangedTopicContactAddress') -> None:
        """
        Sets the address of this ExternalContactsContactChangedTopicContact.


        :param address: The address of this ExternalContactsContactChangedTopicContact.
        :type: ExternalContactsContactChangedTopicContactAddress
        """
        

        self._address = address

    @property
    def survey_opt_out(self) -> bool:
        """
        Gets the survey_opt_out of this ExternalContactsContactChangedTopicContact.


        :return: The survey_opt_out of this ExternalContactsContactChangedTopicContact.
        :rtype: bool
        """
        return self._survey_opt_out

    @survey_opt_out.setter
    def survey_opt_out(self, survey_opt_out: bool) -> None:
        """
        Sets the survey_opt_out of this ExternalContactsContactChangedTopicContact.


        :param survey_opt_out: The survey_opt_out of this ExternalContactsContactChangedTopicContact.
        :type: bool
        """
        

        self._survey_opt_out = survey_opt_out

    @property
    def external_system_url(self) -> str:
        """
        Gets the external_system_url of this ExternalContactsContactChangedTopicContact.


        :return: The external_system_url of this ExternalContactsContactChangedTopicContact.
        :rtype: str
        """
        return self._external_system_url

    @external_system_url.setter
    def external_system_url(self, external_system_url: str) -> None:
        """
        Sets the external_system_url of this ExternalContactsContactChangedTopicContact.


        :param external_system_url: The external_system_url of this ExternalContactsContactChangedTopicContact.
        :type: str
        """
        

        self._external_system_url = external_system_url

    @property
    def twitter_id(self) -> 'ExternalContactsContactChangedTopicTwitterId':
        """
        Gets the twitter_id of this ExternalContactsContactChangedTopicContact.


        :return: The twitter_id of this ExternalContactsContactChangedTopicContact.
        :rtype: ExternalContactsContactChangedTopicTwitterId
        """
        return self._twitter_id

    @twitter_id.setter
    def twitter_id(self, twitter_id: 'ExternalContactsContactChangedTopicTwitterId') -> None:
        """
        Sets the twitter_id of this ExternalContactsContactChangedTopicContact.


        :param twitter_id: The twitter_id of this ExternalContactsContactChangedTopicContact.
        :type: ExternalContactsContactChangedTopicTwitterId
        """
        

        self._twitter_id = twitter_id

    @property
    def line_id(self) -> 'ExternalContactsContactChangedTopicLineId':
        """
        Gets the line_id of this ExternalContactsContactChangedTopicContact.


        :return: The line_id of this ExternalContactsContactChangedTopicContact.
        :rtype: ExternalContactsContactChangedTopicLineId
        """
        return self._line_id

    @line_id.setter
    def line_id(self, line_id: 'ExternalContactsContactChangedTopicLineId') -> None:
        """
        Sets the line_id of this ExternalContactsContactChangedTopicContact.


        :param line_id: The line_id of this ExternalContactsContactChangedTopicContact.
        :type: ExternalContactsContactChangedTopicLineId
        """
        

        self._line_id = line_id

    @property
    def whats_app_id(self) -> 'ExternalContactsContactChangedTopicWhatsAppId':
        """
        Gets the whats_app_id of this ExternalContactsContactChangedTopicContact.


        :return: The whats_app_id of this ExternalContactsContactChangedTopicContact.
        :rtype: ExternalContactsContactChangedTopicWhatsAppId
        """
        return self._whats_app_id

    @whats_app_id.setter
    def whats_app_id(self, whats_app_id: 'ExternalContactsContactChangedTopicWhatsAppId') -> None:
        """
        Sets the whats_app_id of this ExternalContactsContactChangedTopicContact.


        :param whats_app_id: The whats_app_id of this ExternalContactsContactChangedTopicContact.
        :type: ExternalContactsContactChangedTopicWhatsAppId
        """
        

        self._whats_app_id = whats_app_id

    @property
    def facebook_id(self) -> 'ExternalContactsContactChangedTopicFacebookId':
        """
        Gets the facebook_id of this ExternalContactsContactChangedTopicContact.


        :return: The facebook_id of this ExternalContactsContactChangedTopicContact.
        :rtype: ExternalContactsContactChangedTopicFacebookId
        """
        return self._facebook_id

    @facebook_id.setter
    def facebook_id(self, facebook_id: 'ExternalContactsContactChangedTopicFacebookId') -> None:
        """
        Sets the facebook_id of this ExternalContactsContactChangedTopicContact.


        :param facebook_id: The facebook_id of this ExternalContactsContactChangedTopicContact.
        :type: ExternalContactsContactChangedTopicFacebookId
        """
        

        self._facebook_id = facebook_id

    @property
    def instagram_id(self) -> 'ExternalContactsContactChangedTopicInstagramId':
        """
        Gets the instagram_id of this ExternalContactsContactChangedTopicContact.


        :return: The instagram_id of this ExternalContactsContactChangedTopicContact.
        :rtype: ExternalContactsContactChangedTopicInstagramId
        """
        return self._instagram_id

    @instagram_id.setter
    def instagram_id(self, instagram_id: 'ExternalContactsContactChangedTopicInstagramId') -> None:
        """
        Sets the instagram_id of this ExternalContactsContactChangedTopicContact.


        :param instagram_id: The instagram_id of this ExternalContactsContactChangedTopicContact.
        :type: ExternalContactsContactChangedTopicInstagramId
        """
        

        self._instagram_id = instagram_id

    @property
    def external_ids(self) -> List['ExternalContactsContactChangedTopicExternalId']:
        """
        Gets the external_ids of this ExternalContactsContactChangedTopicContact.


        :return: The external_ids of this ExternalContactsContactChangedTopicContact.
        :rtype: list[ExternalContactsContactChangedTopicExternalId]
        """
        return self._external_ids

    @external_ids.setter
    def external_ids(self, external_ids: List['ExternalContactsContactChangedTopicExternalId']) -> None:
        """
        Sets the external_ids of this ExternalContactsContactChangedTopicContact.


        :param external_ids: The external_ids of this ExternalContactsContactChangedTopicContact.
        :type: list[ExternalContactsContactChangedTopicExternalId]
        """
        

        self._external_ids = external_ids

    @property
    def apple_opaque_ids(self) -> List['ExternalContactsContactChangedTopicAppleOpaqueId']:
        """
        Gets the apple_opaque_ids of this ExternalContactsContactChangedTopicContact.


        :return: The apple_opaque_ids of this ExternalContactsContactChangedTopicContact.
        :rtype: list[ExternalContactsContactChangedTopicAppleOpaqueId]
        """
        return self._apple_opaque_ids

    @apple_opaque_ids.setter
    def apple_opaque_ids(self, apple_opaque_ids: List['ExternalContactsContactChangedTopicAppleOpaqueId']) -> None:
        """
        Sets the apple_opaque_ids of this ExternalContactsContactChangedTopicContact.


        :param apple_opaque_ids: The apple_opaque_ids of this ExternalContactsContactChangedTopicContact.
        :type: list[ExternalContactsContactChangedTopicAppleOpaqueId]
        """
        

        self._apple_opaque_ids = apple_opaque_ids

    @property
    def canonical_contact_id(self) -> str:
        """
        Gets the canonical_contact_id of this ExternalContactsContactChangedTopicContact.


        :return: The canonical_contact_id of this ExternalContactsContactChangedTopicContact.
        :rtype: str
        """
        return self._canonical_contact_id

    @canonical_contact_id.setter
    def canonical_contact_id(self, canonical_contact_id: str) -> None:
        """
        Sets the canonical_contact_id of this ExternalContactsContactChangedTopicContact.


        :param canonical_contact_id: The canonical_contact_id of this ExternalContactsContactChangedTopicContact.
        :type: str
        """
        

        self._canonical_contact_id = canonical_contact_id

    @property
    def schema(self) -> 'ExternalContactsContactChangedTopicDataSchema':
        """
        Gets the schema of this ExternalContactsContactChangedTopicContact.


        :return: The schema of this ExternalContactsContactChangedTopicContact.
        :rtype: ExternalContactsContactChangedTopicDataSchema
        """
        return self._schema

    @schema.setter
    def schema(self, schema: 'ExternalContactsContactChangedTopicDataSchema') -> None:
        """
        Sets the schema of this ExternalContactsContactChangedTopicContact.


        :param schema: The schema of this ExternalContactsContactChangedTopicContact.
        :type: ExternalContactsContactChangedTopicDataSchema
        """
        

        self._schema = schema

    @property
    def custom_fields(self) -> Dict[str, object]:
        """
        Gets the custom_fields of this ExternalContactsContactChangedTopicContact.


        :return: The custom_fields of this ExternalContactsContactChangedTopicContact.
        :rtype: dict(str, object)
        """
        return self._custom_fields

    @custom_fields.setter
    def custom_fields(self, custom_fields: Dict[str, object]) -> None:
        """
        Sets the custom_fields of this ExternalContactsContactChangedTopicContact.


        :param custom_fields: The custom_fields of this ExternalContactsContactChangedTopicContact.
        :type: dict(str, object)
        """
        

        self._custom_fields = custom_fields

    @property
    def merge_set(self) -> List[str]:
        """
        Gets the merge_set of this ExternalContactsContactChangedTopicContact.


        :return: The merge_set of this ExternalContactsContactChangedTopicContact.
        :rtype: list[str]
        """
        return self._merge_set

    @merge_set.setter
    def merge_set(self, merge_set: List[str]) -> None:
        """
        Sets the merge_set of this ExternalContactsContactChangedTopicContact.


        :param merge_set: The merge_set of this ExternalContactsContactChangedTopicContact.
        :type: list[str]
        """
        

        self._merge_set = merge_set

    @property
    def merged_from(self) -> List[str]:
        """
        Gets the merged_from of this ExternalContactsContactChangedTopicContact.


        :return: The merged_from of this ExternalContactsContactChangedTopicContact.
        :rtype: list[str]
        """
        return self._merged_from

    @merged_from.setter
    def merged_from(self, merged_from: List[str]) -> None:
        """
        Sets the merged_from of this ExternalContactsContactChangedTopicContact.


        :param merged_from: The merged_from of this ExternalContactsContactChangedTopicContact.
        :type: list[str]
        """
        

        self._merged_from = merged_from

    @property
    def merged_to(self) -> str:
        """
        Gets the merged_to of this ExternalContactsContactChangedTopicContact.


        :return: The merged_to of this ExternalContactsContactChangedTopicContact.
        :rtype: str
        """
        return self._merged_to

    @merged_to.setter
    def merged_to(self, merged_to: str) -> None:
        """
        Sets the merged_to of this ExternalContactsContactChangedTopicContact.


        :param merged_to: The merged_to of this ExternalContactsContactChangedTopicContact.
        :type: str
        """
        

        self._merged_to = merged_to

    @property
    def merge_operation(self) -> 'ExternalContactsContactChangedTopicMergeOperation':
        """
        Gets the merge_operation of this ExternalContactsContactChangedTopicContact.


        :return: The merge_operation of this ExternalContactsContactChangedTopicContact.
        :rtype: ExternalContactsContactChangedTopicMergeOperation
        """
        return self._merge_operation

    @merge_operation.setter
    def merge_operation(self, merge_operation: 'ExternalContactsContactChangedTopicMergeOperation') -> None:
        """
        Sets the merge_operation of this ExternalContactsContactChangedTopicContact.


        :param merge_operation: The merge_operation of this ExternalContactsContactChangedTopicContact.
        :type: ExternalContactsContactChangedTopicMergeOperation
        """
        

        self._merge_operation = merge_operation

    @property
    def create_date(self) -> datetime:
        """
        Gets the create_date of this ExternalContactsContactChangedTopicContact.


        :return: The create_date of this ExternalContactsContactChangedTopicContact.
        :rtype: datetime
        """
        return self._create_date

    @create_date.setter
    def create_date(self, create_date: datetime) -> None:
        """
        Sets the create_date of this ExternalContactsContactChangedTopicContact.


        :param create_date: The create_date of this ExternalContactsContactChangedTopicContact.
        :type: datetime
        """
        

        self._create_date = create_date

    @property
    def modify_date(self) -> datetime:
        """
        Gets the modify_date of this ExternalContactsContactChangedTopicContact.


        :return: The modify_date of this ExternalContactsContactChangedTopicContact.
        :rtype: datetime
        """
        return self._modify_date

    @modify_date.setter
    def modify_date(self, modify_date: datetime) -> None:
        """
        Sets the modify_date of this ExternalContactsContactChangedTopicContact.


        :param modify_date: The modify_date of this ExternalContactsContactChangedTopicContact.
        :type: datetime
        """
        

        self._modify_date = modify_date

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

