# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class ExternalMetricDataProcessedItem(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ExternalMetricDataProcessedItem - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'user_id': 'str',
            'user_email': 'str',
            'metric_id': 'str',
            'date_occurred': 'date',
            'value': 'float',
            'count': 'int',
            'type': 'str',
            'total_value': 'float',
            'total_count': 'int'
        }

        self.attribute_map = {
            'user_id': 'userId',
            'user_email': 'userEmail',
            'metric_id': 'metricId',
            'date_occurred': 'dateOccurred',
            'value': 'value',
            'count': 'count',
            'type': 'type',
            'total_value': 'totalValue',
            'total_count': 'totalCount'
        }

        self._user_id = None
        self._user_email = None
        self._metric_id = None
        self._date_occurred = None
        self._value = None
        self._count = None
        self._type = None
        self._total_value = None
        self._total_count = None

    @property
    def user_id(self) -> str:
        """
        Gets the user_id of this ExternalMetricDataProcessedItem.
        The user ID. Must provide either userId or userEmail, but not both.

        :return: The user_id of this ExternalMetricDataProcessedItem.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id: str) -> None:
        """
        Sets the user_id of this ExternalMetricDataProcessedItem.
        The user ID. Must provide either userId or userEmail, but not both.

        :param user_id: The user_id of this ExternalMetricDataProcessedItem.
        :type: str
        """
        

        self._user_id = user_id

    @property
    def user_email(self) -> str:
        """
        Gets the user_email of this ExternalMetricDataProcessedItem.
        The user main email used in user's GenesysCloud account. Must provide either userId or userEmail, but not both.

        :return: The user_email of this ExternalMetricDataProcessedItem.
        :rtype: str
        """
        return self._user_email

    @user_email.setter
    def user_email(self, user_email: str) -> None:
        """
        Sets the user_email of this ExternalMetricDataProcessedItem.
        The user main email used in user's GenesysCloud account. Must provide either userId or userEmail, but not both.

        :param user_email: The user_email of this ExternalMetricDataProcessedItem.
        :type: str
        """
        

        self._user_email = user_email

    @property
    def metric_id(self) -> str:
        """
        Gets the metric_id of this ExternalMetricDataProcessedItem.
        The ID of the external metric definition

        :return: The metric_id of this ExternalMetricDataProcessedItem.
        :rtype: str
        """
        return self._metric_id

    @metric_id.setter
    def metric_id(self, metric_id: str) -> None:
        """
        Sets the metric_id of this ExternalMetricDataProcessedItem.
        The ID of the external metric definition

        :param metric_id: The metric_id of this ExternalMetricDataProcessedItem.
        :type: str
        """
        

        self._metric_id = metric_id

    @property
    def date_occurred(self) -> date:
        """
        Gets the date_occurred of this ExternalMetricDataProcessedItem.
        The date of the metric data. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_occurred of this ExternalMetricDataProcessedItem.
        :rtype: date
        """
        return self._date_occurred

    @date_occurred.setter
    def date_occurred(self, date_occurred: date) -> None:
        """
        Sets the date_occurred of this ExternalMetricDataProcessedItem.
        The date of the metric data. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_occurred: The date_occurred of this ExternalMetricDataProcessedItem.
        :type: date
        """
        

        self._date_occurred = date_occurred

    @property
    def value(self) -> float:
        """
        Gets the value of this ExternalMetricDataProcessedItem.
        The value of the metric data. When value is null, the metric data will be deleted.

        :return: The value of this ExternalMetricDataProcessedItem.
        :rtype: float
        """
        return self._value

    @value.setter
    def value(self, value: float) -> None:
        """
        Sets the value of this ExternalMetricDataProcessedItem.
        The value of the metric data. When value is null, the metric data will be deleted.

        :param value: The value of this ExternalMetricDataProcessedItem.
        :type: float
        """
        

        self._value = value

    @property
    def count(self) -> int:
        """
        Gets the count of this ExternalMetricDataProcessedItem.
        The number of data points. The default value is 0 when type is Cumulative and the metric data already exists, otherwise 1. When total count reaches 0, the metric data will be deleted.

        :return: The count of this ExternalMetricDataProcessedItem.
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count: int) -> None:
        """
        Sets the count of this ExternalMetricDataProcessedItem.
        The number of data points. The default value is 0 when type is Cumulative and the metric data already exists, otherwise 1. When total count reaches 0, the metric data will be deleted.

        :param count: The count of this ExternalMetricDataProcessedItem.
        :type: int
        """
        

        self._count = count

    @property
    def type(self) -> str:
        """
        Gets the type of this ExternalMetricDataProcessedItem.
        The type of the metric data. The default value is Total.

        :return: The type of this ExternalMetricDataProcessedItem.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this ExternalMetricDataProcessedItem.
        The type of the metric data. The default value is Total.

        :param type: The type of this ExternalMetricDataProcessedItem.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Total", "Cumulative"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def total_value(self) -> float:
        """
        Gets the total_value of this ExternalMetricDataProcessedItem.
        The total value of the metric data.

        :return: The total_value of this ExternalMetricDataProcessedItem.
        :rtype: float
        """
        return self._total_value

    @total_value.setter
    def total_value(self, total_value: float) -> None:
        """
        Sets the total_value of this ExternalMetricDataProcessedItem.
        The total value of the metric data.

        :param total_value: The total_value of this ExternalMetricDataProcessedItem.
        :type: float
        """
        

        self._total_value = total_value

    @property
    def total_count(self) -> int:
        """
        Gets the total_count of this ExternalMetricDataProcessedItem.
        The total number of data points.

        :return: The total_count of this ExternalMetricDataProcessedItem.
        :rtype: int
        """
        return self._total_count

    @total_count.setter
    def total_count(self, total_count: int) -> None:
        """
        Sets the total_count of this ExternalMetricDataProcessedItem.
        The total number of data points.

        :param total_count: The total_count of this ExternalMetricDataProcessedItem.
        :type: int
        """
        

        self._total_count = total_count

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

