# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import EnrichFieldRules
    from . import ExternalOrganization
    from . import ExternalOrganizationIdentifier
    from . import WritableStarrableDivision

class ExternalOrganizationEnrichRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ExternalOrganizationEnrichRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'division': 'WritableStarrableDivision',
            'matching_identifiers': 'list[ExternalOrganizationIdentifier]',
            'action': 'str',
            'external_organization': 'ExternalOrganization',
            'field_rules': 'EnrichFieldRules',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'division': 'division',
            'matching_identifiers': 'matchingIdentifiers',
            'action': 'action',
            'external_organization': 'externalOrganization',
            'field_rules': 'fieldRules',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._division = None
        self._matching_identifiers = None
        self._action = None
        self._external_organization = None
        self._field_rules = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ExternalOrganizationEnrichRequest.
        A user-specified tracker string, only useful in the Bulk-Enrich API. If one Bulk-Enrich operation in a request fails, the requested operation will be repeated in the Bulk API response, including this id field, allowing associating request and response operations.

        :return: The id of this ExternalOrganizationEnrichRequest.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ExternalOrganizationEnrichRequest.
        A user-specified tracker string, only useful in the Bulk-Enrich API. If one Bulk-Enrich operation in a request fails, the requested operation will be repeated in the Bulk API response, including this id field, allowing associating request and response operations.

        :param id: The id of this ExternalOrganizationEnrichRequest.
        :type: str
        """
        

        self._id = id

    @property
    def division(self) -> 'WritableStarrableDivision':
        """
        Gets the division of this ExternalOrganizationEnrichRequest.
        The division to which this entity belongs.

        :return: The division of this ExternalOrganizationEnrichRequest.
        :rtype: WritableStarrableDivision
        """
        return self._division

    @division.setter
    def division(self, division: 'WritableStarrableDivision') -> None:
        """
        Sets the division of this ExternalOrganizationEnrichRequest.
        The division to which this entity belongs.

        :param division: The division of this ExternalOrganizationEnrichRequest.
        :type: WritableStarrableDivision
        """
        

        self._division = division

    @property
    def matching_identifiers(self) -> List['ExternalOrganizationIdentifier']:
        """
        Gets the matching_identifiers of this ExternalOrganizationEnrichRequest.
        An ordered list of one or more Identifiers which might each be claimed by an External Organization. `action` describes what to do with any possibly matching External Organization. Identifier lookups will occur in the order specified here.

        :return: The matching_identifiers of this ExternalOrganizationEnrichRequest.
        :rtype: list[ExternalOrganizationIdentifier]
        """
        return self._matching_identifiers

    @matching_identifiers.setter
    def matching_identifiers(self, matching_identifiers: List['ExternalOrganizationIdentifier']) -> None:
        """
        Sets the matching_identifiers of this ExternalOrganizationEnrichRequest.
        An ordered list of one or more Identifiers which might each be claimed by an External Organization. `action` describes what to do with any possibly matching External Organization. Identifier lookups will occur in the order specified here.

        :param matching_identifiers: The matching_identifiers of this ExternalOrganizationEnrichRequest.
        :type: list[ExternalOrganizationIdentifier]
        """
        

        self._matching_identifiers = matching_identifiers

    @property
    def action(self) -> str:
        """
        Gets the action of this ExternalOrganizationEnrichRequest.
        The action that should be taken based on any External Organization found by `matchingIdentifiers`.

        :return: The action of this ExternalOrganizationEnrichRequest.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action: str) -> None:
        """
        Sets the action of this ExternalOrganizationEnrichRequest.
        The action that should be taken based on any External Organization found by `matchingIdentifiers`.

        :param action: The action of this ExternalOrganizationEnrichRequest.
        :type: str
        """
        if isinstance(action, int):
            action = str(action)
        allowed_values = ["Upsert", "Update", "Insert"]
        if action.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for action -> " + action)
            self._action = "outdated_sdk_version"
        else:
            self._action = action

    @property
    def external_organization(self) -> 'ExternalOrganization':
        """
        Gets the external_organization of this ExternalOrganizationEnrichRequest.
        Data to be added, either as an update to an existing External Organization or the body of a new External Organization. Omitting a field in this contract means that it will be treated as null in the `fieldRules` logic.

        :return: The external_organization of this ExternalOrganizationEnrichRequest.
        :rtype: ExternalOrganization
        """
        return self._external_organization

    @external_organization.setter
    def external_organization(self, external_organization: 'ExternalOrganization') -> None:
        """
        Sets the external_organization of this ExternalOrganizationEnrichRequest.
        Data to be added, either as an update to an existing External Organization or the body of a new External Organization. Omitting a field in this contract means that it will be treated as null in the `fieldRules` logic.

        :param external_organization: The external_organization of this ExternalOrganizationEnrichRequest.
        :type: ExternalOrganization
        """
        

        self._external_organization = external_organization

    @property
    def field_rules(self) -> 'EnrichFieldRules':
        """
        Gets the field_rules of this ExternalOrganizationEnrichRequest.
        Logic describing how to combine data from the submitted request with data found in the database.

        :return: The field_rules of this ExternalOrganizationEnrichRequest.
        :rtype: EnrichFieldRules
        """
        return self._field_rules

    @field_rules.setter
    def field_rules(self, field_rules: 'EnrichFieldRules') -> None:
        """
        Sets the field_rules of this ExternalOrganizationEnrichRequest.
        Logic describing how to combine data from the submitted request with data found in the database.

        :param field_rules: The field_rules of this ExternalOrganizationEnrichRequest.
        :type: EnrichFieldRules
        """
        

        self._field_rules = field_rules

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this ExternalOrganizationEnrichRequest.
        The URI for this object

        :return: The self_uri of this ExternalOrganizationEnrichRequest.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this ExternalOrganizationEnrichRequest.
        The URI for this object

        :param self_uri: The self_uri of this ExternalOrganizationEnrichRequest.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

