# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import MessagingSettingRequestReference
    from . import SupportedContentReference

class FacebookIntegrationRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        FacebookIntegrationRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'supported_content': 'SupportedContentReference',
            'messaging_setting': 'MessagingSettingRequestReference',
            'page_access_token': 'str',
            'user_access_token': 'str',
            'page_id': 'str',
            'app_id': 'str',
            'app_secret': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'supported_content': 'supportedContent',
            'messaging_setting': 'messagingSetting',
            'page_access_token': 'pageAccessToken',
            'user_access_token': 'userAccessToken',
            'page_id': 'pageId',
            'app_id': 'appId',
            'app_secret': 'appSecret',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._supported_content = None
        self._messaging_setting = None
        self._page_access_token = None
        self._user_access_token = None
        self._page_id = None
        self._app_id = None
        self._app_secret = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this FacebookIntegrationRequest.
        The globally unique identifier for the object.

        :return: The id of this FacebookIntegrationRequest.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this FacebookIntegrationRequest.
        The globally unique identifier for the object.

        :param id: The id of this FacebookIntegrationRequest.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this FacebookIntegrationRequest.
        The name of the Facebook Integration

        :return: The name of this FacebookIntegrationRequest.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this FacebookIntegrationRequest.
        The name of the Facebook Integration

        :param name: The name of this FacebookIntegrationRequest.
        :type: str
        """
        

        self._name = name

    @property
    def supported_content(self) -> 'SupportedContentReference':
        """
        Gets the supported_content of this FacebookIntegrationRequest.
        Defines the SupportedContent profile configured for an integration

        :return: The supported_content of this FacebookIntegrationRequest.
        :rtype: SupportedContentReference
        """
        return self._supported_content

    @supported_content.setter
    def supported_content(self, supported_content: 'SupportedContentReference') -> None:
        """
        Sets the supported_content of this FacebookIntegrationRequest.
        Defines the SupportedContent profile configured for an integration

        :param supported_content: The supported_content of this FacebookIntegrationRequest.
        :type: SupportedContentReference
        """
        

        self._supported_content = supported_content

    @property
    def messaging_setting(self) -> 'MessagingSettingRequestReference':
        """
        Gets the messaging_setting of this FacebookIntegrationRequest.
        Defines the message settings to be applied for this integration

        :return: The messaging_setting of this FacebookIntegrationRequest.
        :rtype: MessagingSettingRequestReference
        """
        return self._messaging_setting

    @messaging_setting.setter
    def messaging_setting(self, messaging_setting: 'MessagingSettingRequestReference') -> None:
        """
        Sets the messaging_setting of this FacebookIntegrationRequest.
        Defines the message settings to be applied for this integration

        :param messaging_setting: The messaging_setting of this FacebookIntegrationRequest.
        :type: MessagingSettingRequestReference
        """
        

        self._messaging_setting = messaging_setting

    @property
    def page_access_token(self) -> str:
        """
        Gets the page_access_token of this FacebookIntegrationRequest.
        The long-lived Page Access Token of Facebook page.  See https://developers.facebook.com/docs/facebook-login/access-tokens.  When a pageAccessToken is provided, pageId and userAccessToken are not required.

        :return: The page_access_token of this FacebookIntegrationRequest.
        :rtype: str
        """
        return self._page_access_token

    @page_access_token.setter
    def page_access_token(self, page_access_token: str) -> None:
        """
        Sets the page_access_token of this FacebookIntegrationRequest.
        The long-lived Page Access Token of Facebook page.  See https://developers.facebook.com/docs/facebook-login/access-tokens.  When a pageAccessToken is provided, pageId and userAccessToken are not required.

        :param page_access_token: The page_access_token of this FacebookIntegrationRequest.
        :type: str
        """
        

        self._page_access_token = page_access_token

    @property
    def user_access_token(self) -> str:
        """
        Gets the user_access_token of this FacebookIntegrationRequest.
        The short-lived User Access Token of the Facebook user logged into the Facebook app.  See https://developers.facebook.com/docs/facebook-login/access-tokens.  When userAccessToken is provided, pageId is mandatory.  When userAccessToken/pageId combination is provided, pageAccessToken is not required.

        :return: The user_access_token of this FacebookIntegrationRequest.
        :rtype: str
        """
        return self._user_access_token

    @user_access_token.setter
    def user_access_token(self, user_access_token: str) -> None:
        """
        Sets the user_access_token of this FacebookIntegrationRequest.
        The short-lived User Access Token of the Facebook user logged into the Facebook app.  See https://developers.facebook.com/docs/facebook-login/access-tokens.  When userAccessToken is provided, pageId is mandatory.  When userAccessToken/pageId combination is provided, pageAccessToken is not required.

        :param user_access_token: The user_access_token of this FacebookIntegrationRequest.
        :type: str
        """
        

        self._user_access_token = user_access_token

    @property
    def page_id(self) -> str:
        """
        Gets the page_id of this FacebookIntegrationRequest.
        The page Id of Facebook page. The pageId is required when userAccessToken is provided.

        :return: The page_id of this FacebookIntegrationRequest.
        :rtype: str
        """
        return self._page_id

    @page_id.setter
    def page_id(self, page_id: str) -> None:
        """
        Sets the page_id of this FacebookIntegrationRequest.
        The page Id of Facebook page. The pageId is required when userAccessToken is provided.

        :param page_id: The page_id of this FacebookIntegrationRequest.
        :type: str
        """
        

        self._page_id = page_id

    @property
    def app_id(self) -> str:
        """
        Gets the app_id of this FacebookIntegrationRequest.
        The app Id of Facebook app. The appId is required when a customer wants to use their own approved Facebook app.

        :return: The app_id of this FacebookIntegrationRequest.
        :rtype: str
        """
        return self._app_id

    @app_id.setter
    def app_id(self, app_id: str) -> None:
        """
        Sets the app_id of this FacebookIntegrationRequest.
        The app Id of Facebook app. The appId is required when a customer wants to use their own approved Facebook app.

        :param app_id: The app_id of this FacebookIntegrationRequest.
        :type: str
        """
        

        self._app_id = app_id

    @property
    def app_secret(self) -> str:
        """
        Gets the app_secret of this FacebookIntegrationRequest.
        The app Secret of Facebook app. The appSecret is required when appId is provided.

        :return: The app_secret of this FacebookIntegrationRequest.
        :rtype: str
        """
        return self._app_secret

    @app_secret.setter
    def app_secret(self, app_secret: str) -> None:
        """
        Sets the app_secret of this FacebookIntegrationRequest.
        The app Secret of Facebook app. The appSecret is required when appId is provided.

        :param app_secret: The app_secret of this FacebookIntegrationRequest.
        :type: str
        """
        

        self._app_secret = app_secret

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this FacebookIntegrationRequest.
        The URI for this object

        :return: The self_uri of this FacebookIntegrationRequest.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this FacebookIntegrationRequest.
        The URI for this object

        :param self_uri: The self_uri of this FacebookIntegrationRequest.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

