# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class Feedback(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        Feedback - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'suggestion_id': 'str',
            'user_provided': 'bool',
            'relevance': 'str'
        }

        self.attribute_map = {
            'suggestion_id': 'suggestionId',
            'user_provided': 'userProvided',
            'relevance': 'relevance'
        }

        self._suggestion_id = None
        self._user_provided = None
        self._relevance = None

    @property
    def suggestion_id(self) -> str:
        """
        Gets the suggestion_id of this Feedback.
        Feedback suggestion id.

        :return: The suggestion_id of this Feedback.
        :rtype: str
        """
        return self._suggestion_id

    @suggestion_id.setter
    def suggestion_id(self, suggestion_id: str) -> None:
        """
        Sets the suggestion_id of this Feedback.
        Feedback suggestion id.

        :param suggestion_id: The suggestion_id of this Feedback.
        :type: str
        """
        

        self._suggestion_id = suggestion_id

    @property
    def user_provided(self) -> bool:
        """
        Gets the user_provided of this Feedback.
        Indicates whether the answer/item was clicked by the human agent or not.

        :return: The user_provided of this Feedback.
        :rtype: bool
        """
        return self._user_provided

    @user_provided.setter
    def user_provided(self, user_provided: bool) -> None:
        """
        Sets the user_provided of this Feedback.
        Indicates whether the answer/item was clicked by the human agent or not.

        :param user_provided: The user_provided of this Feedback.
        :type: bool
        """
        

        self._user_provided = user_provided

    @property
    def relevance(self) -> str:
        """
        Gets the relevance of this Feedback.
        Feedback relevance.

        :return: The relevance of this Feedback.
        :rtype: str
        """
        return self._relevance

    @relevance.setter
    def relevance(self, relevance: str) -> None:
        """
        Sets the relevance of this Feedback.
        Feedback relevance.

        :param relevance: The relevance of this Feedback.
        :type: str
        """
        if isinstance(relevance, int):
            relevance = str(relevance)
        allowed_values = ["Unknown", "Relevant", "Irrelevant"]
        if relevance.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for relevance -> " + relevance)
            self._relevance = "outdated_sdk_version"
        else:
            self._relevance = relevance

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

