# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class FlowExecutionDataQueryResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        FlowExecutionDataQueryResult - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'start_date_time': 'datetime',
            'end_date_time': 'datetime',
            'flow_id': 'str',
            'flow_version': 'str',
            'conversation_id': 'str',
            'workitem_id': 'str',
            'flow_type': 'str',
            'flow_error_reason': 'str',
            'flow_warning_reason': 'str',
            'flow_name': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'start_date_time': 'startDateTime',
            'end_date_time': 'endDateTime',
            'flow_id': 'flowId',
            'flow_version': 'flowVersion',
            'conversation_id': 'conversationId',
            'workitem_id': 'workitemId',
            'flow_type': 'flowType',
            'flow_error_reason': 'flowErrorReason',
            'flow_warning_reason': 'flowWarningReason',
            'flow_name': 'flowName',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._start_date_time = None
        self._end_date_time = None
        self._flow_id = None
        self._flow_version = None
        self._conversation_id = None
        self._workitem_id = None
        self._flow_type = None
        self._flow_error_reason = None
        self._flow_warning_reason = None
        self._flow_name = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this FlowExecutionDataQueryResult.
        The globally unique identifier for the object.

        :return: The id of this FlowExecutionDataQueryResult.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this FlowExecutionDataQueryResult.
        The globally unique identifier for the object.

        :param id: The id of this FlowExecutionDataQueryResult.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this FlowExecutionDataQueryResult.


        :return: The name of this FlowExecutionDataQueryResult.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this FlowExecutionDataQueryResult.


        :param name: The name of this FlowExecutionDataQueryResult.
        :type: str
        """
        

        self._name = name

    @property
    def start_date_time(self) -> datetime:
        """
        Gets the start_date_time of this FlowExecutionDataQueryResult.
        The start time for the execution of this flow. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The start_date_time of this FlowExecutionDataQueryResult.
        :rtype: datetime
        """
        return self._start_date_time

    @start_date_time.setter
    def start_date_time(self, start_date_time: datetime) -> None:
        """
        Sets the start_date_time of this FlowExecutionDataQueryResult.
        The start time for the execution of this flow. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param start_date_time: The start_date_time of this FlowExecutionDataQueryResult.
        :type: datetime
        """
        

        self._start_date_time = start_date_time

    @property
    def end_date_time(self) -> datetime:
        """
        Gets the end_date_time of this FlowExecutionDataQueryResult.
        The end time for the execution of this flow. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The end_date_time of this FlowExecutionDataQueryResult.
        :rtype: datetime
        """
        return self._end_date_time

    @end_date_time.setter
    def end_date_time(self, end_date_time: datetime) -> None:
        """
        Sets the end_date_time of this FlowExecutionDataQueryResult.
        The end time for the execution of this flow. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param end_date_time: The end_date_time of this FlowExecutionDataQueryResult.
        :type: datetime
        """
        

        self._end_date_time = end_date_time

    @property
    def flow_id(self) -> str:
        """
        Gets the flow_id of this FlowExecutionDataQueryResult.
        The id of the flow that was executed.

        :return: The flow_id of this FlowExecutionDataQueryResult.
        :rtype: str
        """
        return self._flow_id

    @flow_id.setter
    def flow_id(self, flow_id: str) -> None:
        """
        Sets the flow_id of this FlowExecutionDataQueryResult.
        The id of the flow that was executed.

        :param flow_id: The flow_id of this FlowExecutionDataQueryResult.
        :type: str
        """
        

        self._flow_id = flow_id

    @property
    def flow_version(self) -> str:
        """
        Gets the flow_version of this FlowExecutionDataQueryResult.
        The version of the flow that was executed.

        :return: The flow_version of this FlowExecutionDataQueryResult.
        :rtype: str
        """
        return self._flow_version

    @flow_version.setter
    def flow_version(self, flow_version: str) -> None:
        """
        Sets the flow_version of this FlowExecutionDataQueryResult.
        The version of the flow that was executed.

        :param flow_version: The flow_version of this FlowExecutionDataQueryResult.
        :type: str
        """
        

        self._flow_version = flow_version

    @property
    def conversation_id(self) -> str:
        """
        Gets the conversation_id of this FlowExecutionDataQueryResult.
        The id of the conversation that executed this flow.

        :return: The conversation_id of this FlowExecutionDataQueryResult.
        :rtype: str
        """
        return self._conversation_id

    @conversation_id.setter
    def conversation_id(self, conversation_id: str) -> None:
        """
        Sets the conversation_id of this FlowExecutionDataQueryResult.
        The id of the conversation that executed this flow.

        :param conversation_id: The conversation_id of this FlowExecutionDataQueryResult.
        :type: str
        """
        

        self._conversation_id = conversation_id

    @property
    def workitem_id(self) -> str:
        """
        Gets the workitem_id of this FlowExecutionDataQueryResult.
        The id of the workitem that executed this flow.

        :return: The workitem_id of this FlowExecutionDataQueryResult.
        :rtype: str
        """
        return self._workitem_id

    @workitem_id.setter
    def workitem_id(self, workitem_id: str) -> None:
        """
        Sets the workitem_id of this FlowExecutionDataQueryResult.
        The id of the workitem that executed this flow.

        :param workitem_id: The workitem_id of this FlowExecutionDataQueryResult.
        :type: str
        """
        

        self._workitem_id = workitem_id

    @property
    def flow_type(self) -> str:
        """
        Gets the flow_type of this FlowExecutionDataQueryResult.
        The type of flow.

        :return: The flow_type of this FlowExecutionDataQueryResult.
        :rtype: str
        """
        return self._flow_type

    @flow_type.setter
    def flow_type(self, flow_type: str) -> None:
        """
        Sets the flow_type of this FlowExecutionDataQueryResult.
        The type of flow.

        :param flow_type: The flow_type of this FlowExecutionDataQueryResult.
        :type: str
        """
        if isinstance(flow_type, int):
            flow_type = str(flow_type)
        allowed_values = ["bot", "commonmodule", "digitalbot", "inboundcall", "inboundchat", "inboundemail", "inboundshortmessage", "inqueuecall", "inqueueshortmessage", "inqueueemail", "outboundcall", "securecall", "surveyinvite", "voice", "voicemail", "voicesurvey", "workflow", "workitem"]
        if flow_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for flow_type -> " + flow_type)
            self._flow_type = "outdated_sdk_version"
        else:
            self._flow_type = flow_type

    @property
    def flow_error_reason(self) -> str:
        """
        Gets the flow_error_reason of this FlowExecutionDataQueryResult.
        If the flow errored out this is the reason.

        :return: The flow_error_reason of this FlowExecutionDataQueryResult.
        :rtype: str
        """
        return self._flow_error_reason

    @flow_error_reason.setter
    def flow_error_reason(self, flow_error_reason: str) -> None:
        """
        Sets the flow_error_reason of this FlowExecutionDataQueryResult.
        If the flow errored out this is the reason.

        :param flow_error_reason: The flow_error_reason of this FlowExecutionDataQueryResult.
        :type: str
        """
        

        self._flow_error_reason = flow_error_reason

    @property
    def flow_warning_reason(self) -> str:
        """
        Gets the flow_warning_reason of this FlowExecutionDataQueryResult.
        If the flow had a warning, this is the reason.

        :return: The flow_warning_reason of this FlowExecutionDataQueryResult.
        :rtype: str
        """
        return self._flow_warning_reason

    @flow_warning_reason.setter
    def flow_warning_reason(self, flow_warning_reason: str) -> None:
        """
        Sets the flow_warning_reason of this FlowExecutionDataQueryResult.
        If the flow had a warning, this is the reason.

        :param flow_warning_reason: The flow_warning_reason of this FlowExecutionDataQueryResult.
        :type: str
        """
        

        self._flow_warning_reason = flow_warning_reason

    @property
    def flow_name(self) -> str:
        """
        Gets the flow_name of this FlowExecutionDataQueryResult.
        The name of the flow.

        :return: The flow_name of this FlowExecutionDataQueryResult.
        :rtype: str
        """
        return self._flow_name

    @flow_name.setter
    def flow_name(self, flow_name: str) -> None:
        """
        Sets the flow_name of this FlowExecutionDataQueryResult.
        The name of the flow.

        :param flow_name: The flow_name of this FlowExecutionDataQueryResult.
        :type: str
        """
        

        self._flow_name = flow_name

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this FlowExecutionDataQueryResult.
        The URI for this object

        :return: The self_uri of this FlowExecutionDataQueryResult.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this FlowExecutionDataQueryResult.
        The URI for this object

        :param self_uri: The self_uri of this FlowExecutionDataQueryResult.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

