# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef

class FlowHealthIntentVersionInfo(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        FlowHealthIntentVersionInfo - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'nlu_version': 'AddressableEntityRef',
            'flow_version': 'AddressableEntityRef',
            'nlu_domain': 'AddressableEntityRef'
        }

        self.attribute_map = {
            'nlu_version': 'nluVersion',
            'flow_version': 'flowVersion',
            'nlu_domain': 'nluDomain'
        }

        self._nlu_version = None
        self._flow_version = None
        self._nlu_domain = None

    @property
    def nlu_version(self) -> 'AddressableEntityRef':
        """
        Gets the nlu_version of this FlowHealthIntentVersionInfo.
        NLU Version Info for this flow version.

        :return: The nlu_version of this FlowHealthIntentVersionInfo.
        :rtype: AddressableEntityRef
        """
        return self._nlu_version

    @nlu_version.setter
    def nlu_version(self, nlu_version: 'AddressableEntityRef') -> None:
        """
        Sets the nlu_version of this FlowHealthIntentVersionInfo.
        NLU Version Info for this flow version.

        :param nlu_version: The nlu_version of this FlowHealthIntentVersionInfo.
        :type: AddressableEntityRef
        """
        

        self._nlu_version = nlu_version

    @property
    def flow_version(self) -> 'AddressableEntityRef':
        """
        Gets the flow_version of this FlowHealthIntentVersionInfo.
        Given flow's Version Info.

        :return: The flow_version of this FlowHealthIntentVersionInfo.
        :rtype: AddressableEntityRef
        """
        return self._flow_version

    @flow_version.setter
    def flow_version(self, flow_version: 'AddressableEntityRef') -> None:
        """
        Sets the flow_version of this FlowHealthIntentVersionInfo.
        Given flow's Version Info.

        :param flow_version: The flow_version of this FlowHealthIntentVersionInfo.
        :type: AddressableEntityRef
        """
        

        self._flow_version = flow_version

    @property
    def nlu_domain(self) -> 'AddressableEntityRef':
        """
        Gets the nlu_domain of this FlowHealthIntentVersionInfo.
        NLU Domain Info for this flow version.

        :return: The nlu_domain of this FlowHealthIntentVersionInfo.
        :rtype: AddressableEntityRef
        """
        return self._nlu_domain

    @nlu_domain.setter
    def nlu_domain(self, nlu_domain: 'AddressableEntityRef') -> None:
        """
        Sets the nlu_domain of this FlowHealthIntentVersionInfo.
        NLU Domain Info for this flow version.

        :param nlu_domain: The nlu_domain of this FlowHealthIntentVersionInfo.
        :type: AddressableEntityRef
        """
        

        self._nlu_domain = nlu_domain

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

