# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import FlowPathsFlowFilter

class FlowPathsQuery(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        FlowPathsQuery - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'category': 'str',
            'flows': 'list[FlowPathsFlowFilter]'
        }

        self.attribute_map = {
            'category': 'category',
            'flows': 'flows'
        }

        self._category = None
        self._flows = None

    @property
    def category(self) -> str:
        """
        Gets the category of this FlowPathsQuery.
        Category (use case) of the paths within a given domain.

        :return: The category of this FlowPathsQuery.
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category: str) -> None:
        """
        Sets the category of this FlowPathsQuery.
        Category (use case) of the paths within a given domain.

        :param category: The category of this FlowPathsQuery.
        :type: str
        """
        if isinstance(category, int):
            category = str(category)
        allowed_values = ["All", "Abandoned", "AgentEscalation", "Complete", "Disconnect", "Error", "RecognitionFailure", "Transfer"]
        if category.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for category -> " + category)
            self._category = "outdated_sdk_version"
        else:
            self._category = category

    @property
    def flows(self) -> List['FlowPathsFlowFilter']:
        """
        Gets the flows of this FlowPathsQuery.
        List of flows to query the paths result.

        :return: The flows of this FlowPathsQuery.
        :rtype: list[FlowPathsFlowFilter]
        """
        return self._flows

    @flows.setter
    def flows(self, flows: List['FlowPathsFlowFilter']) -> None:
        """
        Sets the flows of this FlowPathsQuery.
        List of flows to query the paths result.

        :param flows: The flows of this FlowPathsQuery.
        :type: list[FlowPathsFlowFilter]
        """
        

        self._flows = flows

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

