# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class ForecastMetadata(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ForecastMetadata - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'date_created': 'datetime',
            'forecast_id': 'str',
            'interval_length_in_minutes': 'str',
            'source': 'str',
            'date_start': 'datetime',
            'time_zone': 'str'
        }

        self.attribute_map = {
            'date_created': 'dateCreated',
            'forecast_id': 'forecastId',
            'interval_length_in_minutes': 'intervalLengthInMinutes',
            'source': 'source',
            'date_start': 'dateStart',
            'time_zone': 'timeZone'
        }

        self._date_created = None
        self._forecast_id = None
        self._interval_length_in_minutes = None
        self._source = None
        self._date_start = None
        self._time_zone = None

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this ForecastMetadata.
        Forecast creation date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this ForecastMetadata.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this ForecastMetadata.
        Forecast creation date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this ForecastMetadata.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def forecast_id(self) -> str:
        """
        Gets the forecast_id of this ForecastMetadata.
        Forecast ID

        :return: The forecast_id of this ForecastMetadata.
        :rtype: str
        """
        return self._forecast_id

    @forecast_id.setter
    def forecast_id(self, forecast_id: str) -> None:
        """
        Sets the forecast_id of this ForecastMetadata.
        Forecast ID

        :param forecast_id: The forecast_id of this ForecastMetadata.
        :type: str
        """
        

        self._forecast_id = forecast_id

    @property
    def interval_length_in_minutes(self) -> str:
        """
        Gets the interval_length_in_minutes of this ForecastMetadata.
        Interval length

        :return: The interval_length_in_minutes of this ForecastMetadata.
        :rtype: str
        """
        return self._interval_length_in_minutes

    @interval_length_in_minutes.setter
    def interval_length_in_minutes(self, interval_length_in_minutes: str) -> None:
        """
        Sets the interval_length_in_minutes of this ForecastMetadata.
        Interval length

        :param interval_length_in_minutes: The interval_length_in_minutes of this ForecastMetadata.
        :type: str
        """
        

        self._interval_length_in_minutes = interval_length_in_minutes

    @property
    def source(self) -> str:
        """
        Gets the source of this ForecastMetadata.
        Forecast source

        :return: The source of this ForecastMetadata.
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source: str) -> None:
        """
        Sets the source of this ForecastMetadata.
        Forecast source

        :param source: The source of this ForecastMetadata.
        :type: str
        """
        if isinstance(source, int):
            source = str(source)
        allowed_values = ["AutomaticBestMethod", "MainForecast"]
        if source.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for source -> " + source)
            self._source = "outdated_sdk_version"
        else:
            self._source = source

    @property
    def date_start(self) -> datetime:
        """
        Gets the date_start of this ForecastMetadata.
        Forecast start date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_start of this ForecastMetadata.
        :rtype: datetime
        """
        return self._date_start

    @date_start.setter
    def date_start(self, date_start: datetime) -> None:
        """
        Sets the date_start of this ForecastMetadata.
        Forecast start date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_start: The date_start of this ForecastMetadata.
        :type: datetime
        """
        

        self._date_start = date_start

    @property
    def time_zone(self) -> str:
        """
        Gets the time_zone of this ForecastMetadata.
        Timezone of the business unit

        :return: The time_zone of this ForecastMetadata.
        :rtype: str
        """
        return self._time_zone

    @time_zone.setter
    def time_zone(self, time_zone: str) -> None:
        """
        Sets the time_zone of this ForecastMetadata.
        Timezone of the business unit

        :param time_zone: The time_zone of this ForecastMetadata.
        :type: str
        """
        

        self._time_zone = time_zone

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

